/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.util.FastVector;
import oracle.xml.util.QxNameHash;

public class XSDAny
extends XSDNode
implements XSDParticleNode {
    int minOccurs;
    int maxOccurs;
    String processContents;
    String namespace;
    HashMap nsList;
    static final QName ANY_NAME = QxNameHash.create((String)"", (String)"*", (String)"", (String)"*");

    XSDAny() {
        this(0);
    }

    XSDAny(int n) {
        this.name = ":any";
        this.nodeType = n;
        this.processContents = "strict";
        this.namespace = "##any";
        if (n == 0) {
            this.minOccurs = 1;
            this.maxOccurs = 1;
        } else {
            this.minOccurs = 0;
            this.maxOccurs = 0x7FFFFFF8;
        }
    }

    HashMap resolveTargetNS() {
        String string = this.getTargetNS();
        if (this.namespace == "##other") {
            this.namespace = string;
            return null;
        }
        if (this.namespace == "##targetNamespace") {
            this.namespace = string;
        }
        if (this.nsList == null) {
            return null;
        }
        if (this.nsList.get("##targetNamespace") == null) {
            return this.nsList;
        }
        this.nsList.put(string, string);
        this.nsList.remove("##targetNamespace");
        return this.nsList;
    }

    boolean isSubSet(XSDAny xSDAny) {
        if (this.namespace == "##any") {
            return true;
        }
        if (this.namespace != "##list" && this.namespace == xSDAny.namespace) {
            return true;
        }
        if (xSDAny.namespace != "##list") {
            return false;
        }
        HashMap hashMap = xSDAny.nsList;
        if (this.namespace != "##list" && hashMap.get(this.namespace) == null) {
            return true;
        }
        for (String string : hashMap.keySet()) {
            if (this.nsList.get(string) != null) continue;
            return false;
        }
        return true;
    }

    XSDAny intersectWith(XSDAny xSDAny) {
        HashMap hashMap = xSDAny.resolveTargetNS();
        if (xSDAny.namespace == "##any") {
            return this;
        }
        if (this.namespace == "##any") {
            this.namespace = xSDAny.namespace;
            if (hashMap != null) {
                this.nsList = (HashMap)hashMap.clone();
            }
            return this;
        }
        if (this.namespace != "##list" && hashMap != null) {
            this.nsList = (HashMap)hashMap.clone();
            this.nsList.remove(this.namespace);
            this.namespace = "##list";
            return this;
        }
        if (xSDAny.namespace != "##list" && this.nsList != null) {
            this.nsList.remove(xSDAny.namespace);
        } else if (hashMap != null && this.nsList != null) {
            for (String string : this.nsList.keySet()) {
                if (hashMap.get(string) != null) continue;
                this.nsList.remove(string);
            }
        }
        return this;
    }

    XSDAny unionWith(XSDAny xSDAny) {
        HashMap hashMap = xSDAny.resolveTargetNS();
        if (this.namespace == "##any") {
            return this;
        }
        if (xSDAny.namespace == "##any") {
            this.namespace = "##any";
            this.nsList = null;
            return this;
        }
        if (this.namespace != "##list") {
            if (xSDAny.namespace != "##list") {
                if (!this.namespace.equals(xSDAny.namespace)) {
                    this.namespace = "##any";
                }
                return this;
            }
            if (hashMap.get(this.namespace) != null) {
                this.namespace = "##any";
            }
            return this;
        }
        if (xSDAny.namespace != "##list") {
            this.namespace = this.nsList.get(xSDAny.namespace) != null ? "##any" : xSDAny.namespace;
            this.nsList = null;
        } else if (hashMap != null && this.nsList != null) {
            for (String string : hashMap.keySet()) {
                this.nsList.put(string, string);
            }
        }
        return this;
    }

    XSDNode getMatchingAttr(XMLSchema xMLSchema, String string, String string2) {
        if (this.isMatched(string)) {
            return this.getMatchingNode(xMLSchema, string, string2);
        }
        return null;
    }

    boolean isMatched(String string) {
        if (this.namespace == "##any") {
            return true;
        }
        if (this.namespace != "##list" && !string.equals("") && !string.equals(this.namespace)) {
            return true;
        }
        if (this.nsList != null) {
            return this.nsList.get(string) != null;
        }
        return false;
    }

    XSDNode getMatchingNode(XMLSchema xMLSchema, String string, String string2) {
        XSDNode xSDNode = null;
        if (this.processContents == "skip") {
            return FAKE_NODE;
        }
        xSDNode = this.nodeType == 0 ? xMLSchema.getElement(string, string2) : xMLSchema.getAttribute(string, string2);
        if (this.processContents == "lax" && xSDNode == null) {
            return FAKE_NODE;
        }
        return xSDNode;
    }

    void setProcessContents(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 != "skip" && string2 != "lax" && string2 != "strict") {
            throw new XSDException();
        }
        this.processContents = string2;
    }

    public String getProcessContents() {
        return this.processContents;
    }

    public boolean isEmptiable() {
        return this.minOccurs == 0;
    }

    public String getNamespaceNotAllowed() {
        if (this.namespace != "##list" && this.namespace != "##any") {
            return this.namespace;
        }
        return null;
    }

    public boolean isAnyNamespaceAllowed() {
        return this.namespace == "##any";
    }

    public String[] getNamespaceAllowed() {
        String[] stringArray = null;
        if (this.namespace == "##list") {
            this.resolveTargetNS();
            int n = 0;
            stringArray = new String[this.nsList.size()];
            Iterator iterator = this.nsList.keySet().iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = (String)iterator.next();
            }
        }
        return stringArray;
    }

    public String[] getNamespaceConstraint() {
        String[] stringArray;
        if (this.namespace != "##list") {
            stringArray = new String[]{this.namespace};
        } else {
            this.resolveTargetNS();
            int n = 0;
            stringArray = new String[this.nsList.size()];
            Iterator iterator = this.nsList.keySet().iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = (String)iterator.next();
            }
        }
        return stringArray;
    }

    void setNamespace(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 == "##any" || string2 == "##other") {
            this.namespace = string2;
        } else {
            this.namespace = "##list";
            this.nsList = new HashMap(10);
            int n = string.length();
            int n2 = 0;
            char[] cArray = string.toCharArray();
            boolean bl = false;
            boolean bl2 = false;
            while (n2 < n) {
                while (n2 < n && cArray[n2] == ' ') {
                    ++n2;
                }
                if (n2 >= n) break;
                int n3 = n2;
                while (n2 < n && cArray[n2] != ' ') {
                    ++n2;
                }
                string2 = new String(cArray, n3, n2 - n3);
                if (XSDSimpleType.isURI(string2) || string2.equals("##targetNamespace")) {
                    this.nsList.put(string2, string2);
                    continue;
                }
                if (string2.equals("##local")) {
                    this.nsList.put("", "");
                    continue;
                }
                throw new XSDException();
            }
        }
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMinOccurs(int n) {
        this.minOccurs = n;
    }

    public void setMaxOccurs(int n) {
        this.maxOccurs = n;
    }

    void print(int n) {
        this.printSTag(n);
        System.out.println(XSDAny.indent(n) + "minOccurs = " + this.minOccurs);
        System.out.println(XSDAny.indent(n) + "maxOccurs = " + this.maxOccurs);
        if (this.processContents != null) {
            System.out.println(XSDAny.indent(n) + "processContents = " + this.processContents);
        }
        if (this.namespace != null) {
            System.out.print(XSDAny.indent(n) + "namespace = ");
            if (this.namespace == "##list") {
                for (String string : this.nsList.keySet()) {
                    System.out.print(string + " ");
                }
                System.out.println();
            } else {
                System.out.println(this.namespace);
            }
        }
        super.printEmptySTag(n);
    }

    void printSTag(int n) {
        System.out.print(XSDAny.indent(n));
        System.out.print("<");
        this.print();
        System.out.println();
        if (this.id != null) {
            System.out.println(XSDAny.indent(n) + "id = " + this.id);
        }
    }

    boolean buildPathTable(FastVector fastVector, byte[] byArray, int n) {
        byArray[fastVector.size()] = (byte)(n + 1);
        fastVector.addElement((Object)this);
        return true;
    }

    void buildPaths(HashMap hashMap, int n) {
        XSDElement.addPath(hashMap, this, n);
    }

    int postProcess(FastVector fastVector, Hashtable hashtable) throws Exception {
        this.isClean = false;
        if (this.namespace == "##other") {
            this.namespace = this.getTargetNS();
        } else if (this.nsList != null && this.nsList.get("##targetNamespace") != null) {
            this.nsList.remove("##targetNamespace");
            String string = this.getTargetNS();
            this.nsList.put(string, string);
        }
        return 1;
    }

    public QName getQName() {
        return ANY_NAME;
    }

    public String getName() {
        return null;
    }
}

