/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.io.IOException;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.jdeveloper.compare.PatchCompareContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.compare.Stream;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdevimpl.compare.XmlContextFactory;

public class URLContributor
extends TextCompareContributor
implements PatchCompareContributor {
    private final URL _url;
    private final TextBuffer _buffer;
    private final StreamType _streamType;
    private String _type;
    private PatchCompareDescriptor _patchDescriptor;

    public URLContributor(URL url) throws IOException {
        this(null, url);
    }

    public URLContributor(URL nodeUrl, URL dataUrl) throws IOException {
        this(URLFileSystem.getSuffix((URL)(nodeUrl != null ? nodeUrl : dataUrl)), nodeUrl, dataUrl);
    }

    public URLContributor(String suffix, URL nodeUrl, URL dataUrl) throws IOException {
        this._url = dataUrl;
        Stream stream = StreamDecoder.getStream(suffix, URLFileSystem.openInputStream((URL)dataUrl), StreamDecoder.getDefaultEncoding(nodeUrl != null ? nodeUrl : dataUrl));
        this._buffer = TextBufferFactory.createTextBuffer();
        this._buffer.read(stream.getReader());
        this._type = URLContributor.getPlatformPathSuffix(this._url);
        this._streamType = stream.getType();
        Node node = NodeFactory.find((URL)dataUrl);
        this.setDocumentModel(node != null ? XmlContextFactory.getXmlContextFactory().findOrCreateContext(new Context(node)) : null);
    }

    public URL getURL() {
        return this._url;
    }

    protected static String getPlatformPathSuffix(URL url) {
        String platformPath = URLFileSystem.getPlatformPathName((URL)url);
        int lastDot = platformPath.lastIndexOf(46);
        if (lastDot < 0 || lastDot > platformPath.length() - 2) {
            return "";
        }
        return platformPath.substring(lastDot + 1);
    }

    public TextBuffer getTextBuffer() {
        return this._buffer;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getShortLabel() {
        return URLFileSystem.getFileName((URL)this._url);
    }

    public String getLongLabel() {
        return URLFileSystem.getPlatformPathName((URL)this._url);
    }

    public PatchCompareDescriptor getPatchDescriptor() {
        if (this._patchDescriptor != null) {
            return this._patchDescriptor;
        }
        this._patchDescriptor = new PatchCompareDescriptor(URLFileSystem.getFileName((URL)this._url));
        this._patchDescriptor.setPatchParentURL(URLFileSystem.getParent((URL)this._url));
        this._patchDescriptor.setLastModified(URLFileSystem.lastModified((URL)this._url));
        return this._patchDescriptor;
    }

    public StreamType getStreamType() {
        return this._streamType;
    }
}

