/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import oracle.ide.Ide;
import oracle.ide.util.Assert;
import oracle.jdeveloper.history.CustomFilter;
import oracle.jdeveloper.history.CustomFilterCopyable;
import oracle.jdeveloper.history.CustomFilterSubstitution;
import oracle.jdeveloper.resource.HistoryArb;

public class CustomFilterManager {
    private static final String CUSTOM_FILTERS_DATA_KEY = "HistoryManager.CustomFilters";
    private CustomFilter[] _customFilters;
    private final Collection _substitutions;
    private final Observable _customFilterObservable;

    private void $init$() {
        this._substitutions = new ArrayList();
        this._customFilterObservable = new 1();
    }

    public CustomFilter[] getFilters() {
        if (this._customFilters != null) {
            return this._customFilters;
        }
        Collection copyableFilterList = (Collection)Ide.getDTCache().getData(CUSTOM_FILTERS_DATA_KEY);
        if (copyableFilterList == null) {
            this._customFilters = this.createDefaultFilters();
            this.persistFilters(this._customFilters);
            return this._customFilters;
        }
        ArrayList<CustomFilter> customFilters = new ArrayList<CustomFilter>();
        for (CustomFilterCopyable copyableFilter : copyableFilterList) {
            try {
                CustomFilter filter = CustomFilter.parse(copyableFilter.getSource());
                filter.setName(copyableFilter.getName());
                customFilters.add(filter);
            }
            catch (ParseException pe) {
                // empty catch block
            }
        }
        this._customFilters = customFilters.toArray(new CustomFilter[0]);
        return this._customFilters;
    }

    public void setFilters(CustomFilter[] customFilters) {
        this._customFilters = customFilters;
        this.persistFilters(this._customFilters);
        this._customFilterObservable.notifyObservers();
    }

    public CustomFilter[] createDefaultFilters() {
        try {
            ArrayList<CustomFilter> customFilters = new ArrayList<CustomFilter>();
            CustomFilter filter = CustomFilter.parse("DATE = ${system.date}");
            filter.setName(HistoryArb.getString(14));
            customFilters.add(filter);
            filter = CustomFilter.parse("DATE >= ${system.date} - 7");
            filter.setName(HistoryArb.getString(19));
            customFilters.add(filter);
            filter = CustomFilter.parse("AUTHOR = ${system.user} OR AUTHOR = ${versioning.user} OR REVISION MATCHES REGEXP:(?i)local");
            filter.setName(HistoryArb.getString(25));
            customFilters.add(filter);
            filter = CustomFilter.parse("NOT DESCRIPTION MATCHES REGEXP:^$|^\\[.*\\]$|^\\*\\*\\*.+\\*\\*\\*$");
            filter.setName(HistoryArb.getString(23));
            customFilters.add(filter);
            filter = CustomFilter.parse("TAGS MATCHES REGEXP:.+");
            filter.setName(HistoryArb.getString(1));
            customFilters.add(filter);
            CustomFilter[] customFilterArray = customFilters.toArray(new CustomFilter[0]);
            return customFilterArray;
        }
        catch (ParseException pe) {
            Assert.printStackTrace((Throwable)pe);
            CustomFilter[] customFilterArray = null;
            return customFilterArray;
        }
    }

    public Observable getFilterObservable() {
        return this._customFilterObservable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubstitution(CustomFilterSubstitution substitution) {
        if (substitution == null) {
            return;
        }
        Collection collection = this._substitutions;
        synchronized (collection) {
            this._substitutions.add(substitution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterSubstitution(CustomFilterSubstitution substitution) {
        Collection collection = this._substitutions;
        synchronized (collection) {
            this._substitutions.remove(substitution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomFilterSubstitution[] getSubstitutions() {
        Collection collection = this._substitutions;
        synchronized (collection) {
            CustomFilterSubstitution[] customFilterSubstitutionArray = this._substitutions.toArray(new CustomFilterSubstitution[0]);
            return customFilterSubstitutionArray;
        }
    }

    private void persistFilters(CustomFilter[] customFilters) {
        if (customFilters == null) {
            return;
        }
        ArrayList<CustomFilterCopyable> copyableFilterList = new ArrayList<CustomFilterCopyable>();
        int i = 0;
        while (i < customFilters.length) {
            CustomFilterCopyable copyableFilter = new CustomFilterCopyable();
            copyableFilter.setName(customFilters[i].getName());
            copyableFilter.setSource(customFilters[i].getSource());
            copyableFilterList.add(copyableFilter);
            ++i;
        }
        Ide.getDTCache().putData(CUSTOM_FILTERS_DATA_KEY, copyableFilterList);
    }

    public CustomFilterManager() {
        this.$init$();
    }

    final class 1
    extends Observable {
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    }
}

