/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;

public class HistoryEntrySelector {
    public static final HistoryEntrySelector CURRENT_REVISION = new 1();
    public static final HistoryEntrySelector PREVIOUS_REVISION = new 2();
    public static final HistoryEntrySelector LATEST_REVISION = new 3();
    private final String _revision;

    public HistoryEntrySelector() {
        this(null);
    }

    public HistoryEntrySelector(String revision) {
        this._revision = revision;
    }

    public HistoryEntry select(HistoryModel historyModel) {
        if (this._revision == null) {
            return historyModel.getSize() > 0 ? historyModel.getEntry(0) : null;
        }
        return HistoryEntrySelector.findEntryForRevision(historyModel, this._revision);
    }

    private static final RevisionIdentifier[] createSortedRevisionList(HistoryModel historyModel) {
        ArrayList<RevisionIdentifier> list = new ArrayList<RevisionIdentifier>();
        int i = 0;
        while (i < historyModel.getSize()) {
            RevisionIdentifier revisionIdentifier = (RevisionIdentifier)historyModel.getEntry(i).getValue(SharedProperties.getRevisionProperty());
            if (revisionIdentifier != null) {
                list.add(revisionIdentifier);
            }
            ++i;
        }
        Collections.sort(list);
        return list.toArray(new RevisionIdentifier[list.size()]);
    }

    private static final HistoryEntry findEntryForRevision(HistoryModel historyModel, String revision) {
        int i = 0;
        while (i < historyModel.getSize()) {
            HistoryEntry historyEntry = historyModel.getEntry(i);
            if (((RevisionIdentifier)historyEntry.getValue(SharedProperties.getRevisionProperty())).getLabel().equals(revision)) {
                return historyEntry;
            }
            ++i;
        }
        return null;
    }

    static RevisionIdentifier[] maS$createSortedRevisionList(HistoryModel historyModel) {
        return HistoryEntrySelector.createSortedRevisionList(historyModel);
    }

    static HistoryEntry maS$findEntryForRevision(HistoryModel historyModel, String string) {
        return HistoryEntrySelector.findEntryForRevision(historyModel, string);
    }

    static final class 1
    extends HistoryEntrySelector {
        public HistoryEntry select(HistoryModel historyModel) {
            int i = 0;
            while (i < historyModel.getSize()) {
                HistoryEntry historyEntry = historyModel.getEntry(i);
                RevisionIdentifier revisionIdentifier = (RevisionIdentifier)historyEntry.getValue(SharedProperties.getRevisionProperty());
                if (revisionIdentifier != null && revisionIdentifier.isCurrent()) {
                    return historyEntry;
                }
                ++i;
            }
            return null;
        }
    }

    static final class 2
    extends HistoryEntrySelector {
        public HistoryEntry select(HistoryModel historyModel) {
            HistoryEntry historyEntry = CURRENT_REVISION.select(historyModel);
            if (historyEntry == null) {
                return null;
            }
            Object[] list = HistoryEntrySelector.maS$createSortedRevisionList(historyModel);
            int i = Arrays.binarySearch(list, historyEntry.getValue(SharedProperties.getRevisionProperty()));
            return i <= 0 ? historyEntry : HistoryEntrySelector.maS$findEntryForRevision(historyModel, ((RevisionIdentifier)list[i - 1]).getLabel());
        }
    }

    static final class 3
    extends HistoryEntrySelector {
        public HistoryEntry select(HistoryModel historyModel) {
            RevisionIdentifier[] list = HistoryEntrySelector.maS$createSortedRevisionList(historyModel);
            return list.length > 0 ? HistoryEntrySelector.maS$findEntryForRevision(historyModel, list[list.length - 1].getLabel()) : null;
        }
    }
}

