/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.DefaultKeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLPath;
import oracle.ide.panels.Navigable;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.MenuSpec;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareHints;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.algorithm.directory.DirectoryCompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.directory.DirectoryList;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.compare.CompareResourceProvider;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdevimpl.compare.CompareController;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.compare.CompareMethod;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.compare.CompareOptions;
import oracle.jdevimpl.compare.ComparePreferencesPanel;
import oracle.jdevimpl.compare.CompareURLHelper;
import oracle.jdevimpl.compare.SearchNavigable;
import oracle.jdevimpl.resource.CompareArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareAddin
extends EditorAddin {
    private CompareIdeViewer m_compareIdeViewer;
    private MenuSpec m_menuSpec;
    int m_otherFileAction;
    int m_savedFileAction;
    int m_eachOtherAction;
    private MyController m_controller;
    static final String KEY_CONTEXT = "compareKeyContext";
    public static final String COMPARE_DIRECTORY_FILE_CMD = "compare.compareDirectoryFile";
    public static final int COMPARE_DIRECTORY_FILE_CMD_ID = Ide.findOrCreateCmdID((String)"compare.compareDirectoryFile");
    public static final String GO_FIRST_CMD = "compare.navigateFirst";
    public static final int GO_FIRST_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigateFirst");
    public static final String GO_PREVIOUS_CMD = "compare.navigatePrevious";
    public static final int GO_PREVIOUS_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigatePrevious");
    public static final String GO_NEXT_CMD = "compare.navigateNext";
    public static final int GO_NEXT_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigateNext");
    public static final String GO_LAST_CMD = "compare.navigateLast";
    public static final int GO_LAST_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigateLast");
    private Navigable _compareNavigable;
    private Collection<CompareMethod> _compareMethods;
    private static String _createPatchCommand;
    private static int _createPatchCommandId;
    private static Controller _patchController;

    private void $init$() {
        this._compareMethods = new ArrayList<CompareMethod>();
        this.registerCompareMethod(new 1());
    }

    public CompareAddin() {
        this.$init$();
        this.m_compareIdeViewer = new CompareIdeViewer(this);
    }

    CompareIdeViewer getCompareIdeViewer() {
        return this.m_compareIdeViewer;
    }

    public Navigable getCompareNavigable() {
        return this._compareNavigable;
    }

    public void registerCompareMethod(CompareMethod compareMethod) {
        this._compareMethods.add(compareMethod);
    }

    public Collection<CompareMethod> getCompareMethods() {
        return Collections.unmodifiableCollection(this._compareMethods);
    }

    private void compareOtherFile(Context context) throws Exception {
        int result;
        URLContributor right = null;
        URL url = null;
        try {
            if (context.getSelection().length == 1) {
                if (context.getSelection()[0] instanceof CompareResourceProvider && ((CompareResourceProvider)context.getSelection()[0]).getContributor() != null) {
                    right = ((CompareResourceProvider)context.getSelection()[0]).getContributor();
                } else {
                    url = this.getSelectionURL(context.getSelection()[0]);
                    if (url != null) {
                        right = URLFileSystem.isDirectoryPath((URL)url) ? this.createDirectoryContributor(url) : new URLContributor(url);
                    }
                }
            } else {
                url = context.getNode().getURL();
                right = new URLContributor(url);
            }
        }
        catch (IOException ex) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.format(31, URLFileSystem.getName(url)), (String)CompareArb.getString(38), null);
            return;
        }
        URLChooser chooser = DialogUtil.newURLChooser((Context)context);
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(url == null || !URLFileSystem.isDirectoryPath((URL)url) ? 0 : 1);
        if (url != null) {
            chooser.setSelectedURL(url);
        }
        if ((result = chooser.showOpenDialog((Component)Ide.getMainWindow(), CompareArb.getString(37))) == 0) {
            URL otherUrl = chooser.getSelectedURL();
            if (URLFileSystem.isDirectory((URL)url) != URLFileSystem.isDirectory((URL)otherUrl)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.getString(50), (String)CompareArb.getString(27), null);
            } else if (otherUrl != null && otherUrl.equals(url)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.getString(4), (String)CompareArb.getString(34), null);
            } else if (!URLFileSystem.exists((URL)otherUrl)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.getString(36), (String)CompareArb.getString(55), null);
            } else {
                Object left = null;
                try {
                    Node node = NodeFactory.findOrCreate((URL)otherUrl);
                    if (node instanceof CompareResourceProvider) {
                        left = ((CompareResourceProvider)node).getContributor();
                    }
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
                if (left == null) {
                    left = URLFileSystem.isDirectoryPath((URL)otherUrl) ? this.createDirectoryContributor(otherUrl) : new URLContributor(otherUrl);
                }
                this.m_compareIdeViewer.show((CompareContributor)left, (CompareContributor)right);
            }
        }
    }

    private void compareSavedFile(Context context) throws Exception {
        URLContributor left = null;
        TextNodeContributor right = null;
        if (context.getSelection().length == 0 && context.getNode() != null) {
            left = new URLContributor(context.getNode().getURL());
            right = new TextNodeContributor((TextNode)context.getNode());
        }
        if (context.getSelection().length > 0) {
            if (context.getSelection()[0] instanceof CompareResourceProvider && ((CompareResourceProvider)context.getSelection()[0]).getContributor() != null) {
                left = new URLContributor(context.getNode().getURL());
                right = ((CompareResourceProvider)context.getSelection()[0]).getContributor();
            } else if (context.getSelection()[0] instanceof TextNode) {
                left = new URLContributor(((TextNode)context.getSelection()[0]).getURL());
                right = new TextNodeContributor((TextNode)context.getSelection()[0]);
            } else {
                left = new URLContributor(context.getNode().getURL());
                right = new TextNodeContributor((TextNode)context.getNode());
            }
        }
        if (left == null) {
            Assert.fail();
            return;
        }
        this.m_compareIdeViewer.show((CompareContributor)left, (CompareContributor)right);
    }

    private void compareEachOther(Context context) throws Exception {
        URL url;
        Object left;
        Element[] sel = context.getSelection();
        if (sel[0] instanceof CompareResourceProvider && ((CompareResourceProvider)sel[0]).getContributor() != null) {
            left = ((CompareResourceProvider)sel[0]).getContributor();
        } else {
            URL url2 = this.getSelectionURL(sel[0]);
            URLContributor uRLContributor = left = URLFileSystem.isDirectoryPath((URL)url2) ? this.createDirectoryContributor(url2) : new URLContributor(url2);
        }
        Object right = sel[1] instanceof CompareResourceProvider && ((CompareResourceProvider)sel[1]).getContributor() != null ? ((CompareResourceProvider)sel[1]).getContributor() : (URLFileSystem.isDirectoryPath((URL)(url = this.getSelectionURL(sel[1]))) ? this.createDirectoryContributor(url) : new URLContributor(url));
        this.m_compareIdeViewer.show((CompareContributor)left, (CompareContributor)right);
    }

    private CompareContributor createDirectoryContributor(URL directoryUrl) {
        2 contrib = new 2();
        contrib.setShortLabel(URLFileSystem.getFileName((URL)directoryUrl));
        contrib.setLongLabel(URLFileSystem.getPlatformPathName((URL)directoryUrl));
        DirectoryList directoryList = new DirectoryList();
        URLFileSystem.FileInfo[] fileInfoArray = URLFileSystem.ls((URL)directoryUrl);
        int n = 0;
        while (n < fileInfoArray.length) {
            URLFileSystem.FileInfo info = fileInfoArray[n];
            directoryList.appendFile((DirectoryFile)new 3(this, info.isDirectory(), URLFileSystem.getFileName((URL)info.getURL()), info.isDirectory() ? "" : Long.toString(this.computeChecksum(info.getURL())), info));
            ++n;
        }
        directoryList.clearModified();
        contrib.setDirectoryList(directoryList);
        return contrib;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long computeChecksum(URL url) {
        CheckedInputStream cis = null;
        try {
            cis = new CheckedInputStream(URLFileSystem.openInputStream((URL)url), new Adler32());
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return 0L;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return 0L;
        }
        try {
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            long l = cis.getChecksum().getValue();
            return l;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            long l2 = 0L;
            try {
                cis.close();
                return l2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return l2;
        }
        finally {
            try {
                cis.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void initialize() {
        IdeAction selectAllAction;
        URLFileSystem.registerHelper((String)"ide.compare", (URLFileSystemHelper)new CompareURLHelper());
        EditorManager.getEditorManager().register((EditorAddin)this, new Class[]{CompareNode.class});
        Ide.getMenubar().add((Component)this.m_compareIdeViewer.getMainCompareMenu(), MenuManager.getJMenu((String)"File"), MenuConstants.SECTION_FILE_ADDINS);
        this.m_controller = new MyController(null);
        String name = CompareArb.getString(18);
        Integer mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)name));
        name = StringUtils.stripMnemonic((String)name);
        this.m_savedFileAction = Ide.findOrCreateCmdID((String)"compare.CompareDirty");
        IdeAction compareDirtyAction = IdeAction.get((int)this.m_savedFileAction, null, (String)name, (String)IdeMainWindow.ACTION_CATEGORY_FILE, (Integer)mnemonic, null, null, (boolean)true);
        compareDirtyAction.putValue("NoCtxName", (Object)CompareArb.getString(25));
        compareDirtyAction.addController((Controller)this.m_controller);
        name = CompareArb.getString(45);
        mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)name));
        name = StringUtils.stripMnemonic((String)name);
        this.m_otherFileAction = Ide.findOrCreateCmdID((String)"compare.CompareOther");
        IdeAction compareOtherAction = IdeAction.get((int)this.m_otherFileAction, null, (String)name, (String)IdeMainWindow.ACTION_CATEGORY_FILE, (Integer)mnemonic, null, null, (boolean)true);
        compareOtherAction.putValue("NoCtxName", (Object)CompareArb.getString(3));
        compareOtherAction.addController((Controller)this.m_controller);
        name = CompareArb.getString(49);
        mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)name));
        name = StringUtils.stripMnemonic((String)name);
        this.m_eachOtherAction = Ide.findOrCreateCmdID((String)"compare.CompareEachOther");
        IdeAction compareEachOtherAction = IdeAction.get((int)this.m_eachOtherAction, null, (String)name, (String)IdeMainWindow.ACTION_CATEGORY_FILE, (Integer)mnemonic, null, null, (boolean)true);
        compareEachOtherAction.putValue("NoCtxName", (Object)CompareArb.getString(14));
        compareEachOtherAction.addController((Controller)this.m_controller);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareDirtyAction, 1.0f), this.m_compareIdeViewer.getMainCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareOtherAction, 2.0f), this.m_compareIdeViewer.getMainCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareEachOtherAction, 1.0f), this.m_compareIdeViewer.getMainCompareMenu(), 2.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareDirtyAction, 1.0f), this.m_compareIdeViewer.getContextCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareOtherAction, 2.0f), this.m_compareIdeViewer.getContextCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareEachOtherAction, 1.0f), this.m_compareIdeViewer.getContextCompareMenu(), 2.0f);
        this._compareNavigable = new SearchNavigable(CompareArb.getString(19), ComparePreferencesPanel.class, new String[]{CompareArb.getString(47), CompareArb.getString(20)});
        IdeSettings.registerUI((Navigable)this._compareNavigable);
        IdeAction goFirstAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_FIRST_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString(23)), (String)CompareArb.getString(43), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(23))), (ArrayResourceBundle)CompareArb.getInstance(), (int)6, null, (boolean)false);
        IdeAction goPreviousAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_PREVIOUS_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString(54)), (String)CompareArb.getString(43), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(54))), (ArrayResourceBundle)CompareArb.getInstance(), (int)35, null, (boolean)false);
        IdeAction goNextAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_NEXT_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString(1)), (String)CompareArb.getString(43), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(1))), (ArrayResourceBundle)CompareArb.getInstance(), (int)46, null, (boolean)false);
        IdeAction goLastAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_LAST_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString(52)), (String)CompareArb.getString(43), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(52))), (ArrayResourceBundle)CompareArb.getInstance(), (int)33, null, (boolean)false);
        IdeAction compareDirectoryAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)COMPARE_DIRECTORY_FILE_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString(5)), (String)CompareArb.getString(43), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(5))), (ArrayResourceBundle)CompareArb.getInstance(), (int)8, null, (boolean)false);
        compareDirectoryAction.addController((Controller)CompareController.getDefaultController());
        Ide.addIdeListener((IdeListener)new 4());
        Ide.getKeyStrokeContextRegistry().addContext((KeyStrokeContext)new 5(this, goFirstAction, goPreviousAction, goNextAction, goLastAction, compareDirectoryAction));
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/compare/accelerators.xml");
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)new 6());
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)new 7());
        try {
            InitialContext ic = new InitialContext();
            try {
                ic.lookup("jdeveloper");
            }
            catch (NamingException ne) {
                ic.createSubcontext("jdeveloper");
            }
            ic.bind("jdeveloper/compareviewer", (Object)this.m_compareIdeViewer);
        }
        catch (NamingException ne) {
            ExceptionDialog.showExceptionDialog((Component)null, (Throwable)ne);
        }
        IdeAction copyAction = IdeAction.find((int)18);
        if (copyAction != null) {
            copyAction.addController((Controller)this.m_controller);
        }
        if ((selectAllAction = IdeAction.find((int)22)) != null) {
            selectAllAction.addController((Controller)this.m_controller);
        }
        Preferences prefs = Preferences.getPreferences();
        IdeSettings ideSettings = Ide.getSettings();
        ideSettings.putLegacyData("compareOptions", (Copyable)CompareOptions.getInstance((PropertyStorage)prefs));
        this.initializeSettings();
    }

    public Class getEditorClass() {
        return CompareEditor.class;
    }

    public boolean isDefault() {
        return true;
    }

    public MenuSpec getMenuSpecification() {
        if (this.m_menuSpec == null) {
            this.m_menuSpec = new MenuSpec(CompareArb.getString(40), null, null, null);
        }
        return this.m_menuSpec;
    }

    public Object getAttribute(Object key) {
        if (key.equals("no-recent-file")) {
            return Boolean.FALSE;
        }
        if (key.equals("restorable-from-url")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public float getEditorWeight(Element element) {
        return Float.NaN;
    }

    public boolean isDuplicable() {
        return false;
    }

    public boolean restoreAtStartup() {
        return false;
    }

    private URL getSelectionURL(Element selection) {
        if (selection instanceof RelativeDirectoryContextFolder) {
            return this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection);
        }
        if (selection instanceof Locatable) {
            return ((Locatable)selection).getURL();
        }
        return null;
    }

    private URL getDirectoryCompareURL(RelativeDirectoryContextFolder selection) {
        RelativeDirectoryContextFolder directoryContextFolder = selection;
        URLPath rootDirectoryPath = directoryContextFolder.getRootDirectories();
        Iterator itr = rootDirectoryPath.iterator();
        if (itr.hasNext()) {
            return URLFactory.newDirURL((URL)((URL)itr.next()), (String)directoryContextFolder.getRelativePath());
        }
        return null;
    }

    private void initializeSettings() {
        Preferences p = Preferences.getPreferences();
        CompareOptions co = CompareOptions.getInstance((PropertyStorage)p);
        CompareHints.setIgnoreWhiteSpace((boolean)co.getIgnoreWhitespace());
        CompareHints.setShowCharDifferences((boolean)co.getShowCharDifferences());
    }

    boolean isValidCompareURL(URL url) {
        if (url == null || !URLFileSystem.isLocal((URL)url) || !URLFileSystem.exists((URL)url)) {
            return false;
        }
        if (URLFileSystem.isDirectoryPath((URL)url)) {
            return true;
        }
        return CompareViewer.isContentComparable(url);
    }

    public static String getCreatePatchCommand() {
        return _createPatchCommand;
    }

    public static void setCreatePatchCommand(String createPatchCommand) {
        _createPatchCommand = createPatchCommand;
    }

    public static int getCreatePatchCommandID() {
        return _createPatchCommandId;
    }

    public static void setCreatePatchCommandID(int createPatchCommandId) {
        _createPatchCommandId = createPatchCommandId;
    }

    public static Controller getPatchController() {
        return _patchController;
    }

    public static void setPatchController(Controller patchController) {
        _patchController = patchController;
    }

    static void mav$compareOtherFile(CompareAddin compareAddin, Context context) {
        compareAddin.compareOtherFile(context);
    }

    static void mav$compareSavedFile(CompareAddin compareAddin, Context context) {
        compareAddin.compareSavedFile(context);
    }

    static void mav$compareEachOther(CompareAddin compareAddin, Context context) {
        compareAddin.compareEachOther(context);
    }

    static URL mav$getDirectoryCompareURL(CompareAddin compareAddin, RelativeDirectoryContextFolder relativeDirectoryContextFolder) {
        return compareAddin.getDirectoryCompareURL(relativeDirectoryContextFolder);
    }

    static CompareContributor mav$createDirectoryContributor(CompareAddin compareAddin, URL uRL) {
        return compareAddin.createDirectoryContributor(uRL);
    }

    final class 1
    extends CompareMethod {
        public boolean canCompare(CompareContributor left, CompareContributor right, StreamType streamType) {
            return left instanceof DirectoryCompareContributor;
        }

        public CompareType getCompareType() {
            return CompareType.DIRECTORY;
        }
    }

    final class 2
    extends DirectoryCompareContributor {
    }

    final class 3
    extends DirectoryFile {
        private final /* synthetic */ URLFileSystem.FileInfo v$info;
        final /* synthetic */ CompareAddin this$0;

        public CompareContributor createCompareContributor() throws Exception {
            URL url = this.v$info.getURL();
            return URLFileSystem.isDirectoryPath((URL)url) ? CompareAddin.mav$createDirectoryContributor(this.this$0, url) : new URLContributor(url);
        }

        public 3(CompareAddin compareAddin, boolean bl, String string, String string2, URLFileSystem.FileInfo fileInfo) {
            this.v$info = fileInfo;
            this.this$0 = compareAddin;
            super(bl, string, string2);
        }
    }

    final class 4
    extends IdeAdapter {
        public void addinsLoaded(IdeEvent idee) {
            Ide.removeIdeListener((IdeListener)this);
            if (CompareAddin.getCreatePatchCommand() == null) {
                return;
            }
            IdeAction createPatchAction = IdeAction.get((int)CompareAddin.getCreatePatchCommandID(), (String)CompareAddin.getCreatePatchCommand(), (String)StringUtils.stripMnemonic((String)CompareArb.getString(32)), (String)CompareArb.getString(43), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(32))), (ArrayResourceBundle)CompareArb.getInstance(), (int)13, null, (boolean)true);
            createPatchAction.addController(CompareAddin.getPatchController());
        }
    }

    final class 5
    extends DefaultKeyStrokeContext {
        private Set _actions;
        private final /* synthetic */ IdeAction v$goFirstAction;
        private final /* synthetic */ IdeAction v$goPreviousAction;
        private final /* synthetic */ IdeAction v$goNextAction;
        private final /* synthetic */ IdeAction v$goLastAction;
        private final /* synthetic */ IdeAction v$compareDirectoryAction;
        final /* synthetic */ CompareAddin this$0;

        private void $init$() {
            this._actions = new HashSet();
            this._actions.add(this.v$goFirstAction);
            this._actions.add(this.v$goPreviousAction);
            this._actions.add(this.v$goNextAction);
            this._actions.add(this.v$goLastAction);
            if (CompareAddin.getCreatePatchCommand() != null) {
                this._actions.add(IdeAction.find((int)CompareAddin.getCreatePatchCommandID()));
            }
            this._actions.add(this.v$compareDirectoryAction);
        }

        public String getName() {
            return CompareArb.getString(43);
        }

        public Set getAllActions(boolean bGlobal) {
            return this._actions;
        }

        public 5(CompareAddin compareAddin, IdeAction ideAction, IdeAction ideAction2, IdeAction ideAction3, IdeAction ideAction4, IdeAction ideAction5) {
            this.v$compareDirectoryAction = ideAction5;
            this.v$goLastAction = ideAction4;
            this.v$goNextAction = ideAction3;
            this.v$goPreviousAction = ideAction2;
            this.v$goFirstAction = ideAction;
            this.this$0 = compareAddin;
            this.$init$();
        }
    }

    final class 6
    implements DynamicMenuListener {
        public JComponent[] gatherDynamicActions(Context context) {
            if (context.getView() instanceof CompareEditor) {
                if (CompareAddin.getCreatePatchCommand() != null) {
                    return new JComponent[]{Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_FIRST_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_PREVIOUS_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_NEXT_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_LAST_CMD)), 0.0f), new JSeparator(), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)CompareAddin.getCreatePatchCommandID()), 0.0f)};
                }
                return new JComponent[]{Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_FIRST_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_PREVIOUS_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_NEXT_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_LAST_CMD)), 0.0f)};
            }
            return new JComponent[0];
        }
    }

    final class 7
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu menu) {
            if (menu.getContext().getView() instanceof CompareEditor) {
                Action[] editActions;
                CompareView compareView = ((CompareEditor)menu.getContext().getView()).getCompareView();
                float sectionId = 1.0f;
                if (compareView instanceof ListCompareView && ((ListCompareView)compareView).getCompareMode() == CompareMode.TWO_WAY_COMPARE && ((ListCompareView)compareView).isSelectionComparable()) {
                    Object[] selection = ((ListCompareView)compareView).getSelectionForCompare();
                    try {
                        ((DirectoryFile)selection[0]).getCompareContributor();
                        ((DirectoryFile)selection[1]).getCompareContributor();
                        menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.COMPARE_DIRECTORY_FILE_CMD))), sectionId);
                        sectionId += 0.01f;
                    }
                    catch (UnsupportedOperationException uoe) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Action[] actionArray = editActions = compareView instanceof EditorPaneView ? ((EditorPaneView)compareView).getEditActions() : null;
                if (editActions != null) {
                    int i = 0;
                    while (i < editActions.length) {
                        if (editActions[i] == null) {
                            sectionId += 0.01f;
                        } else {
                            menu.add((Component)new JMenuItem(editActions[i]), sectionId, false);
                        }
                        ++i;
                    }
                }
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_FIRST_CMD))), sectionId += 0.01f);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_PREVIOUS_CMD))), sectionId);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_NEXT_CMD))), sectionId);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_LAST_CMD))), sectionId);
                if (CompareAddin.getCreatePatchCommand() != null) {
                    menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)CompareAddin.getCreatePatchCommandID())), sectionId += 0.01f);
                }
            }
        }

        public void menuWillHide(ContextMenu menu) {
        }

        public boolean handleDefaultAction(Context ctx) {
            return false;
        }
    }

    private class MyController
    implements Controller {
        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == CompareAddin.this.m_eachOtherAction) {
                Element[] selection;
                if (context.getSelection() != null && (selection = context.getSelection()).length == 2) {
                    if (selection[0] instanceof CompareResourceProvider && selection[1] instanceof CompareResourceProvider) {
                        action.setEnabled(((CompareResourceProvider)selection[0]).isComparable() && ((CompareResourceProvider)selection[1]).isComparable());
                        return true;
                    }
                    if (selection[0] instanceof Locatable && selection[1] instanceof Locatable) {
                        action.setEnabled(CompareAddin.this.isValidCompareURL(((Locatable)selection[0]).getURL()) && CompareAddin.this.isValidCompareURL(((Locatable)selection[1]).getURL()));
                        return true;
                    }
                    if (selection[0] instanceof RelativeDirectoryContextFolder && selection[1] instanceof RelativeDirectoryContextFolder) {
                        action.setEnabled(CompareAddin.this.isValidCompareURL(CompareAddin.mav$getDirectoryCompareURL(CompareAddin.this, (RelativeDirectoryContextFolder)selection[0])) && CompareAddin.this.isValidCompareURL(CompareAddin.mav$getDirectoryCompareURL(CompareAddin.this, (RelativeDirectoryContextFolder)selection[1])));
                        return true;
                    }
                }
                action.setEnabled(false);
                return true;
            }
            if (cmdId == CompareAddin.this.m_otherFileAction) {
                if (context.getSelection() != null) {
                    Element[] selection = context.getSelection();
                    if (selection.length == 0) {
                        action.setEnabled(context.getNode() != null && CompareAddin.this.isValidCompareURL(context.getNode().getURL()));
                        return true;
                    }
                    if (selection.length != 1) {
                        action.setEnabled(false);
                        return true;
                    }
                    if (selection[0] instanceof CompareResourceProvider) {
                        action.setEnabled(((CompareResourceProvider)selection[0]).isComparable());
                        return true;
                    }
                    if (selection[0] instanceof Locatable) {
                        action.setEnabled(CompareAddin.this.isValidCompareURL(((Locatable)selection[0]).getURL()));
                        return true;
                    }
                    if (selection[0] instanceof RelativeDirectoryContextFolder) {
                        action.setEnabled(CompareAddin.this.isValidCompareURL(CompareAddin.mav$getDirectoryCompareURL(CompareAddin.this, (RelativeDirectoryContextFolder)selection[0])));
                        return true;
                    }
                    if (context.getNode() != null) {
                        action.setEnabled(CompareAddin.this.isValidCompareURL(context.getNode().getURL()));
                        return true;
                    }
                }
                action.setEnabled(false);
                return true;
            }
            if (cmdId == CompareAddin.this.m_savedFileAction) {
                if (context.getSelection() != null) {
                    Element[] selection = context.getSelection();
                    if (selection.length == 0) {
                        Node node = context.getNode();
                        action.setEnabled(node instanceof TextNode && (node.isDirty() || URLFileSystem.lastModified((URL)node.getURL()) != node.getUnmodifiedTimestamp()) && CompareAddin.this.isValidCompareURL(node.getURL()));
                        return true;
                    }
                    if (selection.length == 1) {
                        if (selection[0] instanceof CompareResourceProvider && ((CompareResourceProvider)selection[0]).isComparable()) {
                            action.setEnabled(this.isDifferent(context.getNode()));
                            return true;
                        }
                        if (selection[0] instanceof TextNode && CompareAddin.this.isValidCompareURL(((TextNode)selection[0]).getURL())) {
                            action.setEnabled(this.isDifferent((Node)((TextNode)selection[0])));
                            return true;
                        }
                    }
                    action.setEnabled(false);
                    return true;
                }
                action.setEnabled(false);
                return true;
            }
            return false;
        }

        private boolean isDifferent(Node node) {
            if (node == null) {
                return false;
            }
            return node.isDirty() || URLFileSystem.lastModified((URL)node.getURL()) != node.getUnmodifiedTimestamp();
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            try {
                if (cmdId == CompareAddin.this.m_otherFileAction) {
                    CompareAddin.mav$compareOtherFile(CompareAddin.this, context);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == CompareAddin.this.m_savedFileAction) {
                    CompareAddin.mav$compareSavedFile(CompareAddin.this, context);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == CompareAddin.this.m_eachOtherAction) {
                    CompareAddin.mav$compareEachOther(CompareAddin.this, context);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception ioe) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
            }
            return false;
        }

        private MyController() {
        }

        MyController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

