/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.compare.CompareViewOwner;
import oracle.jdevimpl.resource.CompareArb;

public class CompareController
implements Controller {
    private static CompareController _singleton;

    public static final CompareController getDefaultController() {
        if (_singleton == null) {
            _singleton = new CompareController();
        }
        return _singleton;
    }

    protected CompareView getCompareView(Context context) {
        if (context.getView() instanceof CompareViewOwner) {
            return ((CompareViewOwner)context.getView()).getCompareView();
        }
        return null;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        CompareView compareView = this.getCompareView(context);
        if (compareView == null) {
            return false;
        }
        if (context.getView() instanceof CompareViewOwner) {
            if (cmdId == CompareAddin.COMPARE_DIRECTORY_FILE_CMD_ID) {
                action.setEnabled(compareView instanceof ListCompareView && ((ListCompareView)compareView).isSelectionComparable());
                return true;
            }
            if (cmdId == CompareAddin.GO_FIRST_CMD_ID || cmdId == CompareAddin.GO_LAST_CMD_ID) {
                if (compareView == null || compareView.getModel() == null) {
                    return false;
                }
                action.setEnabled(compareView instanceof NavigableView && compareView.getModel().getDifferenceCount() > 0);
                return true;
            }
            if (cmdId == CompareAddin.GO_NEXT_CMD_ID) {
                action.setEnabled(compareView instanceof NavigableView && ((NavigableView)compareView).hasNextDifference());
                return true;
            }
            if (cmdId == CompareAddin.GO_PREVIOUS_CMD_ID) {
                action.setEnabled(compareView instanceof NavigableView && ((NavigableView)compareView).hasPreviousDifference());
                return true;
            }
        }
        if (compareView == null) {
            return false;
        }
        if (compareView instanceof EditorPaneView) {
            BasicEditorPane editorPane = ((EditorPaneView)compareView).getCurrentEditorPane();
            if (editorPane == null) {
                return false;
            }
            if (cmdId == 22) {
                action.setEnabled(true);
                return true;
            }
            if (cmdId == 18) {
                action.setEnabled(editorPane.canCopy());
                return true;
            }
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        CompareView compareView = this.getCompareView(context);
        if (compareView == null) {
            return false;
        }
        if (compareView instanceof ListCompareView && cmdId == CompareAddin.COMPARE_DIRECTORY_FILE_CMD_ID) {
            Object[] selection = ((ListCompareView)compareView).getSelectionForCompare();
            if (selection != null) {
                SwingUtilities.invokeLater(new 1(this, selection));
            }
            return true;
        }
        if (compareView instanceof EditorPaneView) {
            BasicEditorPane editorPane = ((EditorPaneView)compareView).getCurrentEditorPane();
            if (editorPane == null) {
                return false;
            }
            if (cmdId == 22) {
                editorPane.selectAll();
                return true;
            }
            if (cmdId == 18) {
                editorPane.copy();
                return true;
            }
        }
        if (compareView instanceof NavigableView) {
            NavigableView navigableView = (NavigableView)compareView;
            if (cmdId == CompareAddin.GO_FIRST_CMD_ID) {
                navigableView.goToFirstDifference();
                return true;
            }
            if (cmdId == CompareAddin.GO_NEXT_CMD_ID) {
                if (!navigableView.hasNextDifference()) {
                    return true;
                }
                boolean gotNext = navigableView.goToNextDifference();
                if (!gotNext && MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CompareArb.getString(2), (String)CompareArb.getString(39), null)) {
                    navigableView.goToFirstDifference();
                }
                return true;
            }
            if (cmdId == CompareAddin.GO_PREVIOUS_CMD_ID) {
                if (!navigableView.hasPreviousDifference()) {
                    return true;
                }
                boolean gotPrev = navigableView.goToPreviousDifference();
                if (!gotPrev && MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CompareArb.getString(42), (String)CompareArb.getString(44), null)) {
                    navigableView.goToLastDifference();
                }
                return true;
            }
            if (cmdId == CompareAddin.GO_LAST_CMD_ID) {
                navigableView.goToLastDifference();
                return true;
            }
        }
        return false;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Object[] v$selection;
        final /* synthetic */ CompareController this$0;

        public void run() {
            try {
                CompareIdeViewer.get().show(((DirectoryFile)this.v$selection[0]).getCompareContributor(), ((DirectoryFile)this.v$selection[1]).getCompareContributor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public 1(CompareController compareController, Object[] objectArray) {
            this.v$selection = objectArray;
            this.this$0 = compareController;
        }
    }
}

