/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.EventQueue;
import java.awt.Window;
import java.net.URL;
import java.util.BitSet;
import java.util.EventObject;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.compare.CompareContext;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.compare.CompareURLHelper;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.resource.CompareArb;

public class CompareIdeViewer
extends CompareViewer {
    private CompareAddin _compareAddin;
    private JMenu m_mainCompareMenu;
    private JMenu m_contextCompareMenu;
    private MenuListener m_menuListener;

    public CompareIdeViewer(CompareAddin compareAddin) {
        this._compareAddin = compareAddin;
    }

    public JMenu getMainCompareMenu() {
        if (this.m_mainCompareMenu == null) {
            this.m_mainCompareMenu = Ide.getMenubar().createSubMenu(StringUtils.stripMnemonic((String)CompareArb.getString(9)), new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(9))));
        }
        return this.m_mainCompareMenu;
    }

    public JMenu getContextCompareMenu() {
        if (this.m_contextCompareMenu == null) {
            this.m_contextCompareMenu = Ide.getMenubar().createSubMenu(StringUtils.stripMnemonic((String)CompareArb.getString(9)), new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(9))), 0.2f, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            this.m_menuListener = new 1();
            this.m_contextCompareMenu.addMenuListener(this.m_menuListener);
        }
        return this.m_contextCompareMenu;
    }

    public void show(CompareContributor left, CompareContributor right) {
        Ide.getWaitCursor().show();
        2 r = new 2(this, left, right);
        new Thread(r).start();
    }

    private void _show(CompareContributor left, CompareContributor right, CompareModel model) {
        try {
            Context detailedContext = Context.newIdeContext();
            BitSet sequences = new BitSet();
            sequences.set(0);
            for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                URL url;
                if (!(editor instanceof CompareEditor) || !(url = editor.getContext().getNode().getURL()).getProtocol().startsWith("ide.compare")) continue;
                sequences.set(CompareURLHelper.getSequence(url));
            }
            URL u = CompareURLHelper.newCompareURL(left, right, sequences.nextClearBit(0));
            Node node = NodeFactory.find((URL)u);
            if (node != null && !(node instanceof CompareNode)) {
                Assert.println((String)"CompareIdeViewer: Warning: incompatible node cached against compare URL");
                NodeFactory.uncache((URL)u);
            }
            CompareNode cn = (CompareNode)NodeFactory.findOrCreate(CompareNode.class, (URL)u);
            cn.setSource(left);
            cn.setTarget(right);
            cn.setModel(model);
            detailedContext.setNode((Node)cn);
            detailedContext.setElement((Element)cn);
            CompareContext.setContributors(detailedContext, new CompareContributor[]{left, right});
            EditorManager.getEditorManager().openEditorInFrame(CompareEditor.class, detailedContext);
        }
        catch (InstantiationException ie) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ie);
        }
        catch (IllegalAccessException ille) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ille);
        }
    }

    static CompareAddin ra$_compareAddin(CompareIdeViewer compareIdeViewer) {
        return compareIdeViewer._compareAddin;
    }

    static void mav$_show(CompareIdeViewer compareIdeViewer, CompareContributor compareContributor, CompareContributor compareContributor2, CompareModel compareModel) {
        compareIdeViewer._show(compareContributor, compareContributor2, compareModel);
    }

    final class 1
    implements MenuListener {
        public void menuCanceled(MenuEvent me) {
        }

        public void menuDeselected(MenuEvent me) {
        }

        public void menuSelected(MenuEvent me) {
            View active = Ide.getMainWindow().getLastActiveView();
            Context context = active.getContext((EventObject)me);
            IdeAction.find((int)CompareIdeViewer.ra$_compareAddin((CompareIdeViewer)CompareIdeViewer.this).m_eachOtherAction).updateAction(context);
            IdeAction.find((int)CompareIdeViewer.ra$_compareAddin((CompareIdeViewer)CompareIdeViewer.this).m_otherFileAction).updateAction(context);
            IdeAction.find((int)CompareIdeViewer.ra$_compareAddin((CompareIdeViewer)CompareIdeViewer.this).m_savedFileAction).updateAction(context);
        }
    }

    final class oracle.jdevimpl.compare.CompareIdeViewer$2
    implements Runnable {
        private final /* synthetic */ CompareContributor v$left;
        private final /* synthetic */ CompareContributor v$right;
        final /* synthetic */ CompareIdeViewer this$0;

        public void run() {
            try {
                CompareModel model = CompareUtil.createCompareModel(this.v$left, this.v$right);
                EventQueue.invokeLater(new 1(this, model));
            }
            finally {
                EventQueue.invokeLater(new 2());
            }
        }

        public oracle.jdevimpl.compare.CompareIdeViewer$2(CompareIdeViewer compareIdeViewer, CompareContributor compareContributor, CompareContributor compareContributor2) {
            this.v$right = compareContributor2;
            this.v$left = compareContributor;
            this.this$0 = compareIdeViewer;
        }

        static CompareContributor ra$v$left(oracle.jdevimpl.compare.CompareIdeViewer$2 var0) {
            return var0.v$left;
        }

        static CompareContributor ra$v$right(oracle.jdevimpl.compare.CompareIdeViewer$2 var0) {
            return var0.v$right;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ CompareModel v$model;
            final /* synthetic */ oracle.jdevimpl.compare.CompareIdeViewer$2 this$0;

            public void run() {
                if (this.v$model == null || this.v$model.getDifferences().length != 0 || CompareUtil.confirmIdenticalCompare()) {
                    CompareIdeViewer.mav$_show(this.this$0.this$0, oracle.jdevimpl.compare.CompareIdeViewer$2.ra$v$left(this.this$0), oracle.jdevimpl.compare.CompareIdeViewer$2.ra$v$right(this.this$0), this.v$model);
                }
            }

            public 1(oracle.jdevimpl.compare.CompareIdeViewer$2 var1_1, CompareModel compareModel) {
                this.v$model = compareModel;
                this.this$0 = var1_1;
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                Ide.getWaitCursor().hide();
            }
        }
    }
}

