/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import oracle.ide.util.Copyable;
import oracle.javatools.compare.CompareHints;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class CompareOptions
extends HashStructureAdapter
implements Copyable {
    static final String DATA_KEY = "oracle.jdevimpl.compare.CompareOptions";
    public static final String KEY = "compareOptions";
    private static final String IGNORE_WHITESPACE = "ignoreWhitespace";
    private static final String SHOW_ONLY_DIFFERENCES = "showOnlyDifferences";
    private static final String SHOW_CHAR_DIFFERENCES = "showCharDifferences";
    private static final String XML_COMPARE_ENABLED = "xmlCompareEnabled";
    private static final String MAXIMUM_TEXT_FILE_SIZE = "maximumTextFileSize";
    private static final String MAXIMUM_XML_FILE_SIZE = "maximumXmlFileSize";
    private static final boolean DEFAULT_IGNORE_WHITESPACE = true;
    private static final boolean DEFAULT_SHOW_ONLY_DIFFERENCES = false;
    private static final boolean DEFAULT_SHOW_CHAR_DIFFERENCES = false;
    private static final boolean DEFAULT_XML_COMPARE_ENABLED = true;
    private static final int DEFAULT_MAXIMUM_TEXT_FILE_SIZE = 256;
    private static final int DEFAULT_MAXIMUM_XML_FILE_SIZE = 64;

    public CompareOptions() {
        super(HashStructure.newInstance());
    }

    private CompareOptions(HashStructure hash) {
        super(hash);
    }

    public static CompareOptions getInstance(PropertyStorage prefs) {
        return new CompareOptions(CompareOptions.findOrCreate((PropertyStorage)prefs, (String)DATA_KEY));
    }

    public int getMaximumTextFileSize() {
        return this._hash.getInt(MAXIMUM_TEXT_FILE_SIZE, 256);
    }

    public void setMaximumTextFileSize(int maximumFileSize) {
        this._hash.putInt(MAXIMUM_TEXT_FILE_SIZE, maximumFileSize);
    }

    public boolean getIgnoreWhitespace() {
        return this._hash.getBoolean(IGNORE_WHITESPACE, true);
    }

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this._hash.putBoolean(IGNORE_WHITESPACE, ignoreWhitespace);
        CompareHints.setIgnoreWhiteSpace((boolean)ignoreWhitespace);
    }

    public boolean getShowOnlyDifferences() {
        return this._hash.getBoolean(SHOW_ONLY_DIFFERENCES, false);
    }

    public void setShowOnlyDifferences(boolean showOnlyDifferences) {
        this._hash.putBoolean(SHOW_ONLY_DIFFERENCES, showOnlyDifferences);
    }

    public boolean getShowCharDifferences() {
        return this._hash.getBoolean(SHOW_CHAR_DIFFERENCES, false);
    }

    public void setShowCharDifferences(boolean showCharDifferences) {
        this._hash.putBoolean(SHOW_CHAR_DIFFERENCES, showCharDifferences);
        CompareHints.setShowCharDifferences((boolean)showCharDifferences);
    }

    public boolean isXMLCompareEnabled() {
        return this._hash.getBoolean(XML_COMPARE_ENABLED, true);
    }

    public void setXMLCompareEnabled(boolean xmlCompareEnabled) {
        this._hash.putBoolean(XML_COMPARE_ENABLED, xmlCompareEnabled);
    }

    public int getMaximumFileSize() {
        return this._hash.getInt(MAXIMUM_XML_FILE_SIZE, 64);
    }

    public void setMaximumFileSize(int maximumFileSize) {
        this._hash.putInt(MAXIMUM_XML_FILE_SIZE, maximumFileSize);
    }
}

