/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.ui.layout.VerticalFlowLayout;
import oracle.jdevimpl.compare.CompareOptions;
import oracle.jdevimpl.resource.CompareArb;

public class ComparePreferencesPanel
extends DefaultTraversablePanel {
    private final JLabel _maxTextFileSizeLabel;
    private final JSpinner _maxTextFileSizeSpinner;
    private final JCheckBox _ignoreWhitespace;
    private final JCheckBox _showCharDiff;
    private final JCheckBox _xmlCompareCheckBox;
    private final JLabel _maxFileSizeLabel;
    private final JSpinner _maxFileSizeSpinner;
    private JPanel _panel;

    private void $init$() {
        this._maxTextFileSizeLabel = new JLabel();
        this._maxTextFileSizeSpinner = new JSpinner();
        this._ignoreWhitespace = new JCheckBox();
        this._showCharDiff = new JCheckBox();
        this._xmlCompareCheckBox = new JCheckBox();
        this._maxFileSizeLabel = new JLabel();
        this._maxFileSizeSpinner = new JSpinner();
    }

    public ComparePreferencesPanel() {
        this.$init$();
        this._maxTextFileSizeSpinner.setModel(new SpinnerNumberModel(4, 4, 8192, 4));
        this._maxFileSizeSpinner.setModel(new SpinnerNumberModel(4, 4, 1024, 4));
        JLabel textCompareLabel = new JLabel();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)textCompareLabel, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._ignoreWhitespace, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._showCharDiff, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._maxTextFileSizeLabel, insets, 1, false, true);
        layoutBuilder.add((Component)this._maxTextFileSizeSpinner, insets, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._xmlCompareCheckBox, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._maxFileSizeLabel, insets, 1, false, true);
        layoutBuilder.add((Component)this._maxFileSizeSpinner, insets, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        this._panel = new JPanel();
        layoutBuilder.addToPanel((Container)this._panel);
        ResourceUtils.resLabel((JLabel)textCompareLabel, (Component)textCompareLabel, (String)CompareArb.getString(11));
        ResourceUtils.resLabel((JLabel)this._maxTextFileSizeLabel, (Component)this._maxTextFileSizeSpinner, (String)CompareArb.getString(30));
        ResourceUtils.resButton((AbstractButton)this._ignoreWhitespace, (String)CompareArb.getString(56));
        ResourceUtils.resButton((AbstractButton)this._showCharDiff, (String)CompareArb.getString(7));
        ResourceUtils.resButton((AbstractButton)this._xmlCompareCheckBox, (String)CompareArb.getString(48));
        ResourceUtils.resLabel((JLabel)this._maxFileSizeLabel, (Component)this._maxFileSizeSpinner, (String)CompareArb.getString(22));
        this._xmlCompareCheckBox.addActionListener(new 1());
        this.updateComponentsEnabled();
        this.setHelpID("f1_idedidesetcompare_html");
    }

    public Component getComponent() {
        if (this._panel != null) {
            this.setLayout((LayoutManager)new VerticalFlowLayout(0, 5, 0, true, false));
            this.addToLayout();
            this.add(Box.createGlue());
            this._panel = null;
        }
        return this;
    }

    protected void addToLayout() {
        this.add(this._panel);
    }

    private void updateComponentsEnabled() {
        boolean xmlCompareEnabled = this._xmlCompareCheckBox.isSelected();
        this._maxFileSizeLabel.setEnabled(xmlCompareEnabled);
        this._maxFileSizeSpinner.setEnabled(xmlCompareEnabled);
    }

    public void onEntry(TraversableContext tc) {
        CompareOptions options = ComparePreferencesPanel.getCompareOptions(tc);
        this._maxTextFileSizeSpinner.setValue(options.getMaximumTextFileSize());
        this._ignoreWhitespace.setSelected(options.getIgnoreWhitespace());
        this._showCharDiff.setSelected(options.getShowCharDifferences());
        this._xmlCompareCheckBox.setSelected(options.isXMLCompareEnabled());
        this._maxFileSizeSpinner.setValue(options.getMaximumFileSize());
        this.updateComponentsEnabled();
    }

    public void onExit(TraversableContext tc) {
        CompareOptions options = ComparePreferencesPanel.getCompareOptions(tc);
        options.setMaximumTextFileSize(((Number)this._maxTextFileSizeSpinner.getValue()).intValue());
        options.setIgnoreWhitespace(this._ignoreWhitespace.isSelected());
        options.setShowCharDifferences(this._showCharDiff.isSelected());
        options.setXMLCompareEnabled(this._xmlCompareCheckBox.isSelected());
        options.setMaximumFileSize(((Number)this._maxFileSizeSpinner.getValue()).intValue());
    }

    private static CompareOptions getCompareOptions(TraversableContext tc) {
        return CompareOptions.getInstance(tc.getPropertyStorage());
    }

    static void mav$updateComponentsEnabled(ComparePreferencesPanel comparePreferencesPanel) {
        comparePreferencesPanel.updateComponentsEnabled();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            ComparePreferencesPanel.mav$updateComponentsEnabled(ComparePreferencesPanel.this);
        }
    }
}

