/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareMethod;
import oracle.jdevimpl.compare.CompareOptions;
import oracle.jdevimpl.compare.StreamTextProcessor;
import oracle.jdevimpl.resource.CompareArb;

public class CompareUtil {
    private CompareUtil() {
    }

    public static final CompareType getCompareType(CompareContributor left, CompareContributor right) {
        return CompareUtil.getCompareType(left, right, null);
    }

    public static final CompareType getCompareType(CompareContributor left, CompareContributor right, StreamType streamType) {
        CompareType compareType = CompareType.TEXT;
        for (CompareMethod compareMethod : ((CompareAddin)AddinManager.getAddinManager().getAddin(CompareAddin.class)).getCompareMethods()) {
            if (!compareMethod.canCompare(left, right, streamType)) continue;
            compareType = compareMethod.getCompareType();
            break;
        }
        return compareType;
    }

    public static final StreamType getStreamType(CompareContributor contributor) {
        if (contributor instanceof InputStreamTextContributor) {
            return ((InputStreamTextContributor)contributor).getStreamType();
        }
        if (contributor instanceof URLContributor) {
            return ((URLContributor)contributor).getStreamType();
        }
        if (contributor instanceof TextNodeContributor) {
            TextNodeContributor textNodeContributor = (TextNodeContributor)contributor;
            TextBuffer textBuffer = textNodeContributor.getTextBuffer();
            int n = Math.min(textBuffer.getLength(), 512);
            if (textBuffer.getLength() <= 0) {
                return null;
            }
            try {
                StreamType streamType = StreamDecoder.getStream(contributor.getType(), new ByteArrayInputStream(textBuffer.getString(0, n).getBytes(textNodeContributor.getTextNode().getSaveEncoding())), "UTF-8").getType();
                return streamType;
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
                StreamType streamType = null;
                return streamType;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                StreamType streamType = null;
                return streamType;
            }
        }
        return null;
    }

    public static final CompareModel createCompareModel(CompareContributor left, CompareContributor right) {
        return CompareUtil.createCompareModel(left, right, CompareUtil.getCompareType(left, right));
    }

    public static final CompareModel createCompareModel(CompareContributor left, CompareContributor right, CompareType type) {
        try {
            CompareModel compareModel = CompareUtil.createCompareModel(left, right, type, null);
            return compareModel;
        }
        catch (CompareFailedException cfe) {
            cfe.printStackTrace();
            CompareModel compareModel = null;
            return compareModel;
        }
    }

    private static final boolean processTextForBug5929303(CompareContributor left, CompareContributor right) {
        if (!left.getType().equals(right.getType())) {
            return false;
        }
        URL referenceUrl = null;
        if (referenceUrl == null) {
            referenceUrl = CompareUtil.getReferenceURL(right);
        }
        if (referenceUrl == null) {
            referenceUrl = CompareUtil.getReferenceURL(left);
        }
        if (referenceUrl == null) {
            return false;
        }
        boolean processed = false;
        if (!(left instanceof TextNodeContributor) && left instanceof TextCompareContributor) {
            processed = CompareUtil.processTextForBug5929303(left.getType(), ((TextCompareContributor)left).getTextBuffer(), referenceUrl);
        }
        if (!(right instanceof TextNodeContributor) && right instanceof TextCompareContributor) {
            processed = CompareUtil.processTextForBug5929303(right.getType(), ((TextCompareContributor)right).getTextBuffer(), referenceUrl) || processed;
        }
        return processed;
    }

    private static final URL getReferenceURL(CompareContributor contributor) {
        if (contributor instanceof TextNodeContributor) {
            return ((TextNodeContributor)contributor).getTextNode().getURL();
        }
        if (contributor instanceof URLContributor) {
            return ((URLContributor)contributor).getURL();
        }
        return null;
    }

    private static final boolean processTextForBug5929303(String type, TextBuffer textBuffer, URL referenceUrl) {
        boolean readOnly = textBuffer.isReadOnly();
        textBuffer.setReadOnly(false);
        textBuffer.writeLock();
        textBuffer.clearModified();
        try {
            for (StreamTextProcessor processor : StreamTextProcessor.getRegisteredProcessors()) {
                processor.process(type, textBuffer, referenceUrl);
            }
            boolean bl = textBuffer.isModified();
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            textBuffer.writeUnlock();
            textBuffer.setReadOnly(readOnly);
        }
    }

    public static final CompareModel createCompareModel(CompareContributor left, CompareContributor right, CompareType type, CompareAlgorithm algorithm) throws CompareFailedException {
        try {
            if (CompareUtil.processTextForBug5929303(left, right)) {
                type = CompareType.TEXT;
            }
        }
        catch (RuntimeException re) {
            Assert.printStackTrace((Throwable)re);
        }
        return CompareUtil._createCompareModel(left, right, type, algorithm);
    }

    /*
     * Unable to fully structure code
     */
    private static final CompareModel _createCompareModel(CompareContributor left, CompareContributor right, CompareType type, CompareAlgorithm algorithm) throws CompareFailedException {
        if (type == CompareType.TEXT && (CompareUtil.exceedsMaxTextFileSize(left) || CompareUtil.exceedsMaxTextFileSize(right))) {
            return null;
        }
        compareOptions = CompareUtil.getCompareOptions();
        ((TextCompareContributor)left).setIgnoreWhitespace(compareOptions.getIgnoreWhitespace());
        ((TextCompareContributor)right).setIgnoreWhitespace(compareOptions.getIgnoreWhitespace());
        for (CompareMethod compareMethod : ((CompareAddin)AddinManager.getAddinManager().getAddin(CompareAddin.class)).getCompareMethods()) {
            compareMethod.processOptions();
        }
        try {
            if (algorithm != null) {
                compareModel = algorithm.compare(left, right);
                if (compareModel != null) {
                    compareModel.setType(type);
                }
                var10_8 = compareModel;
                return var10_8;
            }
            var11_9 = CompareModelFactory.createCompareModel((CompareContributor)left, (CompareContributor)right, (CompareType)type);
            return var11_9;
        }
        catch (CompareFailedException cfe) {
            ** for (compareMethod : ((CompareAddin)AddinManager.getAddinManager().getAddin(CompareAddin.class)).getCompareMethods())
        }
lbl-1000:
        // 1 sources

        {
            if (!compareMethod.getCompareType().equals((Object)type) || !compareMethod.canFallBack(cfe)) continue;
            type = compareMethod.getFallbackCompareType();
            var13_13 = CompareUtil._createCompareModel(left, right, type, CompareModelFactory.createCompareAlgorithm((CompareType)type));
            return var13_13;
        }
lbl24:
        // 1 sources

        throw cfe;
    }

    private static final boolean exceedsMaxTextFileSize(CompareContributor contributor) {
        return contributor instanceof TextCompareContributor && (double)((TextCompareContributor)contributor).getTextBuffer().getLength() > (double)CompareUtil.getCompareOptions().getMaximumTextFileSize() * Math.pow(2.0, 10.0);
    }

    public static final boolean confirmIdenticalCompare() {
        CompareOptions compareOptions = CompareUtil.getCompareOptions();
        String message = compareOptions.getIgnoreWhitespace() ? CompareArb.getString(16) : CompareArb.getString(10);
        return MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)CompareArb.getString(15), null, (boolean)true);
    }

    private static final CompareOptions getCompareOptions() {
        return CompareOptions.getInstance((PropertyStorage)Preferences.getPreferences());
    }
}

