/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.ContentType;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.history.DefaultHistoryEntry;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.resource.CompareArb;
import oracle.jdeveloper.resource.HistoryArb;
import oracle.jdevimpl.compare.XmlContextFactory;

class BufferHistoryProvider
extends HistoryProvider {
    private static BufferHistoryProvider _instance;
    private static final HistoryProperty[] _PROPERTIES;
    private static final HistoryFilter _TYPE_FILTER;
    private static final RevisionIdentifier _BUFFER_REVISION;

    public static final BufferHistoryProvider getInstance() {
        if (_instance == null) {
            _instance = new BufferHistoryProvider();
        }
        return _instance;
    }

    private BufferHistoryProvider() {
    }

    public HistoryFilter getTypeFilter() {
        return _TYPE_FILTER;
    }

    public HistoryProperty[] getProperties() {
        return _PROPERTIES;
    }

    public boolean isProviderFor(URL url) {
        try {
            if (!URLFileSystem.isDirectory((URL)url)) {
                HistoryManager mgr = HistoryManager.getHistoryManager();
                Class cls = Recognizer.recognizeURL((URL)url);
                if (mgr != null && cls != null) {
                    boolean bl = mgr.getRegisteredHistorian(cls) != null;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public HistoryEntry[] getEntries(URL url, HistoryFilter filter) {
        ArrayList<BufferEntry> entries = new ArrayList<BufferEntry>();
        try {
            if (!URLFileSystem.isDirectory((URL)url)) {
                Node node = NodeFactory.findOrCreate((URL)url);
                if (node instanceof TextNode) {
                    entries.add(new BufferEntry((TextNode)node, null));
                } else if (node instanceof Node && DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)url)) == ContentType.TEXT) {
                    entries.add(new BufferEntry(node, null));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HistoryEntry[] result = new HistoryEntry[entries.size()];
        entries.toArray(result);
        return result;
    }

    static {
        _PROPERTIES = new HistoryProperty[]{SharedProperties.getDateProperty(), SharedProperties.getRevisionProperty(), SharedProperties.getDescriptionProperty()};
        _TYPE_FILTER = new 1();
        _BUFFER_REVISION = new RevisionIdentifier(HistoryArb.getIcon(16), HistoryArb.getString(27));
    }

    static RevisionIdentifier ra$_BUFFER_REVISION() {
        return _BUFFER_REVISION;
    }

    static final class 1
    implements HistoryFilter {
        public String getShortLabel() {
            return HistoryArb.getString(27);
        }

        public boolean accept(HistoryEntry entry) {
            return entry instanceof BufferEntry;
        }
    }

    private static final class BufferEntry
    extends DefaultHistoryEntry {
        private final Node _node;
        private CompareContributor _contributor;

        private BufferEntry(TextNode node) {
            this((Node)node);
        }

        private BufferEntry(Node node) {
            this._node = node;
            this.setValue(SharedProperties.getDateProperty(), HistoryComponent.LIVE_DATE);
            this.setValue(SharedProperties.getRevisionProperty(), BufferHistoryProvider.ra$_BUFFER_REVISION());
            this.setValue(SharedProperties.getDescriptionProperty(), HistoryArb.getString(3));
        }

        public CompareContributor getCompareContributor() {
            try {
                if (this._node instanceof TextNode) {
                    if (this._contributor == null) {
                        this._contributor = new TextNodeContributor((TextNode)this._node);
                    }
                    CompareContributor compareContributor = this._contributor;
                    return compareContributor;
                }
                URL url = this._node.getURL();
                InputStreamTextContributor contributor = new InputStreamTextContributor(URLFileSystem.openInputStream((URL)url), CompareArb.format(16, URLFileSystem.getFileName((URL)url)), URLFileSystem.getPlatformPathName((URL)url), URLFileSystem.getSuffix((URL)url));
                contributor.getTextBuffer().setReadOnly(true);
                contributor.setDocumentModel(this.getXmlContext(this._node));
                InputStreamTextContributor inputStreamTextContributor = contributor;
                return inputStreamTextContributor;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private Object getXmlContext(Node node) {
            return XmlContextFactory.getXmlContextFactory().findOrCreateContext(new Context(node));
        }

        BufferEntry(TextNode textNode, 1 var2_2) {
            this(textNode);
        }

        BufferEntry(Node node, 1 var2_2) {
            this(node);
        }

        public final class 1 {
        }
    }
}

