/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.CustomFilter;
import oracle.jdeveloper.history.CustomFilterSubstitution;
import oracle.jdeveloper.history.DefaultHistoryProperty;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdevimpl.resource.HistoryArb;

class CustomFilterPanel {
    private static final String DEFAULT_EXPRESSION = "DATE = ${system.date}";
    private JButton _addButton;
    private JButton _moveUpButton;
    private JButton _moveDownButton;
    private JButton _removeButton;
    private JButton _restoreDefaultsButton;
    private JLabel _filterListLabel;
    private JList _filterList;
    private SyntaxTextArea _filterExpressionTextArea;
    private DefaultListModel _filterListModel;
    private TitledBorder _detailBorder;
    private JPanel _detailPanel;
    private JRadioButton _simpleExpressionRadioButton;
    private JRadioButton _complexExpressionRadioButton;
    private JLabel _columnLabel;
    private JComboBox _columnComboBox;
    private JLabel _operatorLabel;
    private JComboBox _operatorComboBox;
    private JLabel _valueLabel;
    private SyntaxTextField _valueTextField;
    private JButton _insertButton;
    private Component _gui;
    private CustomFilter _editedFilter;

    private CustomFilterPanel() {
    }

    Component getGUI() {
        if (this._gui != null) {
            return this._gui;
        }
        this._moveUpButton = new JButton();
        this._moveDownButton = new JButton();
        this._removeButton = new JButton();
        this._restoreDefaultsButton = new JButton();
        this._addButton = new JButton();
        this._filterListLabel = new JLabel();
        this._filterList = new JList();
        this._filterExpressionTextArea = new SyntaxTextArea();
        this._simpleExpressionRadioButton = new JRadioButton();
        this._complexExpressionRadioButton = new JRadioButton();
        this._columnLabel = new JLabel();
        this._columnComboBox = new JComboBox();
        this._operatorLabel = new JLabel();
        this._operatorComboBox = new JComboBox();
        this._valueLabel = new JLabel();
        this._valueTextField = new SyntaxTextField();
        this._insertButton = new JButton();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._simpleExpressionRadioButton);
        bg.add(this._complexExpressionRadioButton);
        this._filterList.setSelectionMode(0);
        this._detailBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
        ResourceUtils.resButton((AbstractButton)this._removeButton, (String)HistoryArb.getString(11));
        ResourceUtils.resButton((AbstractButton)this._restoreDefaultsButton, (String)HistoryArb.getString(49));
        ResourceUtils.resButton((AbstractButton)this._addButton, (String)HistoryArb.getString(22));
        ResourceUtils.resLabel((JLabel)this._filterListLabel, (Component)this._filterList, (String)HistoryArb.getString(51));
        ResourceUtils.resButton((AbstractButton)this._simpleExpressionRadioButton, (String)HistoryArb.getString(32));
        ResourceUtils.resButton((AbstractButton)this._complexExpressionRadioButton, (String)HistoryArb.getString(41));
        ResourceUtils.resLabel((JLabel)this._columnLabel, (Component)this._columnComboBox, (String)HistoryArb.getString(19));
        ResourceUtils.resLabel((JLabel)this._operatorLabel, (Component)this._operatorComboBox, (String)HistoryArb.getString(6));
        ResourceUtils.resLabel((JLabel)this._valueLabel, (Component)this._valueTextField, (String)HistoryArb.getString(28));
        ResourceUtils.resButton((AbstractButton)this._insertButton, (String)HistoryArb.getString(43));
        this._moveUpButton.setIcon(HistoryArb.getIcon(47));
        this._moveDownButton.setIcon(HistoryArb.getIcon(42));
        this.initializeToolButton(this._moveUpButton);
        this.initializeToolButton(this._moveDownButton);
        int toolButtonHeight = this._addButton.getPreferredSize().height;
        int toolButtonWidth = Math.max(toolButtonHeight, 16);
        Dimension toolButtonPreferredSize = new Dimension(toolButtonWidth, toolButtonHeight);
        this._moveUpButton.setPreferredSize(toolButtonPreferredSize);
        this._moveDownButton.setPreferredSize(toolButtonPreferredSize);
        JScrollPane filterListScrollPane = new JScrollPane(this._filterList);
        JScrollPane filterExpressionScrollPane = new JScrollPane(this._filterExpressionTextArea);
        this._filterExpressionTextArea.setRows(2);
        this._filterExpressionTextArea.setFont(new Font("monospaced", 0, this._filterExpressionTextArea.getFont().getSize()));
        this._filterExpressionTextArea.setLineWrap(true);
        this._filterExpressionTextArea.setWrapStyleWord(true);
        if (filterExpressionScrollPane.getBorder() != null) {
            Border border = filterExpressionScrollPane.getBorder();
            Insets insets = border.getBorderInsets(filterExpressionScrollPane);
            Dimension d = new Dimension(this._filterExpressionTextArea.getPreferredSize());
            d.height = d.height + (insets != null ? insets.top : 0);
            d.height = d.height + (insets != null ? insets.bottom : 0);
            filterExpressionScrollPane.setPreferredSize(d);
        }
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(Box.createHorizontalStrut(225));
        buttonBox.add(this._addButton);
        buttonBox.add(this._removeButton);
        buttonBox.add(this._restoreDefaultsButton);
        buttonBox.add(Box.createHorizontalStrut(2));
        Box buttonBox2 = Box.createVerticalBox();
        buttonBox2.add(Box.createVerticalStrut(2));
        buttonBox2.add(buttonBox);
        buttonBox2.add(Box.createVerticalStrut(2));
        Box buttonBox3 = Box.createVerticalBox();
        buttonBox3.add(this._moveUpButton);
        buttonBox3.add(this._moveDownButton);
        buttonBox3.add(Box.createVerticalGlue());
        Box buttonBox4 = Box.createHorizontalBox();
        buttonBox4.add(Box.createHorizontalStrut(2));
        buttonBox4.add(buttonBox3);
        filterListScrollPane.setMinimumSize(new Dimension(filterListScrollPane.getPreferredSize().width, 50));
        JPanel filterListPanel = new JPanel(new BorderLayout());
        filterListPanel.add((Component)filterListScrollPane, "Center");
        filterListPanel.add((Component)buttonBox4, "East");
        this._filterList.setPrototypeCellValue("this is a prototype filter name");
        this._filterList.setVisibleRowCount(5);
        this._valueTextField.setColumns(40);
        Insets insets = new Insets(2, 2, 2, 2);
        JPanel masterPanel = new JPanel(new BorderLayout());
        masterPanel.add((Component)this._filterListLabel, "North");
        masterPanel.add((Component)filterListPanel, "Center");
        masterPanel.add((Component)buttonBox2, "South");
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        layoutBuilder.add((Component)this._simpleExpressionRadioButton, insets, 5, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._columnLabel, insets, 1, false, false);
        layoutBuilder.add((Component)this._operatorLabel, insets, 1, false, false);
        layoutBuilder.add((Component)this._valueLabel, insets, 2, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._columnComboBox, insets, 1, false, false);
        layoutBuilder.add((Component)this._operatorComboBox, insets, 1, false, false);
        layoutBuilder.add((Component)this._valueTextField, insets, 1, false, true);
        layoutBuilder.add((Component)this._insertButton, insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._complexExpressionRadioButton, insets, 5, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)filterExpressionScrollPane, insets, 4, false, true);
        layoutBuilder.nl();
        this._detailPanel = new JPanel();
        layoutBuilder.addToPanel((Container)this._detailPanel);
        this._detailPanel.setBorder(this._detailBorder);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)masterPanel, "Center");
        contentPanel.add((Component)this._detailPanel, "South");
        this._gui = contentPanel;
        this._filterListModel = new DefaultListModel();
        this._filterList.setModel(this._filterListModel);
        CustomFilter[] customFilters = HistoryManager.getHistoryManager().getCustomFilterManager().getFilters();
        this._filterListModel.removeAllElements();
        int i = 0;
        while (i < customFilters.length) {
            this._filterListModel.addElement(customFilters[i]);
            ++i;
        }
        this._filterList.setCellRenderer(new 1());
        Collection historyProviders = HistoryManager.getHistoryManager().getProviders();
        LinkedHashSet<ColumnItem> columnItems = new LinkedHashSet<ColumnItem>();
        Iterator itr = historyProviders.iterator();
        while (itr.hasNext()) {
            HistoryProperty[] historyProperties = ((HistoryProvider)itr.next()).getProperties();
            int i2 = 0;
            while (i2 < historyProperties.length) {
                String customFilterId;
                if (historyProperties[i2] instanceof DefaultHistoryProperty && (customFilterId = ((DefaultHistoryProperty)historyProperties[i2]).getCustomFilterId()) != null) {
                    columnItems.add(new ColumnItem((DefaultHistoryProperty)historyProperties[i2]));
                }
                ++i2;
            }
        }
        Object[] columnItems0 = columnItems.toArray();
        Arrays.sort(columnItems0);
        this._columnComboBox.setModel(new DefaultComboBoxModel<Object>(columnItems0));
        ArrayList<OperatorItem> operatorItems = new ArrayList<OperatorItem>();
        operatorItems.add(new OperatorItem("="));
        operatorItems.add(new OperatorItem("<>"));
        operatorItems.add(new OperatorItem(">"));
        operatorItems.add(new OperatorItem("<"));
        operatorItems.add(new OperatorItem(">="));
        operatorItems.add(new OperatorItem("<="));
        operatorItems.add(new OperatorItem("MATCHES", HistoryArb.getString(5)));
        this._operatorComboBox.setModel(new DefaultComboBoxModel<Object>(operatorItems.toArray()));
        this._moveUpButton.addActionListener(new 2());
        this._moveDownButton.addActionListener(new 3());
        this._removeButton.addActionListener(new 4());
        this._restoreDefaultsButton.addActionListener(new 5());
        this._addButton.addActionListener(new 6());
        this._filterList.addListSelectionListener(new 7());
        this._filterExpressionTextArea.getDocument().addDocumentListener(new 8(this));
        this._valueTextField.getDocument().addDocumentListener(new 9(this));
        this._simpleExpressionRadioButton.addActionListener(new 10());
        this._complexExpressionRadioButton.addActionListener(new 11());
        this._insertButton.addActionListener(new 12());
        if (this._filterList.getModel().getSize() > 0) {
            this._filterList.setSelectedIndex(0);
        }
        this.listSelectionChanged();
        return this._gui;
    }

    void commitEdits() {
        if (this._editedFilter == null) {
            return;
        }
        int i = this._filterListModel.indexOf(this._editedFilter);
        CustomFilter newFilter = null;
        if (this._simpleExpressionRadioButton.isSelected()) {
            newFilter = this.createCustomFilter(this.createSimpleExpression());
        }
        if (this._complexExpressionRadioButton.isSelected()) {
            newFilter = this.createCustomFilter(this._filterExpressionTextArea.getText());
        }
        if (i < 0 || newFilter == null) {
            return;
        }
        newFilter.setName(this._editedFilter.getName());
        this._filterListModel.set(i, newFilter);
    }

    CustomFilter[] getCustomFilters() {
        Object[] customFilters = new CustomFilter[this._filterListModel.getSize()];
        this._filterListModel.copyInto(customFilters);
        return customFilters;
    }

    private void initializeToolButton(JButton button) {
        button.putClientProperty("hideActionText", Boolean.TRUE);
        button.setHorizontalAlignment(0);
        button.setFocusable(false);
        button.setFocusPainted(false);
        button.setText("");
    }

    private void listSelectionChanged() {
        this.commitEdits();
        this._editedFilter = (CustomFilter)this._filterList.getSelectedValue();
        this.updateListSelectionDependentStates();
    }

    private void updateListSelectionDependentStates() {
        int i = this._filterList.getSelectedIndex();
        this._moveUpButton.setEnabled(i <= 0 ^ true);
        this._moveDownButton.setEnabled((i < 0 || i > this._filterListModel.getSize() - 2) ^ true);
        this._removeButton.setEnabled(this._editedFilter != null);
        this._detailBorder.setTitle(HistoryArb.format(26, this._editedFilter != null ? this._editedFilter.getName() : ""));
        this._detailPanel.repaint();
        this._simpleExpressionRadioButton.setEnabled(this._editedFilter != null);
        this._complexExpressionRadioButton.setEnabled(this._editedFilter != null);
        boolean complex = false;
        if (this._editedFilter == null) {
            this.updateSimpleControlsFromExpression(DEFAULT_EXPRESSION);
            this._filterExpressionTextArea.setText("");
        } else {
            Pattern pattern;
            String expression = this._editedFilter.getSource();
            String[] tokens = expression.split("\\s+");
            if (tokens.length < 3 || !this.isRecognizedColumnId(tokens[0])) {
                complex = true;
            }
            if ((pattern = Pattern.compile("\\s+(AND|OR)\\s+", 2)).matcher(expression).find()) {
                complex = true;
            }
            if ((pattern = Pattern.compile("(\\+|^)NOT\\s+", 2)).matcher(expression).find()) {
                complex = true;
            }
            this.updateSimpleControlsFromExpression(complex ? DEFAULT_EXPRESSION : expression);
            this._filterExpressionTextArea.setText(expression);
            this._filterExpressionTextArea.setCaretPosition(0);
        }
        this._simpleExpressionRadioButton.setSelected(complex ^ true);
        this._complexExpressionRadioButton.setSelected(complex);
        this.updateExpressionDependentStates();
    }

    private void updateSimpleControlsFromExpression(String expression) {
        Pattern pattern = Pattern.compile("\\s*(.+?)\\s+(.+?)\\s+(.++)");
        Matcher matcher = pattern.matcher(expression);
        if (!matcher.find()) {
            Assert.printStackTrace((Throwable)new IllegalStateException());
            return;
        }
        String columnId = matcher.group(1);
        String operatorId = matcher.group(2);
        String value = matcher.group(3);
        int i = 0;
        int n = this._columnComboBox.getModel().getSize();
        while (i < n) {
            if (((ColumnItem)this._columnComboBox.getModel().getElementAt(i)).getCustomFilterId().equals(columnId)) {
                this._columnComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        int i2 = 0;
        int n2 = this._operatorComboBox.getModel().getSize();
        while (i2 < n2) {
            if (((OperatorItem)this._operatorComboBox.getModel().getElementAt(i2)).getCustomFilterId().equals(operatorId)) {
                this._operatorComboBox.setSelectedIndex(i2);
                break;
            }
            ++i2;
        }
        this._valueTextField.setText(value);
    }

    private void updateExpressionDependentStates() {
        boolean simpleExpression = this._simpleExpressionRadioButton.isSelected();
        this._columnLabel.setEnabled(this._editedFilter != null && simpleExpression);
        this._columnComboBox.setEnabled(this._editedFilter != null && simpleExpression);
        this._operatorLabel.setEnabled(this._editedFilter != null && simpleExpression);
        this._operatorComboBox.setEnabled(this._editedFilter != null && simpleExpression);
        this._valueLabel.setEnabled(this._editedFilter != null && simpleExpression);
        this._valueTextField.setEnabled(this._editedFilter != null && simpleExpression);
        this._insertButton.setEnabled(this._editedFilter != null && simpleExpression);
        this._filterExpressionTextArea.setEnabled(this._editedFilter != null && !simpleExpression);
    }

    private String createSimpleExpression() {
        StringBuffer simpleExpressionBuffer = new StringBuffer();
        simpleExpressionBuffer.append(((ColumnItem)this._columnComboBox.getSelectedItem()).getCustomFilterId());
        simpleExpressionBuffer.append(' ');
        simpleExpressionBuffer.append(((OperatorItem)this._operatorComboBox.getSelectedItem()).getCustomFilterId());
        simpleExpressionBuffer.append(' ');
        simpleExpressionBuffer.append(this._valueTextField.getText());
        return simpleExpressionBuffer.toString();
    }

    private boolean isRecognizedColumnId(String columnId) {
        int i = 0;
        int n = this._columnComboBox.getModel().getSize();
        while (i < n) {
            if (((ColumnItem)this._columnComboBox.getModel().getElementAt(i)).getCustomFilterId().equals(columnId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private CustomFilter createCustomFilter(String filterExpression) {
        try {
            CustomFilter customFilter = CustomFilter.parse(filterExpression);
            return customFilter;
        }
        catch (ParseException pe) {
            CustomFilter customFilter = null;
            return customFilter;
        }
    }

    private int indexOfFilterName(String filterName) {
        int i = 0;
        while (i < this._filterListModel.getSize()) {
            if (((CustomFilter)this._filterListModel.get(i)).getName().equals(filterName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static final CustomFilter[] runDialog() {
        CustomFilterPanel panel = new CustomFilterPanel();
        JEWTDialog dialog = new JEWTDialog(IdeUtil.getMainWindow(), HistoryArb.getString(17), 7);
        dialog.setContent(panel.getGUI());
        dialog.setCenterOver((Component)IdeUtil.getMainWindow());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel.getGUI(), "f1_scscustomfilter_html");
        dialog.addVetoableChangeListener((VetoableChangeListener)new 13(panel));
        return dialog.runDialog() ? panel.getCustomFilters() : null;
    }

    private static final Color getSyntaxBackgroundColor(boolean syntaxValid) {
        return UIManager.getColor(syntaxValid ? "TextField.background" : "ToolTip.background");
    }

    private static final Color getSyntaxForegroundColor(boolean syntaxValid) {
        return UIManager.getColor(syntaxValid ? "TextField.foreground" : "ToolTip.foreground");
    }

    static Color maS$getSyntaxBackgroundColor(boolean bl) {
        return CustomFilterPanel.getSyntaxBackgroundColor(bl);
    }

    static Color maS$getSyntaxForegroundColor(boolean bl) {
        return CustomFilterPanel.getSyntaxForegroundColor(bl);
    }

    static JList ra$_filterList(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._filterList;
    }

    static DefaultListModel ra$_filterListModel(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._filterListModel;
    }

    static JButton ra$_removeButton(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._removeButton;
    }

    static Component ra$_gui(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._gui;
    }

    static void mav$listSelectionChanged(CustomFilterPanel customFilterPanel) {
        customFilterPanel.listSelectionChanged();
    }

    static void mav$updateExpressionDependentStates(CustomFilterPanel customFilterPanel) {
        customFilterPanel.updateExpressionDependentStates();
    }

    static SyntaxTextField ra$_valueTextField(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._valueTextField;
    }

    static int mav$indexOfFilterName(CustomFilterPanel customFilterPanel, String string) {
        return customFilterPanel.indexOfFilterName(string);
    }

    static SyntaxTextArea ra$_filterExpressionTextArea(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._filterExpressionTextArea;
    }

    static CustomFilter mav$createCustomFilter(CustomFilterPanel customFilterPanel, String string) {
        return customFilterPanel.createCustomFilter(string);
    }

    static String mav$createSimpleExpression(CustomFilterPanel customFilterPanel) {
        return customFilterPanel.createSimpleExpression();
    }

    final class 1
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && value instanceof CustomFilter) {
                value = ((CustomFilter)value).getName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            int i = CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).getSelectedIndex();
            if (i <= 0) {
                return;
            }
            Object customFilter = CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).remove(i);
            CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).add(i - 1, customFilter);
            CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).grabFocus();
            CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).setSelectedValue(customFilter, true);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            int i = CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).getSelectedIndex();
            if (i < 0 || i > CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).getSize() - 2) {
                return;
            }
            Object customFilter = CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).remove(i);
            CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).add(i + 1, customFilter);
            CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).grabFocus();
            CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).setSelectedValue(customFilter, true);
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            int i = CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).getSelectedIndex();
            if (i < 0) {
                return;
            }
            CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).remove(i);
            i = Math.min(CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).getSize() - 1, i);
            CustomFilterPanel.ra$_removeButton(CustomFilterPanel.this).grabFocus();
            if (i >= 0) {
                CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).setSelectedIndex(i);
            }
        }
    }

    final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            CustomFilter[] customFilters = HistoryManager.getHistoryManager().getCustomFilterManager().createDefaultFilters();
            CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).removeAllElements();
            int i = 0;
            while (i < customFilters.length) {
                CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).addElement(customFilters[i]);
                ++i;
            }
            if (CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).getSize() > 0) {
                CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).setSelectedIndex(0);
            }
        }
    }

    final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            1 dlg = new 1(CustomFilterPanel.ra$_gui(CustomFilterPanel.this));
            if (!dlg.show(HistoryArb.getString(34), HistoryArb.getString(13), null)) {
                return;
            }
            try {
                CustomFilter customFilter = CustomFilter.parse(CustomFilterPanel.DEFAULT_EXPRESSION);
                customFilter.setName(dlg.getInputValue());
                CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).addElement(customFilter);
                CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).grabFocus();
                CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).setSelectedValue(customFilter, true);
            }
            catch (ParseException pe) {
                Assert.printStackTrace((Throwable)pe);
            }
        }

        final class 1
        extends SimpleInputDialog {
            protected boolean canOk() {
                return super.canOk() && !this.getInputValue().equals("") && CustomFilterPanel.mav$indexOfFilterName(CustomFilterPanel.this, this.getInputValue()) < 0;
            }

            public 1(Component component) {
                super(component);
            }
        }
    }

    final class 7
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent lse) {
            CustomFilterPanel.mav$listSelectionChanged(CustomFilterPanel.this);
        }
    }

    final class 8
    extends DocumentUpdateListener {
        protected void documentUpdate(DocumentEvent de) {
            EventQueue.invokeLater(new 1());
        }

        public 8(CustomFilterPanel customFilterPanel2) {
            super((8)null);
        }

        final class 1
        implements Runnable {
            public void run() {
                CustomFilterPanel.ra$_filterExpressionTextArea(CustomFilterPanel.this).setSyntaxValid(CustomFilterPanel.mav$createCustomFilter(CustomFilterPanel.this, CustomFilterPanel.ra$_filterExpressionTextArea(CustomFilterPanel.this).getText()) != null);
            }
        }
    }

    final class 9
    extends DocumentUpdateListener {
        protected void documentUpdate(DocumentEvent de) {
            EventQueue.invokeLater(new 1());
        }

        public 9(CustomFilterPanel customFilterPanel2) {
            super((9)null);
        }

        final class 1
        implements Runnable {
            public void run() {
                CustomFilterPanel.ra$_valueTextField(CustomFilterPanel.this).setSyntaxValid(CustomFilterPanel.mav$createCustomFilter(CustomFilterPanel.this, CustomFilterPanel.mav$createSimpleExpression(CustomFilterPanel.this)) != null);
            }
        }
    }

    final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            CustomFilterPanel.mav$updateExpressionDependentStates(CustomFilterPanel.this);
        }
    }

    final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            CustomFilterPanel.mav$updateExpressionDependentStates(CustomFilterPanel.this);
        }
    }

    final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            JPanel insertPanel = new JPanel(new BorderLayout());
            JLabel insertLabel = new JLabel();
            JList<String> insertList = new JList<String>();
            insertList.setSelectionMode(0);
            insertList.setPrototypeCellValue("this is a prototype substitution");
            insertList.setVisibleRowCount(3);
            DefaultListModel<String> insertListModel = new DefaultListModel<String>();
            insertList.setModel(insertListModel);
            CustomFilterSubstitution[] substitutions = HistoryManager.getHistoryManager().getCustomFilterManager().getSubstitutions();
            int i = 0;
            while (i < substitutions.length) {
                insertListModel.addElement("${" + substitutions[i].getName() + "}");
                ++i;
            }
            ResourceUtils.resLabel((JLabel)insertLabel, insertList, (String)HistoryArb.getString(0));
            insertLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            insertPanel.add((Component)insertLabel, "North");
            insertPanel.add((Component)new JScrollPane(insertList), "Center");
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)CustomFilterPanel.ra$_gui(CustomFilterPanel.this), (Component)insertPanel, null, (String)HistoryArb.getString(54), (int)3);
            dlg.setDefaultButton(2);
            dlg.setResizable(false);
            if (insertList.getModel().getSize() > 0) {
                insertList.setSelectedIndex(0);
            }
            insertList.addListSelectionListener(new 1(this, dlg, insertList));
            dlg.setOKButtonEnabled(insertList.getSelectedValue() != null);
            if (!dlg.runDialog()) {
                return;
            }
            try {
                int caretPosition = Math.max(0, CustomFilterPanel.ra$_valueTextField(CustomFilterPanel.this).getCaretPosition());
                CustomFilterPanel.ra$_valueTextField(CustomFilterPanel.this).getDocument().insertString(caretPosition, insertList.getSelectedValue().toString(), null);
                CustomFilterPanel.ra$_valueTextField(CustomFilterPanel.this).requestFocus();
            }
            catch (BadLocationException ble) {
                Assert.printStackTrace((Throwable)ble);
            }
        }

        final class 1
        implements ListSelectionListener {
            private final /* synthetic */ JEWTDialog v$dlg;
            private final /* synthetic */ JList v$insertList;
            final /* synthetic */ 12 this$0;

            public void valueChanged(ListSelectionEvent lse) {
                this.v$dlg.setOKButtonEnabled(this.v$insertList.getSelectedValue() != null);
            }

            public 1(12 var1_1, JEWTDialog jEWTDialog, JList jList) {
                this.v$insertList = jList;
                this.v$dlg = jEWTDialog;
                this.this$0 = var1_1;
            }
        }
    }

    static final class 13
    implements VetoableChangeListener {
        private final /* synthetic */ CustomFilterPanel v$panel;

        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                this.v$panel.commitEdits();
            }
        }

        public 13(CustomFilterPanel customFilterPanel) {
            this.v$panel = customFilterPanel;
        }
    }

    private abstract class DocumentUpdateListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent de) {
            this.documentUpdate(de);
        }

        public void insertUpdate(DocumentEvent de) {
            this.documentUpdate(de);
        }

        public void removeUpdate(DocumentEvent de) {
            this.documentUpdate(de);
        }

        protected abstract void documentUpdate(DocumentEvent var1);

        private DocumentUpdateListener() {
        }

        DocumentUpdateListener(8 var2_2) {
            this();
        }

        DocumentUpdateListener(9 var2_2) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnItem
    implements Comparable {
        private final DefaultHistoryProperty _historyProperty;

        ColumnItem(DefaultHistoryProperty historyProperty) {
            this._historyProperty = historyProperty;
        }

        String getCustomFilterId() {
            return this._historyProperty.getCustomFilterId();
        }

        public boolean equals(Object o) {
            return o instanceof ColumnItem && ((ColumnItem)o).getCustomFilterId().equals(this.getCustomFilterId());
        }

        public int hashCode() {
            return this.getCustomFilterId().intern().hashCode();
        }

        public String toString() {
            return this._historyProperty.getName();
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(((ColumnItem)o).toString());
        }
    }

    private class OperatorItem {
        private final String _id;
        private final String _renderedValue;

        OperatorItem(String id) {
            this(id, null);
        }

        OperatorItem(String id, String renderedValue) {
            this._id = id;
            this._renderedValue = renderedValue;
        }

        String getCustomFilterId() {
            return this._id;
        }

        public String toString() {
            return this._renderedValue != null ? this._renderedValue : this._id;
        }
    }

    private class SyntaxTextField
    extends JTextField {
        private boolean _syntaxValid;

        SyntaxTextField() {
            this.updateSyntaxUI();
        }

        void setSyntaxValid(boolean syntaxValid) {
            this._syntaxValid = syntaxValid;
            this.updateSyntaxUI();
        }

        public void setBackground(Color background) {
        }

        public void setForeground(Color foreground) {
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.updateSyntaxUI();
        }

        private void updateSyntaxUI() {
            super.setBackground(CustomFilterPanel.maS$getSyntaxBackgroundColor(this._syntaxValid));
            if (!this.isEnabled()) {
                super.setForeground(this.getDisabledTextColor());
                return;
            }
            super.setForeground(CustomFilterPanel.maS$getSyntaxForegroundColor(this._syntaxValid));
        }
    }

    private class SyntaxTextArea
    extends JTextArea {
        private boolean _syntaxValid;

        SyntaxTextArea() {
            this.updateSyntaxUI();
        }

        void setSyntaxValid(boolean syntaxValid) {
            this._syntaxValid = syntaxValid;
            this.updateSyntaxUI();
        }

        public void setBackground(Color background) {
        }

        public void setForeground(Color foreground) {
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.updateSyntaxUI();
        }

        private void updateSyntaxUI() {
            super.setBackground(CustomFilterPanel.maS$getSyntaxBackgroundColor(this._syntaxValid));
            if (!this.isEnabled()) {
                super.setForeground(this.getDisabledTextColor());
                return;
            }
            super.setForeground(CustomFilterPanel.maS$getSyntaxForegroundColor(this._syntaxValid));
        }
    }
}

