/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.checkboxlist.CheckBoxListCellData;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.history.LocalState;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.history.HistoryEntry;
import oracle.jdeveloper.history.CustomFilter;
import oracle.jdeveloper.history.HistoryElement;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareController;
import oracle.jdevimpl.history.CustomFilterPanel;
import oracle.jdevimpl.history.HistoryAddin;
import oracle.jdevimpl.history.HistoryViewer;
import oracle.jdevimpl.history.LocalHistoryEntry;
import oracle.jdevimpl.history.RestoreDeletionsPanel;
import oracle.jdevimpl.history.ViewableHistoryEntry;
import oracle.jdevimpl.resource.HistoryArb;

class HistoryController
implements Controller {
    private static HistoryController _singleton;

    static HistoryController getInstance() {
        if (_singleton == null) {
            _singleton = new HistoryController();
        }
        return _singleton;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 22) {
            return CompareController.getDefaultController().update(action, context);
        }
        if (cmdId == 18) {
            return CompareController.getDefaultController().update(action, context);
        }
        if (cmdId == CompareAddin.GO_FIRST_CMD_ID || cmdId == CompareAddin.GO_NEXT_CMD_ID || cmdId == CompareAddin.GO_PREVIOUS_CMD_ID || cmdId == CompareAddin.GO_LAST_CMD_ID) {
            return CompareController.getDefaultController().update(action, context);
        }
        if (cmdId == HistoryAddin.CUSTOMIZE_FILTERS_CMD_ID) {
            HistoryManager historyManager = HistoryManager.getHistoryManager();
            CustomFilter[] customFilters = historyManager.getCustomFilterManager().getFilters();
            action.setEnabled(customFilters != null);
            return true;
        }
        if (cmdId == 51) {
            View view = context != null ? context.getView() : null;
            action.setEnabled(view instanceof HistoryViewer);
            return true;
        }
        if (cmdId == oracle.ide.history.HistoryManager.RESTORE_HISTORY_CMD_ID) {
            Element[] selection;
            Node selectedNode = context.getNode();
            if (selectedNode.isReadOnly()) {
                action.setEnabled(false);
                return true;
            }
            HistoryViewer historyViewer = context.getView() instanceof HistoryViewer ? (HistoryViewer)context.getView() : null;
            Element[] elementArray = selection = historyViewer != null ? historyViewer.getSelection() : null;
            if (selection == null || selection.length <= 0 || !(selection[0] instanceof HistoryElement)) {
                action.setEnabled(false);
                return true;
            }
            HistoryEntry entry = ((HistoryElement)selection[0]).getEntry();
            if (entry instanceof LocalHistoryEntry) {
                oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
                action.setEnabled(mgr != null);
                return true;
            }
            action.setEnabled(false);
            return true;
        }
        if (cmdId == HistoryAddin.HISTORY_CMD_ID) {
            Element[] selection = context.getSelection();
            URL url = null;
            if (selection != null && selection.length > 0 && selection.length == 1) {
                if (selection[0] instanceof RelativeDirectoryContextFolder) {
                    URLPath path = ((RelativeDirectoryContextFolder)selection[0]).getRootDirectories();
                    url = path != null ? path.getFirstEntry() : null;
                } else if (selection[0] instanceof Project) {
                    URLPath path = PathsConfiguration.getInstance((Project)((Project)selection[0])).getProjectSourcePath();
                    url = path != null ? path.getFirstEntry() : null;
                } else if (selection[0] instanceof Locatable) {
                    url = ((Locatable)selection[0]).getURL();
                }
            }
            action.setEnabled(url != null ? URLFileSystem.isDirectoryPath(url) : false);
            return true;
        }
        if (cmdId == HistoryAddin.PURGE_HISTORY_CMD_ID) {
            URL url = null;
            if (context.getView() instanceof HistoryViewer) {
                url = context.getNode() != null ? context.getNode().getURL() : null;
            }
            action.setEnabled(url != null && oracle.ide.history.HistoryManager.getHistoryManager().hasLocalHistory(url));
            return true;
        }
        if (cmdId == HistoryAddin.OPEN_HISTORY_VIEWER_CMD_ID) {
            HistoryViewer historyViewer = context.getView() instanceof HistoryViewer ? (HistoryViewer)context.getView() : null;
            Element[] selection = historyViewer != null ? historyViewer.getSelection() : null;
            action.setEnabled(selection != null && selection.length > 0 && selection[0] instanceof HistoryElement && ((HistoryElement)selection[0]).getEntry() instanceof ViewableHistoryEntry);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 22) {
            return CompareController.getDefaultController().handleEvent(action, context);
        }
        if (cmdId == 18) {
            return CompareController.getDefaultController().handleEvent(action, context);
        }
        if (cmdId == CompareAddin.GO_FIRST_CMD_ID || cmdId == CompareAddin.GO_NEXT_CMD_ID || cmdId == CompareAddin.GO_PREVIOUS_CMD_ID || cmdId == CompareAddin.GO_LAST_CMD_ID) {
            return CompareController.getDefaultController().handleEvent(action, context);
        }
        if (cmdId == HistoryAddin.CUSTOMIZE_FILTERS_CMD_ID) {
            HistoryManager historyManager = HistoryManager.getHistoryManager();
            Object[] customFilters = historyManager.getCustomFilterManager().getFilters();
            Object[] customFilters0 = CustomFilterPanel.runDialog();
            if (customFilters0 != null && !Arrays.equals(customFilters, customFilters0)) {
                historyManager.getCustomFilterManager().setFilters((CustomFilter[])customFilters0);
            }
            return true;
        }
        if (cmdId == 51) {
            View view;
            View view2 = view = context != null ? context.getView() : null;
            if (view instanceof HistoryViewer) {
                try {
                    ((HistoryViewer)view).refresh();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (cmdId == oracle.ide.history.HistoryManager.RESTORE_HISTORY_CMD_ID) {
                HistoryEntry entry;
                Element[] selection;
                HistoryViewer historyViewer = context.getView() instanceof HistoryViewer ? (HistoryViewer)context.getView() : null;
                Element[] elementArray = selection = historyViewer != null ? historyViewer.getSelection() : null;
                if (selection != null && selection.length > 0 && selection[0] instanceof HistoryElement && (entry = ((HistoryElement)selection[0]).getEntry()) instanceof LocalHistoryEntry) {
                    LocalState state = ((LocalHistoryEntry)entry).getState();
                    oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
                    if (mgr != null && state != null) {
                        try {
                            mgr.restore(new LocalState[]{state}, context);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                return true;
            }
            if (cmdId == HistoryAddin.HISTORY_CMD_ID) {
                LocalState[] states;
                Element[] selection = context != null ? context.getSelection() : null;
                URLPath path = null;
                if (selection != null && selection.length > 0 && selection.length == 1) {
                    if (selection[0] instanceof RelativeDirectoryContextFolder) {
                        path = ((RelativeDirectoryContextFolder)selection[0]).getRootDirectories();
                    } else if (selection[0] instanceof Project) {
                        path = PathsConfiguration.getInstance((Project)((Project)selection[0])).getProjectSourcePath();
                    } else if (selection[0] instanceof Locatable) {
                        path = new URLPath();
                        path.add(((Locatable)selection[0]).getURL());
                    }
                }
                LocalState[] localStateArray = states = path != null ? this.getRestoreStates(path) : null;
                if (states == null) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)HistoryArb.getString(37), (String)HistoryArb.getString(39), null);
                }
                if (states != null && states.length > 0) {
                    try {
                        oracle.ide.history.HistoryManager.getHistoryManager().restore(states, context);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
            if (cmdId == HistoryAddin.PURGE_HISTORY_CMD_ID) {
                URL url = null;
                if (context.getView() instanceof HistoryViewer) {
                    URL uRL = url = context.getNode() != null ? context.getNode().getURL() : null;
                }
                if (url != null && MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)HistoryArb.format(18, URLFileSystem.getFileName((URL)url)), (String)HistoryArb.getString(15), null)) {
                    oracle.ide.history.HistoryManager.getHistoryManager().clear(new URL[]{url});
                    ((HistoryViewer)context.getView()).refresh();
                }
                return true;
            }
            if (cmdId == HistoryAddin.OPEN_HISTORY_VIEWER_CMD_ID) {
                try {
                    Element[] selection;
                    HistoryViewer historyViewer = context.getView() instanceof HistoryViewer ? (HistoryViewer)context.getView() : null;
                    Element[] elementArray = selection = historyViewer != null ? historyViewer.getSelection() : null;
                    if (selection != null && selection.length > 0 && selection[0] instanceof HistoryElement && ((HistoryElement)selection[0]).getEntry() instanceof ViewableHistoryEntry) {
                        ((ViewableHistoryEntry)((HistoryElement)selection[0]).getEntry()).view(context);
                    }
                }
                catch (Exception e) {
                    ExceptionDialog.showExceptionDialog((Window)IdeUtil.getMainWindow(), (Exception)e);
                }
                return true;
            }
        }
        return false;
    }

    private LocalState[] getRestoreStates(URLPath path) {
        LocalState[] states = null;
        IdeMainWindow parent = Ide.getMainWindow();
        JEWTDialog dialog = DialogUtil.createJEWTDialogOwnedBy((Component)parent);
        if (dialog != null) {
            RestoreDeletionsPanel panel = new RestoreDeletionsPanel();
            dialog.setCenterOver((Component)parent);
            dialog.setContent((Component)panel);
            dialog.setInitialFocus((Component)panel.getObjectTree());
            dialog.setTitle(HistoryArb.getString(31));
            dialog.setButtonMask(7);
            dialog.setResizable(true);
            dialog.setPreferredSize(new Dimension(800, 600));
            dialog.setOKButtonText(HistoryArb.getString(50));
            HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_scsrestorefromlocalhistory_html");
            dialog.pack();
            panel.setModel(path);
            LocalState[] allStates = panel.getAllLocalStates();
            if (allStates == null || allStates.length == 0) {
                return null;
            }
            LocalState[] localStateArray = states = dialog.runDialog() ? panel.getLocalStates() : new LocalState[]{};
            if (states != null) {
                ArrayList<LocalState> filteredList = new ArrayList<LocalState>();
                ArrayList conflicts = new ArrayList();
                CheckBoxListModel model = new CheckBoxListModel();
                int i = 0;
                while (i < states.length) {
                    filteredList.add(states[i]);
                    ++i;
                }
                int count = conflicts.size();
                if (count > 0) {
                    if (count == 1) {
                        LocalState state = (LocalState)conflicts.get(0);
                        String name = URLFileSystem.getPlatformPathName((URL)state.getNodeURL());
                        int result = SelectFilesPanel.showDialog((String)HistoryArb.getString(31), (String)HistoryArb.format(30, new String[]{name}), null, (CheckBoxListModel)model, (boolean)true, (int)1);
                        switch (result) {
                            case 0: {
                                break;
                            }
                            default: {
                                filteredList.clear();
                                break;
                            }
                        }
                    } else {
                        int result = SelectFilesPanel.showDialog((String)HistoryArb.getString(31), null, (String)HistoryArb.getString(44), (CheckBoxListModel)model, (boolean)true, (int)2);
                        switch (result) {
                            case 0: {
                                List selections = model.getSelectionList();
                                if (selections != null) {
                                    int i2 = 0;
                                    while (i2 < count) {
                                        CheckBoxListCellData data = (CheckBoxListCellData)model.getElementAt(i2);
                                        if (!selections.contains(data.getUserObject())) {
                                            filteredList.remove(conflicts.get(i2));
                                        }
                                        ++i2;
                                    }
                                    break;
                                }
                                filteredList.removeAll(conflicts);
                                break;
                            }
                            default: {
                                filteredList.clear();
                                break;
                            }
                        }
                    }
                }
                states = new LocalState[filteredList.size()];
                filteredList.toArray(states);
            }
            dialog.dispose();
        }
        return states;
    }

    HistoryController() {
    }
}

