/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.CustomFilter;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;

public abstract class HistoryFilterComponent
extends JComboBox {
    protected final HistoryComponent _component;
    protected final URL _url;
    private final Collection _providers;
    private final HistoryFilter _initialFilter;
    private final Observer _customFilterObserver;

    private void $init$() {
        this._customFilterObserver = new 1();
    }

    public HistoryFilterComponent(HistoryComponent history, URL url, HistoryFilter initialFilter, Collection providers) {
        this.$init$();
        this._component = history;
        this._url = url;
        this._providers = providers;
        this._initialFilter = initialFilter;
        this.initializeModel(false);
        2 comboRenderer = new 2();
        this.setRenderer(comboRenderer);
        HistoryManager.getHistoryManager().getCustomFilterManager().getFilterObservable().addObserver(this._customFilterObserver);
    }

    public void processKeyEvent(KeyEvent ke) {
        if (ke.getKeyCode() != 37 && ke.getKeyCode() != 39) {
            super.processKeyEvent(ke);
        }
    }

    public HistoryComponent getHistoryComponent() {
        return this._component;
    }

    private void initializeModel() {
        this.initializeModel(true);
    }

    private void initializeModel(boolean doFilter) {
        MyModel model = new MyModel(this.getFilters(), null);
        this.setModel(model);
        if (this._initialFilter != null) {
            int i = 0;
            while (i < model.getSize()) {
                ComboItem item = (ComboItem)model.getElementAt(i);
                if (item instanceof FilterComboItem && FilterComboItem.ra$filter((FilterComboItem)item).equals(this._initialFilter)) {
                    this.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
            if (doFilter) {
                this.filter(this._initialFilter);
            }
        }
    }

    public void detachCustomFilterObserver() {
        HistoryManager.getHistoryManager().getCustomFilterManager().getFilterObservable().deleteObserver(this._customFilterObserver);
    }

    protected List getFilters() {
        ArrayList<FilterComboItem> filters = new ArrayList<FilterComboItem>();
        int lastCount = 0;
        filters.add(new FilterComboItem(HistoryManager.getHistoryManager().getAllFilter()));
        lastCount = filters.size();
        for (HistoryProvider provider : this._providers) {
            filters.add(new FilterComboItem(provider.getTypeFilter()));
        }
        for (HistoryProvider provider : this._providers) {
            HistoryFilter[] predefinedFilters = provider.getPredefinedFilters();
            if (predefinedFilters == null || predefinedFilters.length <= 0) continue;
            int j = 0;
            while (j < predefinedFilters.length) {
                filters.add(new FilterComboItem(predefinedFilters[j]));
                ++j;
            }
        }
        CustomFilter[] customFilters = HistoryManager.getHistoryManager().getCustomFilterManager().getFilters();
        if (customFilters == null) {
            return filters;
        }
        int i = 0;
        while (i < customFilters.length) {
            filters.add(new FilterComboItem(customFilters[i]));
            ++i;
        }
        return filters;
    }

    public HistoryFilter getSelectedFilter() {
        if (this.getSelectedItem() instanceof FilterComboItem) {
            return FilterComboItem.ra$filter((FilterComboItem)this.getSelectedItem());
        }
        return null;
    }

    public void setSelectedFilter(HistoryFilter filter) {
        this.setSelectedItem(new FilterComboItem(filter));
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void refilter() {
        this.filter(this.getSelectedFilter());
    }

    private void filter(HistoryFilter historyFilter) {
        HistoryModel model = this.createHistoryModel(historyFilter, this._component);
        if (model == null) {
            return;
        }
        HistoryEntry selectedEntry = this._component.getSingleSelection();
        Date selectedDate = null;
        RevisionIdentifier selectedRevision = null;
        if (selectedEntry != null) {
            selectedDate = (Date)selectedEntry.getValue(SharedProperties.getDateProperty());
            selectedRevision = (RevisionIdentifier)selectedEntry.getValue(SharedProperties.getRevisionProperty());
        }
        int sortColumn = this._component.getTable().getSortColumn();
        boolean sortAscending = this._component.getTable().isSortAscending();
        this._component.setModel(model);
        this._component.getTable().setSortColumn(sortColumn, sortAscending);
        selectedEntry = null;
        if (selectedRevision != null && selectedDate != null) {
            int i = 0;
            while (i < model.getSize()) {
                HistoryEntry thisEntry = model.getEntry(i);
                RevisionIdentifier thisRevision = (RevisionIdentifier)thisEntry.getValue(SharedProperties.getRevisionProperty());
                Date thisDate = (Date)thisEntry.getValue(SharedProperties.getDateProperty());
                if (thisRevision != null && thisRevision.equals(selectedRevision) && thisDate != null && thisDate.equals(selectedDate)) {
                    selectedEntry = thisEntry;
                    break;
                }
                ++i;
            }
        }
        if (selectedEntry == null) {
            return;
        }
        HistoryEntry selectedEntry0 = selectedEntry;
        EventQueue.invokeLater(new 3(this, selectedEntry0));
    }

    protected abstract HistoryModel createHistoryModel(HistoryFilter var1, HistoryComponent var2);

    static void mav$initializeModel(HistoryFilterComponent historyFilterComponent) {
        historyFilterComponent.initializeModel();
    }

    final class 1
    implements Observer {
        public void update(Observable o, Object arg) {
            HistoryFilterComponent.mav$initializeModel(HistoryFilterComponent.this);
        }
    }

    final class 2
    extends BasicComboBoxRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ComboItem) {
                this.setText(value.toString());
            }
            return c;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ HistoryEntry v$selectedEntry0;
        final /* synthetic */ HistoryFilterComponent this$0;

        public void run() {
            this.this$0._component.setSingleSelection(this.v$selectedEntry0);
        }

        public 3(HistoryFilterComponent historyFilterComponent, HistoryEntry historyEntry) {
            this.v$selectedEntry0 = historyEntry;
            this.this$0 = historyFilterComponent;
        }
    }

    protected abstract class ComboItem {
        protected ComboItem() {
        }
    }

    protected class FilterComboItem
    extends ComboItem {
        private final HistoryFilter filter;

        FilterComboItem(HistoryFilter filter) {
            this.filter = filter;
        }

        public String toString() {
            return this.filter.getShortLabel();
        }

        public boolean equals(Object o) {
            return o instanceof FilterComboItem && this.filter.equals(((FilterComboItem)o).filter);
        }

        static HistoryFilter ra$filter(FilterComboItem filterComboItem) {
            return filterComboItem.filter;
        }
    }

    private class MyModel
    extends DefaultComboBoxModel {
        private final List _filters;

        private MyModel(List filters) {
            this._filters = filters;
        }

        public int getSize() {
            return this._filters.size();
        }

        public Object getElementAt(int index) {
            return this._filters.get(index);
        }

        MyModel(List list, 1 var3_3) {
            this(list);
        }

        public final class 1 {
        }
    }
}

