/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.HistoryElement;
import oracle.jdevimpl.history.HistoryViewer;
import oracle.jdevimpl.resource.HistoryArb;

public class HistoryPropertiesCommand
extends Command {
    public static final String PROPERTIES_CMD = HistoryPropertiesCommand.class.getName();
    public static final int PROPERTIES_CMD_ID = Ide.findOrCreateCmdID((String)PROPERTIES_CMD);
    private HistoryElement _historyElement;
    private HistoryProperty[] _historyProperties;
    private JLabel _revisionIconLabel;
    private JTextField _revisionNameTextField;
    private final ArrayList _propertyLabels;
    private final ArrayList _propertyComponents;

    private void $init$() {
        this._propertyLabels = new ArrayList();
        this._propertyComponents = new ArrayList();
    }

    public HistoryPropertiesCommand() {
        super(PROPERTIES_CMD_ID, 0);
        this.$init$();
    }

    public int doit() throws Exception {
        HistoryElement[] historyElements;
        HistoryViewer historyViewer = (HistoryViewer)this.getContext().getView();
        HistoryComponent historyComponent = historyViewer.getLastActiveHistoryComponent();
        if (historyComponent == null) {
            historyComponent = historyViewer.getLeftHistoryComponent();
        }
        if ((historyElements = historyViewer.getSelection(historyComponent)).length <= 0) {
            return -1;
        }
        this._historyElement = historyElements[0];
        this._historyProperties = historyComponent.getModel().getProperties();
        this.createComponents();
        this.resComponents();
        this.initializeComponents();
        LayoutBuilder layoutBuilder = this.layoutComponents();
        JPanel panel = new JPanel();
        layoutBuilder.addToPanel((Container)panel);
        Box box = Box.createVerticalBox();
        box.add(panel);
        box.add(Box.createHorizontalStrut(350));
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)box, null, (String)HistoryArb.getString(23));
        int buttonMask = 1;
        dialog.setButtonMask(buttonMask);
        dialog.setResizable(false);
        return WizardLauncher.runDialog((JDialog)dialog) ? 0 : 1;
    }

    private void createComponents() {
        this._revisionIconLabel = new JLabel();
        this._revisionNameTextField = new JTextField();
        int i = 0;
        while (i < this._historyProperties.length) {
            JLabel propertyLabel = null;
            JTextComponent propertyComponent = null;
            Object value = this._historyElement.getEntry().getValue(this._historyProperties[i]);
            if (!(value == null || value instanceof String && value.toString().trim().equals(""))) {
                String s;
                propertyLabel = new JLabel();
                propertyComponent = value instanceof String ? ((s = value.toString().trim()).indexOf(10) < 0 && s.indexOf(13) < 0 && s.indexOf(12) < 0 ? (JTextComponent)new JTextField() : new JTextArea()) : new JTextField();
            }
            this._propertyLabels.add(propertyLabel);
            this._propertyComponents.add(propertyComponent);
            ++i;
        }
    }

    private void resComponents() {
        Icon icon = this._historyElement.getIcon();
        if (icon != null && icon instanceof ImageIcon) {
            icon = new ImageIcon(((ImageIcon)icon).getImage().getScaledInstance(48, 48, 4));
        }
        this._revisionIconLabel.setIcon(icon);
        if (this._historyElement.getShortLabel() != null) {
            this._revisionNameTextField.setText(HistoryArb.format(14, this._historyElement.getShortLabel()));
        } else {
            this._revisionNameTextField.setText("");
        }
        int i = 0;
        while (i < this._historyProperties.length) {
            JLabel propertyLabel = (JLabel)this._propertyLabels.get(i);
            JTextComponent propertyComponent = (JTextComponent)this._propertyComponents.get(i);
            if (propertyLabel != null) {
                propertyLabel.setText(HistoryArb.format(35, this._historyProperties[i].getName()));
                Object value = this._historyElement.getEntry().getValue(this._historyProperties[i]);
                if (value instanceof Date) {
                    value = DateFormat.getDateTimeInstance().format((Date)value);
                }
                if (value instanceof Collection) {
                    value = this.formatStringForRendering((Collection)value);
                }
                propertyComponent.setText(value.toString().trim());
            }
            ++i;
        }
    }

    private String formatStringForRendering(Collection c) {
        StringBuffer listBuffer = new StringBuffer();
        for (Object entry : c) {
            if (listBuffer.length() > 0) {
                listBuffer.append(',');
            }
            listBuffer.append(entry.toString());
        }
        return listBuffer.toString();
    }

    private void initializeComponents() {
        this.initializePropertyComponents(null, this._revisionNameTextField);
        int i = 0;
        while (i < this._historyProperties.length) {
            this.initializePropertyComponents((JLabel)this._propertyLabels.get(i), (JComponent)this._propertyComponents.get(i));
            ++i;
        }
    }

    private LayoutBuilder layoutComponents() {
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._revisionIconLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._revisionNameTextField, insets, 1, false, true);
        layoutBuilder.nl();
        Iterator itr = this._propertyLabels.iterator();
        Iterator itr2 = this._propertyComponents.iterator();
        while (itr.hasNext()) {
            JLabel propertyLabel = (JLabel)itr.next();
            JComponent propertyComponent = (JComponent)itr2.next();
            if (propertyLabel == null) continue;
            layoutBuilder.addVGap(8);
            layoutBuilder.nl();
            if (propertyComponent instanceof JTextArea) {
                layoutBuilder.add((Component)propertyLabel, insets, 1, false, false);
                layoutBuilder.addHGap();
                layoutBuilder.add(Box.createHorizontalGlue(), insets, 1, false, true);
                layoutBuilder.nl();
                layoutBuilder.add((Component)new JScrollPane(propertyComponent), insets, 3, false, true);
                layoutBuilder.nl();
                continue;
            }
            layoutBuilder.add((Component)propertyLabel, insets, 1, false, false);
            layoutBuilder.addHGap();
            layoutBuilder.add((Component)propertyComponent, insets, 1, false, true);
            layoutBuilder.nl();
        }
        return layoutBuilder;
    }

    private void initializePropertyComponents(JLabel label, JComponent propertyComponent) {
        if (propertyComponent instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)propertyComponent;
            textComponent.setBorder(BorderFactory.createEmptyBorder());
            textComponent.setBackground(UIManager.getColor("control"));
            textComponent.setEditable(false);
        }
        if (propertyComponent instanceof JTextArea) {
            ((JTextArea)propertyComponent).setRows(4);
            ((JTextArea)propertyComponent).setCaretPosition(0);
        }
        if (label == null || propertyComponent instanceof JTextArea) {
            return;
        }
        int height = Math.max(label.getPreferredSize().height, propertyComponent.getPreferredSize().height);
        label.setPreferredSize(new Dimension(label.getPreferredSize().width, height));
        propertyComponent.setPreferredSize(new Dimension(propertyComponent.getPreferredSize().width, height));
    }
}

