/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.NodeUpdater;
import oracle.ide.ceditor.UndoWrapperCommand;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.DynamicStatusProvider;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.ProgressCompareAlgorithm;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.ActionMenuView;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.ComparePopupManager;
import oracle.javatools.compare.view.CustomHorizontalScrollView;
import oracle.javatools.compare.view.EditableView;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.compare.view.StatusView;
import oracle.javatools.compare.view.ViewEditEvent;
import oracle.javatools.compare.view.ViewEditListener;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.controls.ProgressPanel;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryModelEvent;
import oracle.javatools.history.HistoryModelListener;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.history.DefaultHistoryModel;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.HistoryElement;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.compare.CompareViewOwner;
import oracle.jdevimpl.history.BufferHistoryProvider;
import oracle.jdevimpl.history.HistoryAddin;
import oracle.jdevimpl.history.HistoryController;
import oracle.jdevimpl.history.HistoryFilterComponent;
import oracle.jdevimpl.history.HistoryManagerImpl;
import oracle.jdevimpl.resource.CompareArb;
import oracle.jdevimpl.resource.HistoryArb;

public class HistoryViewer
extends Editor
implements DynamicStatusProvider,
ViewEditListener,
FindableEditor,
ComparePopupManager,
CompareViewOwner {
    private Node _node;
    private JPanel _historyPanel;
    private JPanel _horizontalScrollWrapper;
    private Component _noHistoryPanel;
    private CompareView _compareView;
    private Toolbar _toolbar;
    private JSplitPane _splitPane;
    private HistoryComponent _leftHistoryComponent;
    private HistoryComponent _rightHistoryComponent;
    private JLabel _label;
    private HistoryFilterComponent _filter;
    private MouseListener _mouseListener;
    private JLabel _statusLabel;
    private ChangeListener _providerStatusListener;
    private NodeUpdater _leftUpdater;
    private NodeUpdater _rightUpdater;
    private TableColumnModelListener _lhsColumnModelListener;
    private TableColumnModelListener _rhsColumnModelListener;
    private DefaultHistoryModel _currentHistoryModel;
    private ChangeListener _positionChangeListener;
    private HistorySelectionListener _historySelectionListener;
    private HistoryComponent _lastActiveHistoryComponent;
    private ChangeListener _viewStatusListener;
    private ActionListener _defaultActionListener;
    private final Map<CompareType, CompareView> _compareViewCache;
    private TextBuffer _textBuffer;
    private CompareViewUpdater _compareViewUpdater;

    private void $init$() {
        this._statusLabel = new JLabel();
        this._viewStatusListener = new 1();
        this._defaultActionListener = new 2();
        this._compareViewCache = new HashMap<CompareType, CompareView>();
    }

    boolean isLocalHistoryView() {
        return oracle.jdeveloper.history.HistoryManager.getHistoryManager() instanceof HistoryManagerImpl && this.getHistoryProviders().contains(((HistoryManagerImpl)oracle.jdeveloper.history.HistoryManager.getHistoryManager()).getLocalHistoryProvider());
    }

    protected String getTablePersistenceKeyLHS() {
        return "HistoryViewer.LHS.DisplaySettings";
    }

    protected String getTablePersistenceKeyRHS() {
        return "HistoryViewer.RHS.DisplaySettings";
    }

    protected URL getRealURL() {
        return this._node.getURL();
    }

    private void installHistoryModel() {
        this._leftHistoryComponent = this.createHistoryComponent();
        this._rightHistoryComponent = this.createHistoryComponent();
        this._filter = this.createHistoryFilter();
        this._label = this.createHistoryFilterLabel(this._filter);
        if (this._historyPanel == null) {
            this._historyPanel = new JPanel();
        }
        this._historyPanel.removeAll();
        this.layoutHistoryPanel(this._historyPanel);
        this._splitPane.setBorder(BorderFactory.createEmptyBorder());
        this._splitPane.setTopComponent(this._historyPanel);
        this._splitPane.setResizeWeight(this.getDefaultDividerLocation());
        this.refresh();
    }

    protected Element[] getSelectionFromUI() {
        return this._lastActiveHistoryComponent != null ? this.getSelection(this._lastActiveHistoryComponent) : new HistoryElement[]{};
    }

    HistoryComponent getLastActiveHistoryComponent() {
        return this._lastActiveHistoryComponent;
    }

    boolean isCompareViewComponentFocused() {
        if (this._compareView == null || !(this._compareView instanceof EditorPaneView)) {
            return false;
        }
        BasicEditorPane currentEditorPane = ((EditorPaneView)this._compareView).getCurrentEditorPane();
        return currentEditorPane != null && currentEditorPane.isFocusOwner();
    }

    protected Component createNoHistoryPanel() {
        return new FocusableLabel(oracle.jdeveloper.resource.HistoryArb.getString(10));
    }

    protected HistoryComponent createHistoryComponent() {
        HistoryComponent historyComponent = oracle.jdeveloper.history.HistoryManager.getHistoryManager().createHistoryComponent();
        historyComponent.setUseAutoSizeMaximums(true);
        historyComponent.setSingleSelection(true);
        return historyComponent;
    }

    protected JLabel createToolbarLabel() {
        JLabel toolbarLabel = new JLabel();
        toolbarLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        return toolbarLabel;
    }

    protected HistoryFilterComponent createHistoryFilter() {
        return this.createHistoryFilter(this._leftHistoryComponent);
    }

    protected HistoryFilterComponent createHistoryFilter(HistoryComponent historyComponent) {
        3 filter = new 3(historyComponent, this.getRealURL(), oracle.jdeveloper.history.HistoryManager.getHistoryManager().getAllFilter(), this.getHistoryProviders(this.getRealURL()));
        filter.addItemListener(new 4(this, filter));
        return filter;
    }

    protected void refilterModel() {
        this._filter.refilter();
    }

    protected JLabel createHistoryFilterLabel(HistoryFilterComponent filter) {
        JLabel label = this.createToolbarLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)filter, (String)oracle.jdeveloper.resource.HistoryArb.getString(15));
        return label;
    }

    protected void disposeHistoryFilters() {
        this._filter.detachCustomFilterObserver();
    }

    protected void layoutHistoryPanel(JPanel historyPanel) {
        historyPanel.setLayout(new BorderLayout());
        historyPanel.add((Component)this._leftHistoryComponent, "Center");
    }

    public HistoryFilterComponent getLeftFilter() {
        return this._filter;
    }

    public HistoryComponent getLeftHistoryComponent() {
        return this._leftHistoryComponent;
    }

    public HistoryComponent getRightHistoryComponent() {
        return this._rightHistoryComponent;
    }

    public void refresh() {
        this.refresh(this.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Context context) {
        this.detachForPersistentSettings();
        this._currentHistoryModel = (DefaultHistoryModel)oracle.jdeveloper.history.HistoryManager.getHistoryManager().buildModel(this.getRealURL(), true, null, this.getHistoryProviders());
        HistoryModel model = this.updateHistoryModel(this._leftHistoryComponent, this._filter);
        this.updateHistoryModel(this._rightHistoryComponent, null);
        HistoryEntry selectionLhs = this._leftHistoryComponent.getSingleSelection();
        HistoryEntry selectionRhs = this._rightHistoryComponent.getSingleSelection();
        HistoryEntrySelector historyEntrySelectorLhs = HistoryContext.getHistoryEntrySelectorLHS(context);
        HistoryEntrySelector historyEntrySelectorRhs = HistoryContext.getHistoryEntrySelectorRHS(context);
        if (context != null) {
            HistoryContext.setHistoryEntrySelectorLHS(context, null);
            HistoryContext.setHistoryEntrySelectorRHS(context, null);
        }
        HistoryModel historyModel = model;
        synchronized (historyModel) {
            if (model.isComplete()) {
                this.sortHistoryComponentTables();
                SwingUtilities.invokeLater(new 5(this, selectionLhs, selectionRhs, historyEntrySelectorLhs, historyEntrySelectorRhs));
            } else {
                model.addHistoryModelListener((HistoryModelListener)new 6(this, this, selectionLhs, selectionRhs, historyEntrySelectorLhs, historyEntrySelectorRhs));
            }
        }
    }

    protected HistoryModel updateHistoryModel(HistoryComponent historyComponent, HistoryFilterComponent filter) {
        if (historyComponent == this._rightHistoryComponent) {
            this._rightHistoryComponent.setModel((HistoryModel)new BufferHistoryModel(this.getRealURL(), BufferHistoryProvider.getInstance().getTypeFilter()));
            return null;
        }
        return this.updateHistoryModelImpl(historyComponent, filter);
    }

    protected HistoryModel updateHistoryModelImpl(HistoryComponent historyComponent, HistoryFilterComponent filter) {
        DefaultHistoryModel model = new DefaultHistoryModel(this._currentHistoryModel);
        this.initializeHistoryModel(model, historyComponent);
        if (filter != null) {
            model.applyFilter(this.getRealURL(), filter.getSelectedFilter());
        }
        historyComponent.setModel((HistoryModel)model);
        return model;
    }

    private void initializeHistoryModel(DefaultHistoryModel model, HistoryComponent historyComponent) {
        if (model instanceof DefaultHistoryModel) {
            if (historyComponent == this._leftHistoryComponent) {
                this.initializeDefaultProperties(this.getTablePersistenceKeyLHS(), model);
            }
            if (historyComponent == this._rightHistoryComponent) {
                this.initializeDefaultProperties(this.getTablePersistenceKeyRHS(), model);
            }
        }
    }

    private void initializeDefaultProperties(String key, DefaultHistoryModel model) {
        Collection hiddenPropertyNames = (Collection)Ide.getDTCache().getData(key);
        if (hiddenPropertyNames == null || hiddenPropertyNames.isEmpty()) {
            this.enableAllDefaultProperties(model);
            return;
        }
        ArrayList<HistoryProperty> defaultProperties = new ArrayList<HistoryProperty>();
        HistoryProperty[] properties = model.getProperties();
        int i = 0;
        while (i < properties.length) {
            if (!hiddenPropertyNames.contains(properties[i].getName())) {
                defaultProperties.add(properties[i]);
            }
            ++i;
        }
        model.setDefaultProperties(defaultProperties.toArray(new HistoryProperty[0]));
    }

    protected void enableAllDefaultProperties(DefaultHistoryModel model) {
        model.setDefaultProperties(model.getProperties());
    }

    protected Collection getHistoryProviders() {
        return oracle.jdeveloper.history.HistoryManager.getHistoryManager().getProviders();
    }

    protected Collection getHistoryProviders(URL url) {
        ArrayList<HistoryProvider> forProviders = new ArrayList<HistoryProvider>();
        Collection providers = oracle.jdeveloper.history.HistoryManager.getHistoryManager().getProviders();
        for (HistoryProvider provider : providers) {
            if (!provider.isProviderFor(url)) continue;
            forProviders.add(provider);
        }
        return forProviders;
    }

    private void attachForPersistentSettings() {
        if (this._leftHistoryComponent == null || this._rightHistoryComponent == null) {
            return;
        }
        this._lhsColumnModelListener = new PersistenceTableColumnModelListener(this._leftHistoryComponent, this.getTablePersistenceKeyLHS());
        this._rhsColumnModelListener = new PersistenceTableColumnModelListener(this._rightHistoryComponent, this.getTablePersistenceKeyRHS());
        this._leftHistoryComponent.getTable().getColumnModel().addColumnModelListener(this._lhsColumnModelListener);
        this._rightHistoryComponent.getTable().getColumnModel().addColumnModelListener(this._rhsColumnModelListener);
    }

    private void detachForPersistentSettings() {
        if (this._leftHistoryComponent != null && this._lhsColumnModelListener != null) {
            this._leftHistoryComponent.getTable().getColumnModel().removeColumnModelListener(this._lhsColumnModelListener);
        }
        if (this._rightHistoryComponent != null && this._rhsColumnModelListener != null) {
            this._rightHistoryComponent.getTable().getColumnModel().removeColumnModelListener(this._rhsColumnModelListener);
        }
    }

    private void updateStatusCount(HistoryEntry selectionLhs, HistoryEntry selectionRhs, Object historyEntrySelectorLhs, Object historyEntrySelectorRhs) {
        HistoryEntry selectionRhs0;
        HistoryEntry selectionLhs0;
        if (historyEntrySelectorLhs != null && historyEntrySelectorLhs instanceof HistoryEntrySelector && (selectionLhs0 = ((HistoryEntrySelector)historyEntrySelectorLhs).select(this._leftHistoryComponent.getModel())) != null) {
            selectionLhs = selectionLhs0;
        }
        if (historyEntrySelectorRhs != null && historyEntrySelectorRhs instanceof HistoryEntrySelector && (selectionRhs0 = ((HistoryEntrySelector)historyEntrySelectorRhs).select(this._rightHistoryComponent.getModel())) != null) {
            selectionRhs = selectionRhs0;
        }
        this.updateStatusCount(selectionLhs, selectionRhs);
    }

    private void sortHistoryComponentTables() {
        try {
            this._leftHistoryComponent.sortTableByProperty(SharedProperties.getDateProperty(), false);
            this._rightHistoryComponent.sortTableByProperty(SharedProperties.getDateProperty(), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateStatusCount(HistoryEntry selectionLhs, HistoryEntry selectionRhs) {
        if (this._leftHistoryComponent == null || this._rightHistoryComponent == null) {
            return;
        }
        this.updateStatusCount0(selectionLhs, this._leftHistoryComponent);
        this.updateStatusCount0(selectionRhs, this._rightHistoryComponent);
        this.scrollToHistorySelections();
    }

    private void updateStatusCount0(HistoryEntry selection, HistoryComponent component) {
        if (component == null) {
            return;
        }
        int rows = component.getTable().getModel().getRowCount();
        if (rows > 0) {
            if (selection != null) {
                component.setSingleSelection(selection);
            }
            if (component.getSingleSelection() == null) {
                component.getTable().setRowSelectionInterval(0, 0);
            }
        }
    }

    private void scrollToHistorySelections() {
        if (this._leftHistoryComponent.getTable().getModel().getRowCount() > 0) {
            this._leftHistoryComponent.getTable().scrollToSelection();
        }
        if (this._rightHistoryComponent.getTable().getModel().getRowCount() > 0) {
            this._rightHistoryComponent.getTable().scrollToSelection();
        }
    }

    public Controller getController() {
        return HistoryController.getInstance();
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            this._toolbar.setMinimumSize(new Dimension(0, 0));
        }
        return this._toolbar;
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public Component getBottomComponent() {
        return this._horizontalScrollWrapper;
    }

    public Object getEditorAttribute(String attribute) {
        if ("scrollable".equals(attribute)) {
            return Boolean.FALSE;
        }
        if ("horizontal_scrollbar_policy".equals(attribute)) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(attribute)) {
            return new Integer(21);
        }
        if ("menu_id".equals(attribute)) {
            return oracle.jdeveloper.resource.HistoryArb.getString(2);
        }
        return super.getEditorAttribute(attribute);
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_scslocalhistory_html");
    }

    public ContextMenu getContextMenu() {
        return oracle.jdeveloper.history.HistoryManager.getHistoryManager().getContextMenu();
    }

    public Component getGUI() {
        if (this._splitPane == null) {
            this._splitPane = new JSplitPane(0);
        }
        return this._splitPane;
    }

    public void setContext(Context context) {
        super.setContext(context);
        this._node = context.getNode();
        context.setView((View)this);
        HistoryContext.setRealURL(context, this.getRealURL());
        URL nodeURL = this.getRealURL();
        URL parentURL = URLFileSystem.getParent((URL)nodeURL);
        String nodeFilename = URLFileSystem.getFileName((URL)nodeURL);
        String nodeDirectory = URLFileSystem.getPlatformPathName((URL)parentURL);
        AccessibleUtils.updateAccessibleName((Accessible)((Accessible)((Object)this.getGUI())), (String)MessageFormat.format(oracle.jdeveloper.resource.HistoryArb.getString(21), nodeFilename, nodeDirectory), (boolean)true);
        if (context != null && context.getNode() instanceof TextNode) {
            this._textBuffer = ((TextNode)context.getNode()).acquireTextBuffer();
        }
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (context != null) {
            context.setNode(this._node);
            context.setView((View)this);
            HistoryContext.setRealURL(context, this.getRealURL());
        }
        return context;
    }

    public void open() {
        if (this.getRealURL() != null) {
            this.getGUI();
            this.installHistoryModel();
            this.initializeToolbars();
            Ide.addIdeListener((IdeListener)new 7());
            this._mouseListener = new ContextMenuMouseListener(null);
            this._leftHistoryComponent.addMouseListener(this._mouseListener);
            this._rightHistoryComponent.addMouseListener(this._mouseListener);
            this._historySelectionListener = new HistorySelectionListener(null);
            this._leftHistoryComponent.addListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._rightHistoryComponent.addListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._leftHistoryComponent.getTable().addFocusListener((FocusListener)this._historySelectionListener);
            this._rightHistoryComponent.getTable().addFocusListener((FocusListener)this._historySelectionListener);
            this._lastActiveHistoryComponent = this._leftHistoryComponent;
            8 al = new 8();
            Timer t = new Timer(500, al);
            t.setRepeats(false);
            t.start();
        }
    }

    protected void initializeToolbars() {
        this.getToolbar().removeAll();
        if (this._filter != null) {
            this.addToolbarSeparator();
            this.getToolbar().add((Component)this._label);
            this.getToolbar().add((Component)this._filter);
        }
        this.addToolbarSeparator();
        this._toolbar.add((ToggleAction)this.getLocalAction(HistoryAddin.CUSTOMIZE_FILTERS_CMD_ID));
        this.getToolbar().add((ToggleAction)this.getLocalAction(51));
        this.addToolbarSeparator();
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigateFirst")));
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigatePrevious")));
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigateNext")));
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigateLast")));
        if (this.isLocalHistoryView()) {
            this.addToolbarSeparator();
            this.getToolbar().add((ToggleAction)this.getLocalAction(HistoryAddin.PURGE_HISTORY_CMD_ID));
        }
        if (this.isEditableRHS()) {
            if (!this.isLocalHistoryView()) {
                this.addToolbarSeparator();
            }
            this.getToolbar().add((ToggleAction)this.getLocalAction(HistoryManager.RESTORE_HISTORY_CMD_ID));
        }
        if (!this.isLocalHistoryView() && !this.isEditableRHS()) {
            this.addToolbarSeparator();
        }
        if (CompareAddin.getCreatePatchCommand() != null) {
            this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)CompareAddin.getCreatePatchCommand())));
        }
        this.getToolbar().repaint();
    }

    private void addToolbarSeparator() {
        if (this.getToolbar().getComponentCount() > 0) {
            this.getToolbar().addSeparator();
        }
    }

    protected boolean isEditableRHS() {
        return true;
    }

    protected double getDefaultDividerLocation() {
        return 0.25;
    }

    public void close() {
        this.detachForPersistentSettings();
        this.deinstallUndoableEditListener();
        if (this._compareView instanceof StatusView) {
            ((StatusView)this._compareView).removeStatusListener(this._viewStatusListener);
        }
        if (this._compareView != null) {
            ((BaseCompareView)this._compareView).dispose();
        }
        for (CompareView compareView : this._compareViewCache.values()) {
            ((BaseCompareView)compareView).dispose();
        }
        this._compareViewCache.clear();
        this._leftUpdater = null;
        this._rightUpdater = null;
        this.disposeHistoryFilters();
        this._historyPanel = null;
        this._horizontalScrollWrapper = null;
        this._noHistoryPanel = null;
        this._compareView = null;
        this._toolbar = null;
        this._splitPane = null;
        this._label = null;
        this._filter = null;
        this._mouseListener = null;
        this._statusLabel = null;
        this._lhsColumnModelListener = null;
        this._rhsColumnModelListener = null;
        this._currentHistoryModel = null;
        if (this._historySelectionListener != null) {
            this._leftHistoryComponent.removeListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._rightHistoryComponent.removeListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._leftHistoryComponent.getTable().removeFocusListener((FocusListener)this._historySelectionListener);
            this._rightHistoryComponent.getTable().removeFocusListener((FocusListener)this._historySelectionListener);
        }
        this._historySelectionListener = null;
        this._lastActiveHistoryComponent = null;
        this._leftHistoryComponent = null;
        this._rightHistoryComponent = null;
        super.close();
    }

    public CompareView getCompareView() {
        if (this._compareView != null && this._splitPane != null && this._splitPane.getBottomComponent() == this._compareView.getGUI()) {
            return this._compareView;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompareView() throws Exception {
        HistoryEntry left = this._leftHistoryComponent.getSingleSelection();
        HistoryEntry right = this._rightHistoryComponent.getSingleSelection();
        CompareContributor leftContributor = null;
        CompareContributor rightContributor = null;
        if (left != null && right != null && CompareViewer.isContentComparable(this.getRealURL()) && (leftContributor = left.getCompareContributor()) != null) {
            rightContributor = right.getCompareContributor();
        }
        if (this._compareView != null) {
            this.removeAllListeners();
        }
        if (leftContributor != null && rightContributor != null) {
            CompareType compareType = CompareUtil.getCompareType(leftContributor, rightContributor, this.isLocalHistoryView() ? CompareUtil.getStreamType(rightContributor) : null);
            HistoryViewer historyViewer = this;
            synchronized (historyViewer) {
                if (this._compareViewUpdater != null) {
                    this._compareViewUpdater.cancel();
                }
                this._compareViewUpdater = new CompareViewUpdater(leftContributor, rightContributor, compareType);
            }
            if (compareType.equals((Object)new CompareType("XML")) && (this.exceedsProgressFileSizeForXML(leftContributor) || this.exceedsProgressFileSizeForXML(rightContributor))) {
                ProgressPanel progressPanel = new ProgressPanel();
                progressPanel.setLabelText(HistoryArb.getString(36));
                progressPanel.setCancelingText(HistoryArb.getString(27));
                int split = this._splitPane.getDividerLocation();
                this._splitPane.setBottomComponent((Component)progressPanel);
                this._splitPane.setDividerLocation(split);
                HistoryViewer historyViewer2 = this;
                synchronized (historyViewer2) {
                    this._compareViewUpdater.initializeProgressPanel(progressPanel);
                }
            }
            HistoryViewer historyViewer3 = this;
            synchronized (historyViewer3) {
                this._compareViewUpdater.start();
            }
        }
        this.showNoHistoryPanel();
    }

    private void removeAllListeners() {
        this.deinstallUndoableEditListener();
        if (this._compareView instanceof StatusView) {
            ((StatusView)this._compareView).removeStatusListener(this._viewStatusListener);
        }
        if (this._compareView instanceof NavigableView) {
            ((NavigableView)this._compareView).removePositionListener(this._positionChangeListener);
        }
        if (this._compareView instanceof ActionMenuView) {
            ((ActionMenuView)this._compareView).removePopupManager((ComparePopupManager)this);
        }
        if (this._compareView instanceof ListCompareView) {
            ((ListCompareView)this._compareView).removeDefaultActionListener(this._defaultActionListener);
        }
    }

    protected CompareView createCompareView(CompareModel model) {
        String key = "oracle.jdevimpl.history.HistoryViewer.createCompareView()";
        Assert.startTiming((String)key, null, (boolean)false);
        CompareView compareView = CompareViewFactory.createCompareView((CompareModel)model);
        Assert.endTiming((String)key, (String)key, null, (boolean)false);
        return compareView;
    }

    private void postUpdateCompareView() {
        if (this._providerStatusListener != null) {
            this._providerStatusListener.stateChanged(new ChangeEvent(this));
        }
        if (this._compareView instanceof NavigableView) {
            ((NavigableView)this._compareView).goToInitialDifference();
        }
    }

    private void showNoHistoryPanel() {
        if (this._noHistoryPanel == null) {
            this._noHistoryPanel = this.createNoHistoryPanel();
        }
        int split = this._splitPane.getDividerLocation();
        this._splitPane.setBottomComponent(this._noHistoryPanel);
        this._splitPane.setDividerLocation(split);
        this._statusLabel.setText(CompareArb.getString(17));
        this.postUpdateCompareView();
    }

    private boolean exceedsProgressFileSizeForXML(CompareContributor contributor) {
        return contributor instanceof TextCompareContributor && (double)((TextCompareContributor)contributor).getTextBuffer().getLength() > 16.0 * Math.pow(2.0, 10.0);
    }

    private void updateStatusLabel() {
        if (this._compareView == null || this._compareView.getModel() == null) {
            this._statusLabel.setText("");
            return;
        }
        int[] diffCount = this._compareView.getModel().getDifferenceTypeCounts();
        int diffs = this._compareView.getModel().getDifferenceCount();
        if (diffs == 0) {
            this._statusLabel.setText(CompareArb.getString(17));
        } else {
            this._statusLabel.setText(MessageFormat.format(CompareArb.getString(26), String.valueOf(diffs), String.valueOf(diffCount[0]), String.valueOf(diffCount[1]), String.valueOf(diffCount[2])));
        }
    }

    protected void installUndoableEditListener() {
        if (this._compareView instanceof EditableView) {
            ((EditableView)this._compareView).addViewEditListener((ViewEditListener)this);
        }
    }

    protected void deinstallUndoableEditListener() {
        if (this._compareView instanceof EditableView) {
            ((EditableView)this._compareView).removeViewEditListener((ViewEditListener)this);
        }
    }

    public void viewEditHappened(ViewEditEvent vee) {
        NodeUpdater updater = vee.getContributorKind() == ContributorKind.FIRST ? this._leftUpdater : this._rightUpdater;
        UndoWrapperCommand command = new UndoWrapperCommand((UndoableEdit)vee.getViewEdit(), (Object)updater);
        command.setContext(this.getContext());
        try {
            CommandProcessor.getInstance().invoke((Command)command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateStatusLabel();
        IdeActions.getFileSaveAction().updateAction();
        IdeActions.getFileSaveAsAction().updateAction();
        IdeActions.getFileSaveAllAction().updateAction();
    }

    public HistoryElement[] getSelectionLHS() {
        return this.getSelection(this._leftHistoryComponent);
    }

    public HistoryElement[] getSelectionRHS() {
        return this.getSelection(this._rightHistoryComponent);
    }

    public HistoryElement[] getSelection(HistoryComponent historyComponent) {
        try {
            if (historyComponent == null) {
                HistoryElement[] historyElementArray = new HistoryElement[]{};
                return historyElementArray;
            }
            HistoryEntry[] entries = historyComponent.getSelection();
            if (entries == null) {
                HistoryElement[] historyElementArray = new HistoryElement[]{};
                return historyElementArray;
            }
            HistoryElement[] elements = new HistoryElement[entries.length];
            int i = 0;
            while (i < entries.length) {
                elements[i] = new HistoryElement(entries[i]);
                ++i;
            }
            HistoryElement[] historyElementArray = elements;
            return historyElementArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HistoryElement[0];
        }
    }

    public BasicEditorPane getFocusedEditorPane() {
        if (this._compareView instanceof EditorPaneView) {
            return ((EditorPaneView)this._compareView).getCurrentEditorPane();
        }
        return null;
    }

    public void showPopup(MouseEvent mouseEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            Context context = new Context(this.getContext());
            HistoryContext.setHistoryEntrySelectorLHS(context, null);
            HistoryContext.setHistoryEntrySelectorRHS(context, null);
            context.setEvent((EventObject)mouseEvent);
            contextMenu.show(context);
        }
    }

    public void hidePopup() {
    }

    public JComponent[] getCustomCells() {
        return new JComponent[]{this._statusLabel};
    }

    public boolean isExpandable(JComponent p0) {
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this._providerStatusListener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        if (l == this._providerStatusListener) {
            this._providerStatusListener = null;
        }
    }

    protected IdeAction getLocalAction(int cmdId) {
        IdeAction ideAction = IdeAction.find((int)cmdId);
        if (ideAction != null) {
            IdeAction local = ideAction.newLocalAction((View)this);
            return local;
        }
        throw new IllegalArgumentException("CMDID " + cmdId + " not found");
    }

    public HistoryViewer() {
        this.$init$();
    }

    static void mav$updateCompareView(HistoryViewer historyViewer) {
        historyViewer.updateCompareView();
    }

    static HistoryComponent ra$_leftHistoryComponent(HistoryViewer historyViewer) {
        return historyViewer._leftHistoryComponent;
    }

    static void wa$_lastActiveHistoryComponent(HistoryViewer historyViewer, HistoryComponent historyComponent) {
        historyViewer._lastActiveHistoryComponent = historyComponent;
    }

    static HistoryComponent ra$_rightHistoryComponent(HistoryViewer historyViewer) {
        return historyViewer._rightHistoryComponent;
    }

    static ChangeListener ra$_positionChangeListener(HistoryViewer historyViewer) {
        return historyViewer._positionChangeListener;
    }

    static void wa$_positionChangeListener(HistoryViewer historyViewer, ChangeListener changeListener) {
        historyViewer._positionChangeListener = changeListener;
    }

    static void mav$showNoHistoryPanel(HistoryViewer historyViewer) {
        historyViewer.showNoHistoryPanel();
    }

    static Map ra$_compareViewCache(HistoryViewer historyViewer) {
        return historyViewer._compareViewCache;
    }

    static void wa$_compareView(HistoryViewer historyViewer, CompareView compareView) {
        historyViewer._compareView = compareView;
    }

    static void mav$removeAllListeners(HistoryViewer historyViewer) {
        historyViewer.removeAllListeners();
    }

    static CompareView ra$_compareView(HistoryViewer historyViewer) {
        return historyViewer._compareView;
    }

    static JSplitPane ra$_splitPane(HistoryViewer historyViewer) {
        return historyViewer._splitPane;
    }

    static void wa$_horizontalScrollWrapper(HistoryViewer historyViewer, JPanel jPanel) {
        historyViewer._horizontalScrollWrapper = jPanel;
    }

    static JPanel ra$_horizontalScrollWrapper(HistoryViewer historyViewer) {
        return historyViewer._horizontalScrollWrapper;
    }

    static ChangeListener ra$_viewStatusListener(HistoryViewer historyViewer) {
        return historyViewer._viewStatusListener;
    }

    static ActionListener ra$_defaultActionListener(HistoryViewer historyViewer) {
        return historyViewer._defaultActionListener;
    }

    static void mav$updateStatusLabel(HistoryViewer historyViewer) {
        historyViewer.updateStatusLabel();
    }

    static void mav$postUpdateCompareView(HistoryViewer historyViewer) {
        historyViewer.postUpdateCompareView();
    }

    static void mav$detachForPersistentSettings(HistoryViewer historyViewer) {
        historyViewer.detachForPersistentSettings();
    }

    static void mav$scrollToHistorySelections(HistoryViewer historyViewer) {
        historyViewer.scrollToHistorySelections();
    }

    static void mav$updateStatusCount(HistoryViewer historyViewer, HistoryEntry historyEntry, HistoryEntry historyEntry2, Object object, Object object2) {
        historyViewer.updateStatusCount(historyEntry, historyEntry2, object, object2);
    }

    static void mav$attachForPersistentSettings(HistoryViewer historyViewer) {
        historyViewer.attachForPersistentSettings();
    }

    static void mav$sortHistoryComponentTables(HistoryViewer historyViewer) {
        historyViewer.sortHistoryComponentTables();
    }

    static DefaultHistoryModel ra$_currentHistoryModel(HistoryViewer historyViewer) {
        return historyViewer._currentHistoryModel;
    }

    static void mav$initializeHistoryModel(HistoryViewer historyViewer, DefaultHistoryModel defaultHistoryModel, HistoryComponent historyComponent) {
        historyViewer.initializeHistoryModel(defaultHistoryModel, historyComponent);
    }

    final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent ce) {
            HistoryViewer.mav$updateStatusLabel(HistoryViewer.this);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            try {
                IdeAction.find((int)CompareAddin.COMPARE_DIRECTORY_FILE_CMD_ID).performAction(HistoryViewer.this.getContext());
            }
            catch (Exception e) {
                oracle.javatools.dialogs.ExceptionDialog.showExceptionDialog((Component)HistoryViewer.this.getGUI(), (Throwable)e);
            }
        }
    }

    final class 3
    extends HistoryFilterComponent {
        protected HistoryModel createHistoryModel(HistoryFilter historyFilter, HistoryComponent historyComponent) {
            if (HistoryViewer.ra$_currentHistoryModel(HistoryViewer.this) == null) {
                return null;
            }
            DefaultHistoryModel historyModel = new DefaultHistoryModel(HistoryViewer.ra$_currentHistoryModel(HistoryViewer.this));
            HistoryViewer.mav$initializeHistoryModel(HistoryViewer.this, historyModel, historyComponent);
            if (historyFilter != null) {
                historyModel.applyFilter(HistoryViewer.this.getRealURL(), historyFilter);
            }
            return historyModel;
        }

        public 3(HistoryComponent historyComponent, URL uRL, HistoryFilter historyFilter, Collection collection) {
            super(historyComponent, uRL, historyFilter, collection);
        }
    }

    final class 4
    implements ItemListener {
        private final /* synthetic */ HistoryFilterComponent v$filter;
        final /* synthetic */ HistoryViewer this$0;

        public void itemStateChanged(ItemEvent ie) {
            this.v$filter.refilter();
        }

        public 4(HistoryViewer historyViewer, HistoryFilterComponent historyFilterComponent) {
            this.v$filter = historyFilterComponent;
            this.this$0 = historyViewer;
        }
    }

    final class 5
    implements Runnable {
        private final /* synthetic */ HistoryEntry v$selectionLhs;
        private final /* synthetic */ HistoryEntry v$selectionRhs;
        private final /* synthetic */ Object v$historyEntrySelectorLhs;
        private final /* synthetic */ Object v$historyEntrySelectorRhs;
        final /* synthetic */ HistoryViewer this$0;

        public void run() {
            HistoryViewer.mav$updateStatusCount(this.this$0, this.v$selectionLhs, this.v$selectionRhs, this.v$historyEntrySelectorLhs, this.v$historyEntrySelectorRhs);
            HistoryViewer.mav$attachForPersistentSettings(this.this$0);
        }

        public 5(HistoryViewer historyViewer, HistoryEntry historyEntry, HistoryEntry historyEntry2, Object object, Object object2) {
            this.v$historyEntrySelectorRhs = object2;
            this.v$historyEntrySelectorLhs = object;
            this.v$selectionRhs = historyEntry2;
            this.v$selectionLhs = historyEntry;
            this.this$0 = historyViewer;
        }
    }

    final class 6
    extends CompletionListener {
        private final /* synthetic */ HistoryEntry v$selectionLhs;
        private final /* synthetic */ HistoryEntry v$selectionRhs;
        private final /* synthetic */ Object v$historyEntrySelectorLhs;
        private final /* synthetic */ Object v$historyEntrySelectorRhs;
        final /* synthetic */ HistoryViewer this$0;

        protected void complete() {
            HistoryViewer.mav$sortHistoryComponentTables(this.this$0);
            HistoryViewer.mav$updateStatusCount(this.this$0, this.v$selectionLhs, this.v$selectionRhs, this.v$historyEntrySelectorLhs, this.v$historyEntrySelectorRhs);
            HistoryViewer.mav$attachForPersistentSettings(this.this$0);
        }

        public 6(HistoryViewer historyViewer, HistoryViewer historyViewer2, HistoryEntry historyEntry, HistoryEntry historyEntry2, Object object, Object object2) {
            this.v$historyEntrySelectorRhs = object2;
            this.v$historyEntrySelectorLhs = object;
            this.v$selectionRhs = historyEntry2;
            this.v$selectionLhs = historyEntry;
            this.this$0 = historyViewer;
            super(null);
        }
    }

    private class PersistenceTableColumnModelListener
    implements TableColumnModelListener {
        private final HistoryComponent _historyComponent;
        private final String _key;

        PersistenceTableColumnModelListener(HistoryComponent historyComponent, String key) {
            this._historyComponent = historyComponent;
            this._key = key;
        }

        public void columnAdded(TableColumnModelEvent e) {
            this.storePersistentSettings();
        }

        public void columnRemoved(TableColumnModelEvent e) {
            this.storePersistentSettings();
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        private void storePersistentSettings() {
            EventQueue.invokeLater(new 1());
        }

        static HistoryComponent ra$_historyComponent(PersistenceTableColumnModelListener persistenceTableColumnModelListener) {
            return persistenceTableColumnModelListener._historyComponent;
        }

        static String ra$_key(PersistenceTableColumnModelListener persistenceTableColumnModelListener) {
            return persistenceTableColumnModelListener._key;
        }

        final class 1
        implements Runnable {
            public void run() {
                HistoryProperty[] hiddenProperties = PersistenceTableColumnModelListener.ra$_historyComponent(PersistenceTableColumnModelListener.this).getHiddenProperties();
                ArrayList<String> hiddenPropertyNames = new ArrayList<String>();
                int i = 0;
                while (i < hiddenProperties.length) {
                    hiddenPropertyNames.add(hiddenProperties[i].getName());
                    ++i;
                }
                Ide.getDTCache().putData(PersistenceTableColumnModelListener.ra$_key(PersistenceTableColumnModelListener.this), hiddenPropertyNames);
            }
        }
    }

    final class 7
    extends IdeAdapter {
        public void mainWindowClosing(IdeEvent e) {
            HistoryViewer.mav$detachForPersistentSettings(HistoryViewer.this);
        }
    }

    final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            if (HistoryViewer.ra$_splitPane(HistoryViewer.this) != null) {
                HistoryViewer.ra$_splitPane(HistoryViewer.this).setDividerLocation(HistoryViewer.this.getDefaultDividerLocation());
                HistoryViewer.ra$_splitPane(HistoryViewer.this).validate();
                HistoryViewer.ra$_splitPane(HistoryViewer.this).repaint();
            }
            if (HistoryViewer.ra$_leftHistoryComponent(HistoryViewer.this) != null && HistoryViewer.ra$_rightHistoryComponent(HistoryViewer.this) != null) {
                HistoryViewer.mav$scrollToHistorySelections(HistoryViewer.this);
            }
        }
    }

    private class HistorySelectionListener
    extends FocusAdapter
    implements ListSelectionListener {
        public void focusGained(FocusEvent e) {
            this.updateLastActiveHistoryComponent(e.getComponent());
            HistoryViewer.this.scheduleUpdateSelection();
        }

        public void focusLost(FocusEvent e) {
            this.updateLastActiveHistoryComponent(e.getOppositeComponent());
            HistoryViewer.this.scheduleUpdateSelection();
        }

        private void updateLastActiveHistoryComponent(Component c) {
            if (HistoryViewer.ra$_leftHistoryComponent(HistoryViewer.this) != null && c == HistoryViewer.ra$_leftHistoryComponent(HistoryViewer.this).getTable()) {
                HistoryViewer.wa$_lastActiveHistoryComponent(HistoryViewer.this, HistoryViewer.ra$_leftHistoryComponent(HistoryViewer.this));
            }
            if (HistoryViewer.ra$_rightHistoryComponent(HistoryViewer.this) != null && c == HistoryViewer.ra$_rightHistoryComponent(HistoryViewer.this).getTable()) {
                HistoryViewer.wa$_lastActiveHistoryComponent(HistoryViewer.this, HistoryViewer.ra$_rightHistoryComponent(HistoryViewer.this));
            }
        }

        public void valueChanged(ListSelectionEvent lse) {
            if (lse.getValueIsAdjusting()) {
                return;
            }
            try {
                try {
                    HistoryViewer.mav$updateCompareView(HistoryViewer.this);
                }
                catch (Exception cfe) {
                    cfe.printStackTrace();
                }
            }
            finally {
                HistoryViewer.this.scheduleUpdateSelection();
            }
        }

        private HistorySelectionListener() {
        }

        HistorySelectionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CompareViewUpdater
    extends SwingWorker {
        private final CompareContributor _leftContributor;
        private final CompareContributor _rightContributor;
        private final CompareType _compareType;
        private CompareAlgorithm _compareAlgorithm;

        CompareViewUpdater(CompareContributor leftContributor, CompareContributor rightContributor, CompareType compareType) {
            this._leftContributor = leftContributor;
            this._rightContributor = rightContributor;
            this._compareType = compareType;
            this._compareAlgorithm = CompareModelFactory.createCompareAlgorithm((CompareType)this._compareType);
        }

        void initializeProgressPanel(ProgressPanel progressPanel) {
            boolean enabled = this._compareAlgorithm != null && this._compareAlgorithm instanceof ProgressCompareAlgorithm;
            progressPanel.setCancelEnabled(enabled);
            if (!enabled) {
                return;
            }
            progressPanel.addCancelActionListener((ActionListener)new 1());
        }

        void cancel() {
            if (this._compareAlgorithm != null && this._compareAlgorithm instanceof ProgressCompareAlgorithm) {
                ((ProgressCompareAlgorithm)this._compareAlgorithm).cancel();
            }
        }

        public Object construct() {
            try {
                String key = "oracle.jdevimpl.history.HistoryViewer.CompareViewUpdater.construct()";
                Assert.startTiming((String)key, null, (boolean)false);
                CompareModel o = CompareUtil.createCompareModel(this._leftContributor, this._rightContributor, this._compareType, this._compareAlgorithm);
                Assert.endTiming((String)key, (String)key, null, (boolean)false);
                CompareModel compareModel = o;
                return compareModel;
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var5_5 = null;
                return var5_5;
            }
        }

        public void finished() {
            CompareModel model;
            if (HistoryViewer.ra$_positionChangeListener(HistoryViewer.this) == null) {
                HistoryViewer.wa$_positionChangeListener(HistoryViewer.this, new 2());
            }
            if ((model = (CompareModel)this.getValue()) == null) {
                HistoryViewer.mav$showNoHistoryPanel(HistoryViewer.this);
                return;
            }
            CompareView cacheCompareView = (CompareView)HistoryViewer.ra$_compareViewCache(HistoryViewer.this).get(model.getType());
            if (cacheCompareView != null) {
                HistoryViewer.wa$_compareView(HistoryViewer.this, cacheCompareView);
                HistoryViewer.mav$removeAllListeners(HistoryViewer.this);
            }
            if (HistoryViewer.ra$_compareView(HistoryViewer.this) == null || !HistoryViewer.ra$_compareView(HistoryViewer.this).getModel().getType().equals((Object)model.getType())) {
                HistoryViewer.wa$_compareView(HistoryViewer.this, HistoryViewer.this.createCompareView(model));
                HistoryViewer.ra$_compareViewCache(HistoryViewer.this).put(model.getType(), HistoryViewer.ra$_compareView(HistoryViewer.this));
                int split = HistoryViewer.ra$_splitPane(HistoryViewer.this).getDividerLocation();
                HistoryViewer.ra$_splitPane(HistoryViewer.this).setBottomComponent(HistoryViewer.ra$_compareView(HistoryViewer.this).getGUI());
                HistoryViewer.ra$_splitPane(HistoryViewer.this).setDividerLocation(split);
                if (HistoryViewer.ra$_compareView(HistoryViewer.this) instanceof CustomHorizontalScrollView) {
                    HistoryViewer.wa$_horizontalScrollWrapper(HistoryViewer.this, new JPanel());
                    HistoryViewer.ra$_horizontalScrollWrapper(HistoryViewer.this).setLayout(new BorderLayout());
                    HistoryViewer.ra$_horizontalScrollWrapper(HistoryViewer.this).removeAll();
                    HistoryViewer.ra$_horizontalScrollWrapper(HistoryViewer.this).add(((CustomHorizontalScrollView)HistoryViewer.ra$_compareView(HistoryViewer.this)).getHorizontalScrollComponent(), "Center");
                }
                HistoryViewer.ra$_splitPane(HistoryViewer.this).repaint();
            } else {
                String key = "oracle.jdevimpl.history.HistoryViewer.CompareViewUpdater.finished()";
                Assert.startTiming((String)key, null, (boolean)false);
                HistoryViewer.ra$_compareView(HistoryViewer.this).setModel(model);
                Assert.endTiming((String)key, (String)key, null, (boolean)false);
            }
            HistoryViewer.this.installUndoableEditListener();
            if (HistoryViewer.ra$_compareView(HistoryViewer.this) instanceof StatusView) {
                ((StatusView)HistoryViewer.ra$_compareView(HistoryViewer.this)).addStatusListener(HistoryViewer.ra$_viewStatusListener(HistoryViewer.this));
            }
            if (HistoryViewer.ra$_compareView(HistoryViewer.this) instanceof NavigableView) {
                ((NavigableView)HistoryViewer.ra$_compareView(HistoryViewer.this)).addPositionListener(HistoryViewer.ra$_positionChangeListener(HistoryViewer.this));
            }
            if (HistoryViewer.ra$_compareView(HistoryViewer.this) instanceof ActionMenuView) {
                ((ActionMenuView)HistoryViewer.ra$_compareView(HistoryViewer.this)).removePopupManager((ComparePopupManager)HistoryViewer.this);
                ((ActionMenuView)HistoryViewer.ra$_compareView(HistoryViewer.this)).addPopupManager((ComparePopupManager)HistoryViewer.this);
            }
            if (HistoryViewer.ra$_compareView(HistoryViewer.this) instanceof ListCompareView) {
                ((ListCompareView)HistoryViewer.ra$_compareView(HistoryViewer.this)).removeDefaultActionListener(HistoryViewer.ra$_defaultActionListener(HistoryViewer.this));
                ((ListCompareView)HistoryViewer.ra$_compareView(HistoryViewer.this)).addDefaultActionListener(HistoryViewer.ra$_defaultActionListener(HistoryViewer.this));
            }
            if (HistoryViewer.ra$_splitPane(HistoryViewer.this).getBottomComponent() != HistoryViewer.ra$_compareView(HistoryViewer.this).getGUI()) {
                int split = HistoryViewer.ra$_splitPane(HistoryViewer.this).getDividerLocation();
                HistoryViewer.ra$_splitPane(HistoryViewer.this).setBottomComponent(HistoryViewer.ra$_compareView(HistoryViewer.this).getGUI());
                HistoryViewer.ra$_splitPane(HistoryViewer.this).setDividerLocation(split);
            }
            HistoryViewer.mav$updateStatusLabel(HistoryViewer.this);
            HistoryViewer.mav$postUpdateCompareView(HistoryViewer.this);
        }

        static CompareAlgorithm ra$_compareAlgorithm(CompareViewUpdater compareViewUpdater) {
            return compareViewUpdater._compareAlgorithm;
        }

        final class 1
        implements ActionListener {
            public void actionPerformed(ActionEvent ae) {
                ((ProgressCompareAlgorithm)CompareViewUpdater.ra$_compareAlgorithm(CompareViewUpdater.this)).cancel();
            }
        }

        final class 2
        implements ChangeListener {
            public void stateChanged(ChangeEvent ce) {
                HistoryViewer.this.updateVisibleActions();
            }
        }
    }

    private abstract class CompletionListener
    implements HistoryModelListener {
        protected abstract void complete();

        public void completenessChanged(HistoryModelEvent vhe) {
            try {
                HistoryModel model = (HistoryModel)vhe.getSource();
                if (model.isComplete()) {
                    SwingUtilities.invokeLater(new 1());
                    model.removeHistoryModelListener((HistoryModelListener)this);
                }
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Context)HistoryViewer.this.getContext(), (Throwable)re);
            }
        }

        public void entriesChanged(HistoryModelEvent vhe) {
        }

        public void entriesInserted(HistoryModelEvent vhe) {
        }

        public void entriesRemoved(HistoryModelEvent vhe) {
        }

        private CompletionListener() {
        }

        CompletionListener(6 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            public void run() {
                CompletionListener.this.complete();
            }
        }
    }

    private class ContextMenuMouseListener
    extends MouseAdapter {
        private void doIt(MouseEvent me) {
            Object source = me.getSource();
            if (!(source instanceof JTable)) {
                return;
            }
            JTable table = (JTable)source;
            ContextMenu menu = HistoryViewer.this.getContextMenu();
            if (me.isPopupTrigger()) {
                int row = table.rowAtPoint(me.getPoint());
                if (row >= 0 && !table.isRowSelected(row)) {
                    table.setRowSelectionInterval(row, row);
                }
                table.requestFocus();
                EventQueue.invokeLater(new 1(this, menu, me));
            } else if (me.getClickCount() == 2 && me.getButton() == 1 && table.rowAtPoint(me.getPoint()) >= 0) {
                menu.fireDefaultAction(HistoryViewer.this.getContext(me));
                me.consume();
            }
        }

        public void mouseReleased(MouseEvent me) {
            this.doIt(me);
        }

        public void mousePressed(MouseEvent me) {
            this.doIt(me);
        }

        public void mouseClicked(MouseEvent me) {
            this.doIt(me);
        }

        private ContextMenuMouseListener() {
        }

        ContextMenuMouseListener(1 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ ContextMenu v$menu;
            private final /* synthetic */ MouseEvent v$me;
            final /* synthetic */ ContextMenuMouseListener this$0;

            public void run() {
                this.v$menu.show(this.this$0.HistoryViewer.this.getContext(this.v$me));
            }

            public 1(ContextMenuMouseListener contextMenuMouseListener, ContextMenu contextMenu, MouseEvent mouseEvent) {
                this.v$me = mouseEvent;
                this.v$menu = contextMenu;
                this.this$0 = contextMenuMouseListener;
            }
        }
    }

    private static final class BufferHistoryModel
    extends DefaultHistoryModel {
        BufferHistoryModel(URL url, HistoryFilter filter) {
            BufferHistoryProvider provider = BufferHistoryProvider.getInstance();
            if (((HistoryProvider)provider).isProviderFor(url)) {
                this.addProperties(((HistoryProvider)provider).getProperties());
                HistoryEntry[] entries = ((HistoryProvider)provider).getEntries(url, null);
                this.addEntries(entries);
            }
        }
    }
}

