/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.io.IOException;
import java.net.URL;
import oracle.ide.history.LocalState;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.history.DefaultHistoryEntry;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.resource.HistoryArb;
import oracle.jdevimpl.compare.XmlContextFactory;

final class LocalHistoryEntry
extends DefaultHistoryEntry {
    private static final RevisionIdentifier _LOCAL_REVISION = new RevisionIdentifier(HistoryArb.getIcon(11), HistoryArb.getString(17));
    private final LocalState _state;
    private CompareContributor _compareContributor;

    LocalHistoryEntry(LocalState state) {
        this._state = state;
        this.setValue(SharedProperties.getDateProperty(), state.getDate());
        this.setValue(SharedProperties.getRevisionProperty(), _LOCAL_REVISION);
        this.setValue(SharedProperties.getDescriptionProperty(), state.getDescription());
    }

    public CompareContributor getCompareContributor() {
        try {
            if (this._compareContributor == null) {
                this._compareContributor = new LocalHistoryContributor(this._state);
            }
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
        }
        return this._compareContributor;
    }

    public LocalState getState() {
        return this._state;
    }

    private static final class LocalHistoryContributor
    extends URLContributor {
        private final LocalState _state;
        private final String _type;
        private Object _xmlContext;

        public LocalHistoryContributor(LocalState state) throws IOException {
            super(state.getNodeURL(), state.getDataURL());
            this._type = LocalHistoryContributor.getPlatformPathSuffix(state.getNodeURL());
            this._state = state;
            if (this.getStreamType() == StreamType.XML && this.getDocumentModel() == null) {
                this._xmlContext = XmlContextFactory.getXmlContextFactory().createBufferContext(this.getTextBuffer());
                this.setDocumentModel(this._xmlContext);
            }
        }

        public String getType() {
            return this._type;
        }

        public String getShortLabel() {
            return URLFileSystem.getFileName((URL)this._state.getNodeURL());
        }

        public String getLongLabel() {
            return URLFileSystem.getPlatformPathName((URL)this._state.getNodeURL());
        }

        public PatchCompareDescriptor getPatchDescriptor() {
            PatchCompareDescriptor patchDescriptor = new PatchCompareDescriptor(URLFileSystem.getFileName((URL)this._state.getNodeURL()));
            patchDescriptor.setPatchParentURL(URLFileSystem.getParent((URL)this._state.getNodeURL()));
            patchDescriptor.setLastModified(URLFileSystem.lastModified((URL)this._state.getNodeURL()));
            return patchDescriptor;
        }
    }
}

