/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.history.HistoryManager;
import oracle.ide.history.LocalState;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.resource.HistoryArb;
import oracle.jdevimpl.history.LocalHistoryEntry;

class LocalHistoryProvider
extends HistoryProvider {
    static final HistoryProperty[] PROPERTIES = new HistoryProperty[]{SharedProperties.getDateProperty(), SharedProperties.getRevisionProperty(), SharedProperties.getDescriptionProperty()};
    private static final HistoryFilter _TYPE_FILTER = new 1();

    public HistoryFilter getTypeFilter() {
        return _TYPE_FILTER;
    }

    public HistoryProperty[] getProperties() {
        return PROPERTIES;
    }

    public boolean isProviderFor(URL url) {
        try {
            if (url.getProtocol() != null && !url.getProtocol().equals("file")) {
                boolean bl = false;
                return bl;
            }
            HistoryManager mgr = HistoryManager.getHistoryManager();
            if (mgr != null) {
                if (URLFileSystem.isDirectory((URL)url)) {
                    boolean bl = false;
                    return bl;
                }
                Class cls = Recognizer.recognizeURL((URL)url);
                boolean bl = cls != null && mgr.getRegisteredHistorian(cls) != null;
                return bl;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public HistoryEntry[] getEntries(URL url, HistoryFilter filter) {
        ArrayList<LocalHistoryEntry> entries = new ArrayList<LocalHistoryEntry>();
        try {
            LocalState[] states = null;
            HistoryManager mgr = HistoryManager.getHistoryManager();
            if (mgr != null && !URLFileSystem.isDirectory((URL)url) && (states = mgr.getLocalHistory(url)) != null && states.length > 0) {
                int i = 0;
                while (i < states.length) {
                    entries.add(new LocalHistoryEntry(states[i]));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HistoryEntry[] result = new HistoryEntry[entries.size()];
        entries.toArray(result);
        return result;
    }

    static final class 1
    implements HistoryFilter {
        public String getShortLabel() {
            return HistoryArb.getString(31);
        }

        public boolean accept(HistoryEntry entry) {
            return entry instanceof LocalHistoryEntry;
        }
    }
}

