/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.history.LocalState;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.history.DefaultHistoryModel;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdevimpl.history.LocalHistoryEntry;
import oracle.jdevimpl.history.LocalHistoryProvider;
import oracle.jdevimpl.resource.HistoryArb;

public class RestoreDeletionsPanel
extends JPanel {
    private CardLayout mainLayout;
    private Border emptyBorder;
    private Border paddedBorder;
    private JSplitPane verticalSplit;
    private JSplitPane horizontalSplit;
    private BorderLayout objectLayout;
    private JPanel objectPanel;
    private JLabel objectLabel;
    private JScrollPane objectScroll;
    private CustomJTree objectTree;
    private DefaultMutableTreeNode objectTreeRoot;
    private JPanel historyPanel;
    private BorderLayout historyLayout;
    private JLabel historyLabel;
    private JScrollPane historyScroll;
    private HistoryComponent historyList;
    private JPanel previewPanel;
    private BorderLayout previewLayout;
    private JLabel previewLabel;
    private JScrollPane previewScroll;
    private BasicEditorPane previewEditPane;
    private HashMap objectTreeNodes;
    private HashMap revisionMappings;

    private void $init$() {
        this.mainLayout = new CardLayout();
        this.emptyBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.paddedBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.verticalSplit = new JSplitPane();
        this.horizontalSplit = new JSplitPane();
        this.objectLayout = new BorderLayout();
        this.objectPanel = new JPanel();
        this.objectLabel = new JLabel();
        this.objectScroll = new JScrollPane();
        this.objectTree = new CustomJTree();
        this.historyPanel = new JPanel();
        this.historyLayout = new BorderLayout();
        this.historyLabel = new JLabel();
        this.historyScroll = new JScrollPane();
        this.historyList = HistoryManager.getHistoryManager().createHistoryComponent();
        this.previewPanel = new JPanel();
        this.previewLayout = new BorderLayout();
        this.previewLabel = new JLabel();
        this.previewScroll = new JScrollPane();
        this.previewEditPane = new BasicEditorPane();
        this.objectTreeNodes = new HashMap();
        this.revisionMappings = new HashMap();
    }

    public RestoreDeletionsPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.verticalSplit.setOrientation(0);
        this.horizontalSplit.setBorder(this.emptyBorder);
        DefaultTreeSelectionModel selModel = new DefaultTreeSelectionModel();
        JTreeCellData treeCellData = new JTreeCellData(null, null, true, TriStateBoolean.TRUE);
        this.objectTreeRoot = new JMutableTreeNode(treeCellData);
        selModel.setSelectionMode(1);
        this.objectLayout.setVgap(2);
        this.objectPanel.setLayout(this.objectLayout);
        this.objectPanel.setBorder(this.emptyBorder);
        this.objectLabel.setBorder(this.paddedBorder);
        ResourceUtils.resLabel((JLabel)this.objectLabel, (Component)this.objectTree, (String)HistoryArb.getString(25));
        this.objectScroll.setBorder(this.emptyBorder);
        this.objectTree.setBorder(this.emptyBorder);
        this.objectTree.setModel((TreeModel)new DefaultTreeModel(this.objectTreeRoot));
        this.objectTree.setRootVisible(false);
        this.objectTree.setScrollsOnExpand(true);
        this.objectTree.setSelectionModel((TreeSelectionModel)selModel);
        this.objectTree.addTreeSelectionListener((TreeSelectionListener)new 1());
        this.historyLayout.setVgap(2);
        this.historyPanel.setLayout(this.historyLayout);
        this.historyPanel.setBorder(this.emptyBorder);
        this.historyLabel.setBorder(this.paddedBorder);
        ResourceUtils.resLabel((JLabel)this.historyLabel, (Component)this.historyList.getTable(), (String)HistoryArb.getString(33));
        this.historyScroll.setBorder(this.emptyBorder);
        this.historyList.setSingleSelection(true);
        this.historyList.setBorder(this.emptyBorder);
        this.historyList.addListSelectionListener((ListSelectionListener)new 2());
        this.previewLayout.setVgap(2);
        this.previewPanel.setLayout(this.previewLayout);
        this.previewPanel.setBorder(this.emptyBorder);
        this.previewLabel.setBorder(this.paddedBorder);
        ResourceUtils.resLabel((JLabel)this.previewLabel, (Component)this.previewEditPane, (String)HistoryArb.getString(3));
        this.previewScroll.setBorder(this.emptyBorder);
        this.previewEditPane.setEditable(false);
        this.previewEditPane.setBorder(this.emptyBorder);
        this.historyScroll.getViewport().add((Component)this.historyList, null);
        this.historyPanel.add((Component)this.historyLabel, "North");
        this.historyPanel.add((Component)this.historyScroll, "Center");
        this.horizontalSplit.add((Component)this.historyPanel, "right");
        this.objectScroll.getViewport().add((Component)this.objectTree, null);
        this.objectPanel.add((Component)this.objectLabel, "North");
        this.objectPanel.add((Component)this.objectScroll, "Center");
        this.horizontalSplit.add((Component)this.objectPanel, "left");
        this.verticalSplit.add((Component)this.horizontalSplit, "top");
        this.previewScroll.getViewport().add((Component)this.previewEditPane, null);
        this.previewPanel.add((Component)this.previewLabel, "North");
        this.previewPanel.add((Component)this.previewScroll, "Center");
        this.verticalSplit.add((Component)this.previewPanel, "bottom");
        this.add((Component)this.verticalSplit, "jSplitPane1");
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.objectTree);
    }

    public void setModel(URLPath path) {
        this.revisionMappings.clear();
        this.objectTreeNodes.clear();
        this.objectTreeRoot.removeAllChildren();
        if (path != null) {
            URL[] entries = path.getEntries();
            int count = 0;
            int i = 0;
            while (i < entries.length) {
                if (entries[i] != null) {
                    int j = 0;
                    while (j < entries.length) {
                        if (j != i && entries[j] != null && URLFileSystem.isBaseURLFor((URL)entries[i], (URL)entries[j])) {
                            entries[j] = null;
                            ++count;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (count > 0) {
                URL[] temp = new URL[entries.length - count];
                count = 0;
                int i2 = 0;
                while (i2 < entries.length) {
                    if (entries[i2] != null) {
                        temp[count++] = entries[i2];
                    }
                    ++i2;
                }
                entries = temp;
            }
            if (entries != null) {
                int i3 = 0;
                while (i3 < entries.length) {
                    Object[] deletions;
                    URL url = entries[i3];
                    URL parentURL = URLFileSystem.getParent((URL)url);
                    if (parentURL != null) {
                        this.objectTreeNodes.put(parentURL, this.objectTreeRoot);
                    }
                    this.addObjectTreeNode(url);
                    oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
                    Object[] objectArray = deletions = mgr != null ? mgr.getDeletions(url) : null;
                    if (deletions != null && deletions.length > 0) {
                        this.populateObjectTree(deletions);
                    }
                    ++i3;
                }
            }
        }
        TreePath nodePath = new TreePath(this.objectTreeRoot);
        this.objectTree.collapsePath(nodePath);
        this.objectTree.expandPath(nodePath);
        this.objectTree.expandAllRows();
        this.objectTree.setSelectionRow(0);
        this.horizontalSplit.setDividerLocation(0.5);
        this.verticalSplit.setDividerLocation(0.33);
    }

    CustomJTree getObjectTree() {
        return this.objectTree;
    }

    LocalState[] getAllLocalStates() {
        Enumeration<TreeNode> e;
        ArrayList<LocalState> list = new ArrayList<LocalState>();
        oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
        Enumeration<TreeNode> enumeration = e = mgr != null ? this.objectTreeRoot.breadthFirstEnumeration() : null;
        if (e != null) {
            while (e.hasMoreElements()) {
                JMutableTreeNode node = (JMutableTreeNode)e.nextElement();
                JTreeCellData data = (JTreeCellData)node.getUserObject();
                Object objId = data.getUserObject();
                if (objId == null) continue;
                LocalState state = (LocalState)this.revisionMappings.get(objId);
                if (state == null) {
                    state = mgr.getLastState(objId);
                }
                if (state == null) continue;
                list.add(state);
            }
        }
        LocalState[] states = new LocalState[list.size()];
        list.toArray(states);
        return states;
    }

    public LocalState[] getLocalStates() {
        Enumeration<TreeNode> e;
        ArrayList<LocalState> list = new ArrayList<LocalState>();
        oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
        Enumeration<TreeNode> enumeration = e = mgr != null ? this.objectTreeRoot.breadthFirstEnumeration() : null;
        if (e != null) {
            while (e.hasMoreElements()) {
                Object objId;
                JMutableTreeNode node = (JMutableTreeNode)e.nextElement();
                JTreeCellData data = (JTreeCellData)node.getUserObject();
                TriStateBoolean tsBool = data.getCheckBoxState();
                if (!tsBool.isTrue() || (objId = data.getUserObject()) == null) continue;
                LocalState state = (LocalState)this.revisionMappings.get(objId);
                if (state == null) {
                    state = mgr.getLastState(objId);
                }
                if (state == null) continue;
                list.add(state);
            }
        }
        LocalState[] states = new LocalState[list.size()];
        list.toArray(states);
        return states;
    }

    private void populateObjectTree(Object[] objs) {
        oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
        if (objs != null && mgr != null) {
            int i = 0;
            while (i < objs.length) {
                LocalState last = mgr.getLastState(objs[i]);
                if (last != null) {
                    JMutableTreeNode node = this.addObjectTreeNode(last.getStateURL());
                    JTreeCellData data = (JTreeCellData)node.getUserObject();
                    data.setUserObject(objs[i]);
                }
                ++i;
            }
        }
    }

    private JMutableTreeNode addObjectTreeNode(URL url) {
        if (url == null) {
            return null;
        }
        URL parentURL = URLFileSystem.getParent((URL)url);
        DefaultMutableTreeNode parentNode = null;
        if (parentURL == null) {
            parentNode = this.objectTreeRoot;
        } else {
            parentNode = (JMutableTreeNode)this.objectTreeNodes.get(parentURL);
            if (parentNode == null) {
                parentNode = this.addObjectTreeNode(parentURL);
            }
        }
        JTreeCellData treeCellData = new JTreeCellData(null, URLFileSystem.getFileName((URL)url), true, TriStateBoolean.FALSE);
        treeCellData.setToolTipText(URLFileSystem.getPlatformPathName((URL)url));
        JMutableTreeNode child = new JMutableTreeNode(treeCellData);
        parentNode.add((MutableTreeNode)child);
        this.objectTreeNodes.put(url, child);
        return child;
    }

    private Object getObjectTreeSelection() {
        TreePath path = this.objectTree.getSelectionPath();
        JMutableTreeNode node = (JMutableTreeNode)(path != null ? path.getLastPathComponent() : null);
        JTreeCellData data = node != null ? (JTreeCellData)node.getUserObject() : null;
        return data != null ? data.getUserObject() : null;
    }

    private void objectSelectionChanged(TreeSelectionEvent e) {
        int count;
        Object objId = this.getObjectTreeSelection();
        oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
        LocalState[] states = mgr != null && objId != null ? mgr.getLocalHistory(objId) : new LocalState[]{};
        this.historyList.setModel((HistoryModel)new DeletionsModel(states));
        this.historyList.sortTableByProperty(SharedProperties.getDateProperty(), false);
        Object last = objId != null ? this.revisionMappings.get(objId) : null;
        boolean foundLast = false;
        HistoryModel model = this.historyList.getModel();
        int n = count = model != null ? model.getSize() : 0;
        if (last != null) {
            int i = 0;
            while (i < count) {
                LocalHistoryEntry entry = (LocalHistoryEntry)model.getEntry(i);
                if (entry.getState().equals(last)) {
                    this.historyList.setSingleSelection((HistoryEntry)entry);
                    foundLast = true;
                    break;
                }
                ++i;
            }
        }
        if (!foundLast && count > 0) {
            this.historyList.setSingleSelection(model.getEntry(count - 1));
        }
    }

    private void historySelectionChanged(ListSelectionEvent e) {
        URL url;
        HistoryEntry[] entries = this.historyList.getSelection();
        LocalState state = null;
        if (entries != null && entries.length == 1 && entries[0] instanceof LocalHistoryEntry) {
            state = ((LocalHistoryEntry)entries[0]).getState();
            Object objId = this.getObjectTreeSelection();
            if (objId != null) {
                this.revisionMappings.put(objId, state);
            }
        }
        URL uRL = url = state != null ? state.getDataURL() : null;
        if (url != null) {
            try {
                InputStream inputStream = URLFileSystem.openInputStream((URL)url);
                URL lastURL = state.getStateURL();
                String suffix = URLFileSystem.getSuffix((URL)lastURL);
                Reader reader = StreamDecoder.getReader(suffix, url);
                TextBuffer buffer = TextBufferFactory.createTextBuffer();
                buffer.read(reader);
                this.previewEditPane.setDocument((Document)new BasicDocument(lastURL.getPath(), buffer));
                return;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        this.previewEditPane.setText("");
    }

    static void mav$objectSelectionChanged(RestoreDeletionsPanel restoreDeletionsPanel, TreeSelectionEvent treeSelectionEvent) {
        restoreDeletionsPanel.objectSelectionChanged(treeSelectionEvent);
    }

    static void mav$historySelectionChanged(RestoreDeletionsPanel restoreDeletionsPanel, ListSelectionEvent listSelectionEvent) {
        restoreDeletionsPanel.historySelectionChanged(listSelectionEvent);
    }

    final class 1
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            RestoreDeletionsPanel.mav$objectSelectionChanged(RestoreDeletionsPanel.this, e);
        }
    }

    final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            RestoreDeletionsPanel.mav$historySelectionChanged(RestoreDeletionsPanel.this, e);
        }
    }

    private static final class DeletionsModel
    extends DefaultHistoryModel {
        DeletionsModel(LocalState[] states) {
            this.addProperties(LocalHistoryProvider.PROPERTIES);
            if (states != null) {
                ArrayList<LocalHistoryEntry> list = new ArrayList<LocalHistoryEntry>();
                int i = 0;
                while (i < states.length) {
                    list.add(new LocalHistoryEntry(states[i]));
                    ++i;
                }
                HistoryEntry[] entries = new HistoryEntry[list.size()];
                list.toArray(entries);
                this.addEntries(entries);
            }
        }
    }
}

