/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common;

public class RepConversion {
    public static void printInHex(byte b) {
        System.out.print((char)RepConversion.nibbleToHex((byte)((b & 0xF0) >> 4)));
        System.out.print((char)RepConversion.nibbleToHex((byte)(b & 0xF)));
    }

    public static byte nibbleToHex(byte nibble) {
        return (byte)((nibble = (byte)(nibble & 0xF)) < 10 ? nibble + 48 : nibble - 10 + 65);
    }

    public static byte asciiHexToNibble(byte b) {
        byte value = b >= 97 && b <= 102 ? (byte)(b - 97 + 10) : (b >= 65 && b <= 70 ? (byte)(b - 65 + 10) : (b >= 48 && b <= 57 ? (byte)(b - 48) : b));
        return value;
    }

    public static void bArray2nibbles(byte[] array, byte[] nibbles) {
        int i = 0;
        while (i < array.length) {
            nibbles[i * 2] = RepConversion.nibbleToHex((byte)((array[i] & 0xF0) >> 4));
            nibbles[i * 2 + 1] = RepConversion.nibbleToHex((byte)(array[i] & 0xF));
            ++i;
        }
    }

    public static String bArray2String(byte[] array) {
        StringBuffer result = new StringBuffer(array.length * 2);
        int i = 0;
        while (i < array.length) {
            result.append((char)RepConversion.nibbleToHex((byte)((array[i] & 0xF0) >> 4)));
            result.append((char)RepConversion.nibbleToHex((byte)(array[i] & 0xF)));
            ++i;
        }
        return result.toString();
    }

    public static byte[] nibbles2bArray(byte[] nibbles) {
        byte[] array = new byte[nibbles.length / 2];
        int i = 0;
        while (i < array.length) {
            array[i] = (byte)(RepConversion.asciiHexToNibble(nibbles[i * 2]) << 4);
            int n = i;
            array[n] = (byte)(array[n] | RepConversion.asciiHexToNibble(nibbles[i * 2 + 1]));
            ++i;
        }
        return array;
    }

    public static void printInHex(long value) {
        byte[] hexValue = RepConversion.toHex(value);
        System.out.print(new String(hexValue));
    }

    public static void printInHex(int value) {
        byte[] hexValue = RepConversion.toHex(value);
        System.out.print(new String(hexValue));
    }

    public static void printInHex(short value) {
        byte[] hexValue = RepConversion.toHex(value);
        System.out.print(new String(hexValue));
    }

    public static byte[] toHex(long value) {
        int lsize = 16;
        byte[] hex = new byte[lsize];
        int i = lsize - 1;
        while (i >= 0) {
            hex[i] = RepConversion.nibbleToHex((byte)(value & (long)15));
            value >>= 4;
            --i;
        }
        return hex;
    }

    public static byte[] toHex(int value) {
        int lsize = 8;
        byte[] hex = new byte[lsize];
        int i = lsize - 1;
        while (i >= 0) {
            hex[i] = RepConversion.nibbleToHex((byte)(value & 0xF));
            value >>= 4;
            --i;
        }
        return hex;
    }

    public static byte[] toHex(short value) {
        int lsize = 4;
        byte[] hex = new byte[lsize];
        int i = lsize - 1;
        while (i >= 0) {
            hex[i] = RepConversion.nibbleToHex((byte)(value & 0xF));
            value = (short)(value >> 4);
            --i;
        }
        return hex;
    }

    static int convertCharToInt(char charVal) {
        switch (charVal) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return 48;
    }

    public static byte[] convertHexStringToByte(String refString) {
        byte[] byteArray = new byte[refString.length() / 2];
        int i = 0;
        while (i < refString.length()) {
            int intVal = RepConversion.convertCharToInt(refString.charAt(i));
            Integer newInt = new Integer(0xF0 & intVal << 4);
            byteArray[i / 2] = newInt.byteValue();
            intVal = RepConversion.convertCharToInt(refString.charAt(i + 1));
            newInt = new Integer(0xF & intVal);
            int n = i / 2;
            byteArray[n] = (byte)(byteArray[n] | newInt.byteValue());
            i += 2;
        }
        return byteArray;
    }
}

