/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import oracle.adf.share.common.ClassUtils;

public class LoaderUtil {
    private static ThreadLocal<HashMap<Object, ClassLoader>> tlMap = new ThreadLocal();
    private static NewJRLClassLoader myImpl = null;
    private static final NOPEnumeration NOP_ENUM = new NOPEnumeration(null);
    private static final NOPParent NOP_PARENT = new NOPParent(null);
    private static final String JRL_RESOURCE_NAME = "oracle/jdeveloper/java/util/JRLClassLoader.class";
    private static final boolean DISABLE_JRL = Boolean.getBoolean("oracle.adf.share.common.rc.util.disableJRL");
    private static final String MY_IMPL_CLASS_NAME = "oracle.adf.share.common.rc.util.impl.LoaderUtilImpl";
    private static final boolean JRL_AVAILABLE = ClassUtils.getClassLoader(LoaderUtil.class).getResource("oracle/jdeveloper/java/util/JRLClassLoader.class") != null;

    public static ClassLoader getLoader(URL[] urls, ClassLoader parent) {
        if (urls == null) {
            urls = new URL[]{};
        }
        if (parent == null) {
            parent = NOP_PARENT;
            if (urls.length == 1 && LoaderUtil.isTLCacheActive()) {
                return LoaderUtil.getAndCacheLoader(urls, parent);
            }
        }
        return LoaderUtil.justGetLoader(urls, parent);
    }

    private static ClassLoader justGetLoader(URL[] urls, ClassLoader parent) {
        if (myImpl == null && (DISABLE_JRL || !JRL_AVAILABLE)) {
            return new URLClassLoader(urls, parent);
        }
        return LoaderUtil.newJRLClassLoader(urls, parent);
    }

    public static ClassLoader getAndCacheLoader(URL[] urls, ClassLoader parent) {
        if (!LoaderUtil.isTLCacheActive()) {
            throw new IllegalStateException("Must activate the TLCache first");
        }
        String mapKey = LoaderUtil.getTLCacheKey(urls, parent);
        ClassLoader ldr = tlMap.get().get(mapKey);
        if (ldr == null) {
            ldr = LoaderUtil.justGetLoader(urls, parent);
            tlMap.get().put(mapKey, ldr);
        }
        return ldr;
    }

    private static String getTLCacheKey(URL[] urls, ClassLoader parent) {
        StringBuilder mapKey = new StringBuilder();
        if (urls != null) {
            int i = 0;
            while (i < urls.length) {
                String proto;
                String k = urls[i].toString();
                int x = k.indexOf(58);
                if (x != -1 && !(proto = k.substring(0, x).toLowerCase()).equals("jar") && !proto.equals("zip") && LoaderUtil.isArchiveExtension(k)) {
                    k = "jar:" + k + "!/";
                }
                mapKey.append("." + k.hashCode());
                ++i;
            }
        }
        if (parent != null) {
            mapKey.append("." + parent.toString().hashCode());
        }
        return mapKey.toString();
    }

    private static boolean isArchiveExtension(String urlStr) {
        int x = urlStr.lastIndexOf("!/");
        if (x != -1) {
            urlStr = urlStr.substring(0, x);
        }
        if ((x = urlStr.lastIndexOf(47)) == -1 || x + 1 == urlStr.length()) {
            return false;
        }
        String fn = urlStr.substring(x + 1);
        if ((x = fn.lastIndexOf(46)) == -1 || x + 1 == fn.length()) {
            return false;
        }
        String ext = fn.substring(x + 1).toLowerCase();
        return ext.equals("jar") || ext.equals("zip");
    }

    public static boolean activateTLCache() {
        if (LoaderUtil.isTLCacheActive()) {
            return false;
        }
        tlMap.set(new HashMap(4));
        return true;
    }

    public static void clearTLCache() {
        tlMap.remove();
    }

    public static boolean isTLCacheActive() {
        return tlMap.get() != null;
    }

    public static ClassLoader getNOPParent() {
        return NOP_PARENT;
    }

    private static ClassLoader newJRLClassLoader(URL[] urls, ClassLoader parent) {
        if (myImpl == null) {
            try {
                myImpl = (NewJRLClassLoader)ClassUtils.forName(MY_IMPL_CLASS_NAME, LoaderUtil.class).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return myImpl.newJRLClassLoader(urls, parent);
    }

    static NOPEnumeration ra$NOP_ENUM() {
        return NOP_ENUM;
    }

    public interface NewJRLClassLoader {
        public ClassLoader newJRLClassLoader(URL[] var1, ClassLoader var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NOPParent
    extends ClassLoader {
        @Override
        protected URL findResource(String name) {
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return LoaderUtil.ra$NOP_ENUM();
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }

        @Override
        public URL getResource(String name) {
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return LoaderUtil.ra$NOP_ENUM();
        }

        private NOPParent() {
        }

        NOPParent(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NOPEnumeration
    implements Enumeration {
        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }

        private NOPEnumeration() {
        }

        NOPEnumeration(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

