/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import javax.xml.parsers.ParserConfigurationException;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.impl.MetadataRegistryImpl;
import org.xml.sax.SAXException;

public class MetadataRegistryBigImpl
extends MetadataRegistryImpl {
    private Class clazz;
    private Method openInputStream;
    private Method openOutputStream;
    private Method exists;
    private Method list;

    public MetadataRegistryBigImpl() {
        this.$init$();
        this.init();
    }

    protected InputStream openStream(URL url) throws IOException {
        try {
            url = new URL(URLDecoder.decode(url.toString(), "UTF8"));
            InputStream inputStream = (InputStream)this.invokeIO(this.openInputStream, url);
            return inputStream;
        }
        catch (IOException e) {
            this.logger.fine(MessageFormat.format("{0}", url));
            throw e;
        }
    }

    protected OutputStream getOutputStream(MetadataRegistryImpl.Context ctx) throws IOException {
        try {
            URL url = new URL(URLDecoder.decode(ctx.url.toString(), "UTF8"));
            OutputStream outputStream = (OutputStream)this.invokeIO(this.openOutputStream, url);
            return outputStream;
        }
        catch (IOException e) {
            this.logger.fine(MessageFormat.format("{0}", ctx.url));
            throw e;
        }
    }

    protected void getDocumentForWriting(MetadataRegistryImpl.Context ctx) throws IOException, SAXException, ParserConfigurationException {
        URL url = new URL(URLDecoder.decode(ctx.url.toString(), "UTF8"));
        boolean adfmXmlExists = (Boolean)this.invoke(this.exists, url);
        if (adfmXmlExists) {
            ctx.doc = this.getDomDocument(url);
        } else {
            ctx.dirty = true;
            ctx.doc = this.newDomDocument(url);
        }
    }

    public URL[] listFiles(URL url) {
        try {
            url = new URL(URLDecoder.decode(url.toString(), "UTF8"));
        }
        catch (Exception e) {
            this.logger.info(e.toString() + ": " + url);
        }
        return (URL[])this.invoke(this.list, url);
    }

    private void init() {
        try {
            this.clazz = ClassUtils.forName("oracle.ide.net.URLFileSystem");
            Class[] p1 = new Class[]{URL.class};
            this.openInputStream = this.clazz.getMethod("openInputStream", p1);
            this.openOutputStream = this.clazz.getMethod("openOutputStream", p1);
            this.exists = this.clazz.getMethod("exists", p1);
            this.list = this.clazz.getMethod("list", p1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object invokeIO(Method m, URL url) throws IOException {
        Object[] params = new Object[]{url};
        try {
            Object object = m.invoke(null, params);
            return object;
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(e);
        }
    }

    private Object invoke(Method m, URL url) {
        Object[] params = new Object[]{url};
        try {
            Object object = m.invoke(null, params);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void $init$() {
        this.clazz = null;
        this.openInputStream = null;
        this.openOutputStream = null;
        this.exists = null;
        this.list = null;
    }
}

