/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.MetadataRegistry;
import oracle.adf.share.common.rc.util.impl.Res;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataRegistryImpl
extends MetadataRegistry {
    private URL _baseURL;
    private Integer _mode;
    private Boolean _whitespace;
    protected Logger logger;
    private static EmptyNodeList EMPTY_NODE_LIST = new EmptyNodeList(null);
    private static final int DCX = 0;
    private static final int CPX = 2;
    private static final int JPX = 4;
    private static final int XCFG = 6;
    private static final String[] elementData = new String[]{".dcx", "DataControlRegistry", ".cpx", "DataBindingRegistry", ".jpx", "BusinessComponentProjectRegistry", ".xcfg", "BusinessComponentServiceRegistry"};
    private static final Map<String, String> defaultElementXref = MetadataRegistryImpl.createElementXref(elementData);
    private static DocumentBuilderFactory builderFactory = null;
    static final boolean DEBUG = MetadataRegistryImpl.initDebugSetting();

    private void $init$() {
        this._baseURL = null;
        this._mode = null;
        this._whitespace = null;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public MetadataRegistryImpl() {
        this.$init$();
    }

    @Override
    public void visitRegistryPaths(ClassLoader loader, String regNS, String regName, MetadataRegistry.PathVisitor visitor) throws IOException, SAXException, ParserConfigurationException, MalformedURLException {
        Enumeration<URL> adfmxmls = loader.getResources("META-INF/adfm.xml");
        if (!adfmxmls.hasMoreElements()) {
            return;
        }
        HashSet<String> visited = new HashSet<String>();
        while (adfmxmls.hasMoreElements()) {
            URL adfmXmlUrl = adfmxmls.nextElement();
            this.logger.fine(MessageFormat.format("Visiting {0}", adfmXmlUrl));
            String adfmStr = adfmXmlUrl.toString();
            if (visited.contains(adfmStr)) continue;
            visited.add(adfmStr);
            String adfmXmlBase = adfmStr.substring(0, adfmStr.length() - MetadataRegistry.ADFMXML_SIG_LEN);
            Iterator<String> paths = this.getRegistryPaths(adfmXmlUrl, regNS, regName);
            while (paths.hasNext()) {
                String path = paths.next();
                this.logger.finer(MessageFormat.format("Sub-visiting ", path));
                visitor.visit(this, new URL(adfmXmlBase + path), path);
            }
        }
    }

    @Override
    public Iterator<String> getAttributeIterator(URL xmlUrl, String elemNS, String elemName, String attrName) throws IOException, SAXException, ParserConfigurationException {
        return new IterateNodeListAttributes(this.getDomDocument(xmlUrl).getElementsByTagNameNS(elemNS, elemName), attrName);
    }

    @Override
    public Iterator<String> getRegistryPaths(URL adfmXmlUrl, String registryNS, String registryName) throws IOException, SAXException, ParserConfigurationException {
        if (registryNS == null) {
            registryNS = "http://xmlns.oracle.com/adfm/metainf";
        }
        return new IterateNodeListAttributes(this.getDomDocument(adfmXmlUrl).getElementsByTagNameNS(registryNS, registryName), "path");
    }

    @Override
    public List<Map<String, Object>> getSubtreeList(URL xmlUrl, String elemNS, String elemName, String nvpChildName) throws ParserConfigurationException, SAXException, IOException {
        Document doc = this.getDomDocument(xmlUrl);
        if (elemNS == null || elemNS.length() == 0) {
            elemNS = "http://xmlns.oracle.com/bc4j";
        }
        NodeList nodeList = doc.getElementsByTagNameNS(elemNS, elemName);
        int len = nodeList.getLength();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(len);
        int i = 0;
        while (i < len) {
            HashMap map = new HashMap(6);
            HashMap dtMap = new HashMap(2);
            map.put(nvpChildName, dtMap);
            list.add(map);
            Node node = nodeList.item(i);
            this.fillNodeAttrMap(map, node);
            NodeList nvpList = this.getChildNodeList(node, elemNS, nvpChildName);
            this.fillNvpNodeAttrMap(dtMap, nvpList, "Name", "Value");
            ++i;
        }
        return list;
    }

    private NodeList getChildNodeList(Node node, String elemNS, String nvpChildName) {
        NodeList childList = node.getChildNodes();
        int len = childList.getLength();
        int i = 0;
        while (i < len) {
            Node item = childList.item(i);
            if (nvpChildName.equals(item.getLocalName()) && ("*".equals(elemNS) || elemNS.equals(item.getNamespaceURI()))) {
                return item.getChildNodes();
            }
            ++i;
        }
        return EMPTY_NODE_LIST;
    }

    private void fillNodeAttrMap(Map map, Node node) {
        NamedNodeMap nodeMap = node.getAttributes();
        int alen = nodeMap.getLength();
        int a = 0;
        while (a < alen) {
            Node anode = nodeMap.item(a);
            String name = anode.getNodeName();
            String valu = anode.getNodeValue();
            if (name != null && valu != null) {
                map.put(name, valu);
            }
            ++a;
        }
    }

    private void fillNvpNodeAttrMap(Map map, NodeList list, String nameName, String valueName) {
        int len = list.getLength();
        int i = 0;
        while (i < len) {
            Node node = list.item(i);
            NamedNodeMap nodeMap = node.getAttributes();
            String name = null;
            String valu = null;
            int alen = nodeMap.getLength();
            int a = 0;
            while (a < alen) {
                Node anode = nodeMap.item(a);
                String aname = anode.getNodeName();
                String avalu = anode.getNodeValue();
                if (name == null && aname.equalsIgnoreCase(nameName)) {
                    name = avalu;
                } else if (valu == null && aname.equalsIgnoreCase(valueName)) {
                    valu = avalu;
                }
                ++a;
            }
            if (name != null && valu != null) {
                map.put(name, valu);
            }
            ++i;
        }
    }

    private static final Map<String, String> createElementXref(String[] data) {
        HashMap<String, String> map = new HashMap<String, String>(data.length / 2);
        int i = 0;
        while (i < data.length) {
            map.put(data[i], data[i + 1]);
            i += 2;
        }
        return map;
    }

    @Override
    public boolean updateElementsInMetadataRegistry(Collection<String> relativePaths, Map<String, String> elementXref, URL adfmXmlUrl) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        return this.updateElementsInMetadataRegistryEx(relativePaths, null, elementXref, adfmXmlUrl, null);
    }

    @Override
    public boolean updateElementsInMetadataRegistryEx(Collection<String> relativePaths, Collection<String> removalPaths, Map<String, String> elementXref, URL adfmXmlUrl, int[] remaining) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Context ctx = new Context(adfmXmlUrl);
        this.getDocumentForWriting(ctx);
        if (removalPaths != null && removalPaths.size() > 0) {
            HashSet<String> removes = new HashSet<String>(removalPaths);
            NodeList list = ctx.doc.getDocumentElement() != null ? ctx.doc.getDocumentElement().getElementsByTagNameNS("*", "*") : ctx.doc.getElementsByTagNameNS("*", "*");
            int i = 0;
            while (i < list.getLength() && removes.size() > 0) {
                boolean removed;
                String elemPath = ((Element)list.item(i)).getAttributeNS(null, "path");
                if (elemPath != null && elemPath.length() > 0 && (removed = removes.remove(elemPath))) {
                    list.item(i).getParentNode().removeChild(list.item(i));
                    ctx.dirty = true;
                    this.logger.fine(elemPath + " removed.");
                }
                ++i;
            }
        }
        if (elementXref == null) {
            elementXref = defaultElementXref;
        }
        for (String relPath : relativePaths) {
            String ext;
            if (!this.updateRegistryElement(relPath, null, elementXref.get(ext = relPath.substring(relPath.lastIndexOf(46))), ctx.doc)) continue;
            ctx.dirty = true;
        }
        if (ctx.dirty) {
            this.saveDomDocument(ctx);
        }
        if (remaining != null && remaining.length > 0) {
            remaining[0] = ctx.doc.getDocumentElement().getElementsByTagNameNS("*", "*").getLength();
        }
        return ctx.dirty;
    }

    @Override
    public boolean updateRegistryElement(String relativePath, String elementNS, String elementName, Document doc) {
        boolean dirty = false;
        if (elementNS == null) {
            elementNS = "http://xmlns.oracle.com/adfm/metainf";
        }
        if (elementName == null) {
            throw new IllegalArgumentException(relativePath);
        }
        Element rootElement = doc.getDocumentElement();
        NodeList list = doc.getElementsByTagNameNS(elementNS, elementName);
        if (list == null || list.getLength() == 0) {
            if (rootElement == null) {
                rootElement = doc.createElementNS("http://xmlns.oracle.com/adfm/metainf", "MetadataDirectory");
                rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://xmlns.oracle.com/adfm/metainf");
                rootElement.setAttributeNS(null, "version", Res.get("DOC_VERSION"));
                doc.setXmlVersion(Res.get("XML_VERSION"));
                doc.appendChild(rootElement);
            }
            Element registry = doc.createElementNS(elementNS, elementName);
            rootElement.appendChild(registry);
            registry.setAttributeNS(null, "path", relativePath);
            dirty = true;
        } else {
            boolean found = false;
            int i = 0;
            while (i < list.getLength()) {
                if (relativePath.equals(((Element)list.item(i)).getAttributeNS(null, "path"))) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                Element registry = doc.createElementNS(elementNS, elementName);
                registry.setAttributeNS(elementNS, "path", relativePath);
                rootElement.appendChild(registry);
                dirty = true;
            }
        }
        this.logger.fine(MessageFormat.format("Document {0}dirty after update of {1} with {2}", !dirty ? "not " : "", elementName, relativePath));
        return dirty;
    }

    private static DocumentBuilderFactory getBuilderFactory() {
        if (builderFactory == null) {
            builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setIgnoringComments(true);
            builderFactory.setIgnoringElementContentWhitespace(true);
        }
        return builderFactory;
    }

    @Override
    public URL setBaseURL(URL newBaseURL) {
        URL ret = this._baseURL;
        this._baseURL = newBaseURL;
        return ret;
    }

    @Override
    public void setValidationMode(Integer mode) {
        this._mode = mode;
    }

    @Override
    public void setPreserveWhitespace(Boolean preserve) {
        this._whitespace = preserve;
    }

    protected InputStream openStream(URL url) throws IOException {
        try {
            InputStream inputStream = url.openStream();
            return inputStream;
        }
        catch (IOException e) {
            this.logger.fine(MessageFormat.format("{0}", url));
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Document getDomDocument(URL url) throws ParserConfigurationException, SAXException, IOException {
        InputStream strm = null;
        try {
            strm = this.openStream(url);
            if (!(strm instanceof BufferedInputStream) && !(strm instanceof ByteArrayInputStream)) {
                strm = new BufferedInputStream(strm);
            }
            DOMParser parser = new DOMParser();
            if (this._baseURL != null) {
                parser.setBaseURL(this._baseURL);
            } else {
                URL baseURL = this.getCallersBaseURL();
                if (baseURL != null) {
                    parser.setBaseURL(baseURL);
                }
            }
            if (this._mode != null) {
                parser.setValidationMode(this._mode.intValue());
            }
            if (DEBUG) {
                parser.setDebugMode(true);
                parser.showWarnings(true);
            }
            if (this._whitespace != null) {
                parser.setPreserveWhitespace(this._whitespace.booleanValue());
            }
            parser.parse(strm);
            XMLDocument xMLDocument = parser.getDocument();
            return xMLDocument;
        }
        catch (IOException e) {
            this.logger.fine(MessageFormat.format("{0}", url));
            throw e;
        }
        finally {
            if (strm != null) {
                try {
                    strm.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private URL getCallersBaseURL() {
        try {
            String myPackage = this.getClass().getName();
            myPackage = myPackage.substring(0, myPackage.lastIndexOf(46));
            String callersName = null;
            StackTraceElement[] elems = new Throwable().getStackTrace();
            int i = 0;
            while (i < elems.length) {
                String className = elems[i].getClassName();
                if (className != null && !className.startsWith(myPackage)) {
                    callersName = elems[i].getClassName();
                    URL uRL = ClassUtils.forName(callersName).getResource("");
                    return uRL;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Exception caught", e);
        }
        return null;
    }

    protected Document newDomDocument(URL url) throws ParserConfigurationException {
        DocumentBuilder builder = MetadataRegistryImpl.getBuilderFactory().newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.setDocumentURI(url.toString());
        return doc;
    }

    @Override
    public void saveDocumentTo(Document doc, URL saveTo) throws TransformerConfigurationException, TransformerException, IOException {
        Context ctx = new Context(saveTo);
        ctx.doc = doc;
        this.saveDomDocument(ctx);
    }

    protected void saveDomDocument(Context ctx) throws TransformerConfigurationException, TransformerException, IOException {
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        Transformer xform = xformFactory.newTransformer();
        xform.setOutputProperty("indent", "yes");
        xform.setOutputProperty("omit-xml-declaration", "no");
        DOMSource input = new DOMSource(ctx.doc);
        OutputStream os = this.getOutputStream(ctx);
        if (!(os instanceof BufferedOutputStream) && !(os instanceof ByteArrayOutputStream)) {
            os = new BufferedOutputStream(os);
        }
        try {
            StreamResult output = new StreamResult(os);
            xform.transform(input, output);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected OutputStream getOutputStream(Context ctx) throws IOException {
        try {
            if ("file".equalsIgnoreCase(ctx.url.getProtocol())) {
                File f = new File(ctx.url.getPath());
                f.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(f);
                return fileOutputStream;
            }
            OutputStream outputStream = ctx.url.openConnection().getOutputStream();
            return outputStream;
        }
        catch (IOException e) {
            this.logger.fine(MessageFormat.format("{0}", ctx.url));
            throw e;
        }
    }

    protected void getDocumentForWriting(Context ctx) throws IOException, SAXException, ParserConfigurationException {
        try {
            ctx.doc = this.getDomDocument(ctx.url);
        }
        catch (IOException e) {
            ctx.dirty = true;
            ctx.doc = this.newDomDocument(ctx.url);
        }
    }

    @Override
    public URL[] listFiles(URL url) {
        if (url == null) {
            return null;
        }
        try {
            String urlStr = url.toString();
            if (!urlStr.endsWith("/")) {
                urlStr = urlStr + "/";
            }
            if (urlStr.startsWith("file:")) {
                File file = new File(url.toURI());
                String[] fileNames = file.list();
                if (fileNames == null) {
                    URL[] uRLArray = null;
                    return uRLArray;
                }
                URL[] urls = new URL[fileNames.length];
                int i = 0;
                while (i < urls.length) {
                    urls[i] = new URL(urlStr + fileNames[i]);
                    ++i;
                }
                URL[] uRLArray = urls;
                return uRLArray;
            }
            if (urlStr.startsWith("jar:")) {
                int sep = urlStr.lastIndexOf("!/");
                if (sep < 0) {
                    this.logger.info(MessageFormat.format("Invalid URL: {0}", urlStr));
                    URL[] uRLArray = null;
                    return uRLArray;
                }
                String jarName = urlStr.substring(4, sep);
                String dirName = urlStr.substring(sep + 2);
                int dirNameLen = dirName.length();
                JarFile jar = new JarFile(new File(new URL(jarName).toURI()));
                try {
                    LinkedList<URL> urls = new LinkedList<URL>();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String ename = entry.getName();
                        if (!ename.startsWith(dirName) || ename.indexOf(47, dirNameLen) != -1) continue;
                        urls.add(new URL(urlStr + ename.substring(dirNameLen)));
                    }
                    URL[] uRLArray = urls.toArray(new URL[0]);
                    return uRLArray;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (Exception exception) {}
                        jar = null;
                    }
                }
            }
            this.logger.info(MessageFormat.format("Unable to handle URL: {0}", urlStr));
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Exception caught", e);
        }
        return null;
    }

    private static final boolean initDebugSetting() {
        try {
            boolean bl = Boolean.getBoolean("adflibrc.debug");
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            boolean bl = false;
            return bl;
        }
    }

    private static class EmptyNodeList
    implements NodeList {
        public int getLength() {
            return 0;
        }

        public Node item(int index) {
            return null;
        }

        private EmptyNodeList() {
        }

        EmptyNodeList(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IterateNodeListAttributes
    implements Iterator<String> {
        private final NodeList list;
        private final String attrName;
        private final int listLen;
        private int i;
        private String next;

        private void $init$() {
            this.i = 0;
            this.next = "";
        }

        public IterateNodeListAttributes(NodeList list, String attrName) {
            this.$init$();
            this.list = list;
            this.listLen = list != null ? list.getLength() : 0;
            this.attrName = attrName;
            this.setNext();
        }

        /*
         * Unable to fully structure code
         */
        private void setNext() {
            block2: {
                if (this.i != this.listLen) ** GOTO lbl7
                this.next = null;
                break block2;
lbl-1000:
                // 1 sources

                {
                    this.next = ((Element)this.list.item(this.i)).getAttributeNS(null, this.attrName);
                    ++this.i;
                    if (this.next.length() != 0) break;
lbl7:
                    // 2 sources

                    ** while (this.i < this.listLen)
                }
lbl8:
                // 2 sources

                if (this.next.length() == 0) {
                    this.next = null;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            String ret = this.next;
            this.setNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class Context {
        URL url;
        Document doc;
        boolean dirty;

        public Context(URL adfmXmlUrl) {
            this.$init$();
            this.url = adfmXmlUrl;
        }

        private void $init$() {
            this.doc = null;
            this.dirty = false;
        }
    }
}

