/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.connection;

import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.Referenceable;
import oracle.adf.share.connection.ConnectionException;
import oracle.adf.share.connection.ConnectionType;
import oracle.adf.share.connection.ConnectionTypeRegistry;

public final class ConnectionTypeManager {
    private static ConnectionTypeManager sManager = null;
    private static final Object sLock = new Object();
    private Map<ClassLoader, ConnectionTypeRegistry> mApplicationRegistryMap;
    private Object mLock;

    private void $init$() {
        this.mApplicationRegistryMap = new WeakHashMap<ClassLoader, ConnectionTypeRegistry>(10);
        this.mLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionTypeManager getInstance() {
        Object object = sLock;
        synchronized (object) {
            if (sManager == null) {
                sManager = new ConnectionTypeManager();
            }
        }
        return sManager;
    }

    private ConnectionTypeManager() {
        this.$init$();
    }

    public void register(ConnectionType type) throws ConnectionException {
        ConnectionTypeRegistry registry = this.getApplicationRegistry();
        registry.register(type);
    }

    public ConnectionType getConnectionType(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        ConnectionTypeRegistry registry = this.getApplicationRegistry();
        return registry.getConnectionType(id);
    }

    public ConnectionType lookup(Referenceable connection) {
        if (connection == null) {
            return null;
        }
        ConnectionTypeRegistry registry = this.getApplicationRegistry();
        return registry.lookup(connection);
    }

    public ConnectionType lookup(Class connectionCls) {
        if (connectionCls == null) {
            return null;
        }
        ConnectionTypeRegistry registry = this.getApplicationRegistry();
        return registry.lookup(connectionCls);
    }

    public ConnectionType lookup(String connectionClassName) {
        if (connectionClassName == null) {
            return null;
        }
        ConnectionTypeRegistry registry = this.getApplicationRegistry();
        return registry.lookup(connectionClassName);
    }

    public Map getConnectionTypes() {
        ConnectionTypeRegistry registry = this.getApplicationRegistry();
        return registry.getConnectionTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionTypeRegistry getApplicationRegistry() {
        ClassLoader appLoader = Thread.currentThread().getContextClassLoader();
        ConnectionTypeRegistry registry = null;
        Object object = this.mLock;
        synchronized (object) {
            registry = this.mApplicationRegistryMap.get(appLoader);
            if (registry == null) {
                registry = new ConnectionTypeRegistry(appLoader);
                this.mApplicationRegistryMap.put(appLoader, registry);
            }
        }
        return registry;
    }
}

