/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.connection;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Referenceable;
import oracle.adf.share.connection.ConnectionException;
import oracle.adf.share.connection.ConnectionType;
import oracle.adf.share.connection.ConnectionTypeLoader;
import oracle.adf.share.connection.ConnectionTypeLoaderFactory;
import oracle.adf.share.connection.DuplicateConnectionTypeException;

public final class ConnectionTypeRegistry {
    private static final String CONNECTION_LOGGER = "oracle.adf.share.connection";
    private static final String SOURCE_CLASS = ConnectionTypeRegistry.class.getName();
    private static final String REGISTER = "register()";
    private static final String LOOKUP = "lookup()";
    private Map<String, ConnectionType> mTypes;
    private Logger mLogger;

    private void $init$() {
        this.mTypes = new HashMap<String, ConnectionType>(10);
        this.mLogger = null;
    }

    public ConnectionTypeRegistry(ClassLoader sourceLoader) {
        this.$init$();
        ConnectionTypeLoader extensionLoader = ConnectionTypeLoaderFactory.getLoader();
        extensionLoader.loadConnectionTypes(this, sourceLoader);
    }

    public void register(ConnectionType type) throws ConnectionException {
        ConnectionType existing;
        String id;
        if (type == null) {
            ConnectionException ex = new ConnectionException("Required parameter [type] is null");
            this.getLogger().throwing(SOURCE_CLASS, REGISTER, ex);
        }
        if ((id = type.getId()) == null || id.length() == 0) {
            ConnectionException ex = new ConnectionException("Invalid ConnectionType: id is null");
            this.getLogger().throwing(SOURCE_CLASS, REGISTER, ex);
        }
        if ((existing = this.getConnectionType(id)) != null) {
            DuplicateConnectionTypeException de = new DuplicateConnectionTypeException("Connection type: " + id + " already registered.");
            this.getLogger().throwing(SOURCE_CLASS, REGISTER, de);
        }
        this.mTypes.put(id, type);
        this.getLogger().logp(Level.CONFIG, SOURCE_CLASS, REGISTER, "Registered connection type: " + id);
    }

    public ConnectionType getConnectionType(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        return this.mTypes.get(id);
    }

    public ConnectionType lookup(Referenceable connection) {
        if (connection == null) {
            return null;
        }
        for (ConnectionType type : this.mTypes.values()) {
            if (!type.isInstanceOf(connection)) continue;
            if (this.getLogger().isLoggable(Level.FINEST)) {
                StringBuilder buf = new StringBuilder(100);
                buf.append("Found ConnectionType [");
                buf.append(type.getId());
                buf.append("] for connection class [");
                buf.append(connection.getClass().getName());
                buf.append("]");
                this.getLogger().logp(Level.FINEST, SOURCE_CLASS, LOOKUP, buf.toString());
            }
            return type;
        }
        return null;
    }

    public ConnectionType lookup(Class connectionCls) {
        if (connectionCls == null) {
            return null;
        }
        for (ConnectionType type : this.mTypes.values()) {
            if (!type.isInstanceOf(connectionCls)) continue;
            if (this.getLogger().isLoggable(Level.FINEST)) {
                StringBuilder buf = new StringBuilder(100);
                buf.append("Found ConnectionType [");
                buf.append(type.getId());
                buf.append("] for connection class [");
                buf.append(connectionCls.getName());
                buf.append("]");
                this.getLogger().logp(Level.FINEST, SOURCE_CLASS, LOOKUP, buf.toString());
            }
            return type;
        }
        return null;
    }

    public ConnectionType lookup(String connectionClassName) {
        if (connectionClassName == null) {
            return null;
        }
        for (ConnectionType type : this.mTypes.values()) {
            if (!type.isInstanceOf(connectionClassName)) continue;
            if (this.getLogger().isLoggable(Level.FINEST)) {
                StringBuilder buf = new StringBuilder(100);
                buf.append("Found ConnectionType [");
                buf.append(type.getId());
                buf.append("] for connection class name [");
                buf.append(connectionClassName);
                buf.append("]");
                this.getLogger().logp(Level.FINEST, SOURCE_CLASS, LOOKUP, buf.toString());
            }
            return type;
        }
        return null;
    }

    public Map getConnectionTypes() {
        return new HashMap<String, ConnectionType>(this.mTypes);
    }

    private Logger getLogger() {
        if (this.mLogger == null) {
            this.mLogger = Logger.getLogger(CONNECTION_LOGGER);
        }
        return this.mLogger;
    }
}

