/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.adf.share.logging.ADFLogger;

public final class AdfJndiHelper {
    private static ADFLogger logger = null;
    public static final String READ_ONLY_FILESYSTEM_BACKING_STORE = "oracle.adf.share.jndi.FileSystemBackingStore.readonly";

    private static ADFLogger getLogger() {
        if (logger == null) {
            logger = ADFLogger.createADFLogger("oracle.adf.share.jndi");
        }
        return logger;
    }

    public static final Context createReadOnlyFileSystemContext(String connectionsFile) {
        InitialContext ctx = null;
        Hashtable<String, String> mContextEnv = new Hashtable<String, String>(3);
        mContextEnv.put("java.naming.factory.initial", "oracle.adf.share.jndi.InitialContextFactoryImpl");
        mContextEnv.put("java.naming.provider.url", connectionsFile);
        mContextEnv.put(READ_ONLY_FILESYSTEM_BACKING_STORE, "true");
        try {
            ctx = new InitialContext(mContextEnv);
        }
        catch (NamingException e) {
            AdfJndiHelper.getLogger().severe("Could not create context", e);
        }
        return ctx;
    }
}

