/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.LogRecord;
import oracle.adf.share.logging.internal.DumpLogThread;
import oracle.adf.share.logging.internal.LogLine;
import oracle.adf.share.logging.internal.LoggingUtils;

public class BaseFileHandler
extends FileHandler {
    LinkedList mDumpBuffer;
    private int mBufSize;
    private static final int MAXSENSORS_PER_LINE = 12;
    private LinkedHashMap mLogRecordBuffer;
    private Thread mThread;

    private void $init$() {
        this.mDumpBuffer = new LinkedList();
        this.mBufSize = 100;
        this.mLogRecordBuffer = new LinkedHashMap(this.mBufSize, 0.75f, true);
        this.mThread = null;
    }

    protected BaseFileHandler(String pattern, int limit, int count, boolean append, int bufSize) throws IOException, SecurityException {
        super(pattern, limit, count, append);
        this.$init$();
        this.mBufSize = bufSize;
        this.startDumpThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        LinkedList recordList = null;
        String ecid = LoggingUtils.getECID();
        if (ecid == null) {
            return;
        }
        ecid = BaseFileHandler.removeSeqNum(ecid);
        LinkedHashMap linkedHashMap = this.mLogRecordBuffer;
        synchronized (linkedHashMap) {
            recordList = (LinkedList)this.mLogRecordBuffer.remove(ecid);
            if (recordList != null) {
                this.printList(ecid, recordList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addRecordToList(LogRecord record, String ecid) {
        LinkedList<LogRecord> recordList = null;
        if (ecid == null) {
            ecid = LoggingUtils.getECID();
        }
        if (ecid == null) {
            return ecid;
        }
        ecid = BaseFileHandler.removeSeqNum(ecid);
        LinkedHashMap linkedHashMap = this.mLogRecordBuffer;
        synchronized (linkedHashMap) {
            recordList = (LinkedList<LogRecord>)this.mLogRecordBuffer.get(ecid);
            if (recordList == null) {
                recordList = new LinkedList<LogRecord>();
                this.mLogRecordBuffer.put(ecid, recordList);
            }
            recordList.add(record);
        }
        return ecid;
    }

    protected boolean isBufferFull() {
        return this.mLogRecordBuffer.size() > this.mBufSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRecordListTooLong(String ecid) {
        LinkedList recordList = null;
        LinkedHashMap linkedHashMap = this.mLogRecordBuffer;
        synchronized (linkedHashMap) {
            recordList = (LinkedList)this.mLogRecordBuffer.get(ecid);
            boolean bl = recordList.size() >= 12;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLeastAccessedECID() {
        String ecid = null;
        Iterator iter = null;
        LinkedHashMap linkedHashMap = this.mLogRecordBuffer;
        synchronized (linkedHashMap) {
            iter = this.mLogRecordBuffer.keySet().iterator();
            if (iter.hasNext()) {
                ecid = (String)iter.next();
            }
        }
        return ecid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedList removeList(String ecid) {
        LinkedHashMap linkedHashMap = this.mLogRecordBuffer;
        synchronized (linkedHashMap) {
            LinkedList linkedList = (LinkedList)this.mLogRecordBuffer.remove(ecid);
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printList(String ecid, LinkedList recordList) {
        if (recordList == null || recordList.size() == 0) {
            return;
        }
        LogLine line = new LogLine(ecid, recordList);
        LinkedList linkedList = this.mDumpBuffer;
        synchronized (linkedList) {
            this.mDumpBuffer.add(line);
            this.mDumpBuffer.notify();
        }
    }

    protected void reportError(String msg, Exception ex, int code) {
        super.reportError(msg, ex, code);
    }

    synchronized void publish(LogLine line) {
        super.publish(line);
        super.flush();
    }

    private void startDumpThread() {
        if (this.mThread == null) {
            DumpLogThread dt = new DumpLogThread(this);
            this.mThread = new Thread((Runnable)dt, DumpLogThread.class.getName());
            this.mThread.setPriority(1);
            this.mThread.setDaemon(true);
            this.mThread.start();
        }
    }

    static void createLogDir(String name) throws Exception {
        File bsDir = new File(name);
        try {
            if (bsDir.exists()) {
                if (!bsDir.isDirectory()) {
                    ResourceBundle rb = ResourceBundle.getBundle("oracle.adf.share.logging.internal.resources.LogHandlerMessageBundle");
                    MessageFormat formatter = new MessageFormat("");
                    formatter.applyPattern(rb.getString("NOT_DIRECTORY"));
                    throw new Exception(formatter.format(name));
                }
            } else if (!bsDir.mkdirs()) {
                ResourceBundle rb = ResourceBundle.getBundle("oracle.adf.share.logging.internal.resources.LogHandlerMessageBundle");
                MessageFormat formatter = new MessageFormat("");
                formatter.applyPattern(rb.getString("CANNOT_CREATE_DIRECTORY"));
                throw new Exception(formatter.format(name));
            }
            if (!bsDir.canWrite()) {
                ResourceBundle rb = ResourceBundle.getBundle("oracle.adf.share.logging.internal.resources.LogHandlerMessageBundle");
                MessageFormat formatter = new MessageFormat("");
                formatter.applyPattern(rb.getString("CANNOT_WRITE_DIRECTORY"));
                throw new Exception(formatter.format(name));
            }
        }
        catch (SecurityException e) {
            ResourceBundle rb = ResourceBundle.getBundle("oracle.adf.share.logging.internal.resources.LogHandlerMessageBundle");
            MessageFormat formatter = new MessageFormat("");
            formatter.applyPattern(rb.getString("DIR_ACCESS_DENIED"));
            throw new Exception(formatter.format(name));
        }
    }

    private static String removeSeqNum(String ecid) {
        int idx = ecid.lastIndexOf(44);
        if (idx != -1) {
            ecid = ecid.substring(0, idx);
        }
        return ecid;
    }
}

