/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal;

import java.beans.Beans;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import oracle.dms.context.ExecutionContext;
import oracle.dms.instrument.DMSConsole;

public class LoggingUtils {
    private static Level sDMSSensorLevel = Level.OFF;
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final AtomicLong sSequence = new AtomicLong();

    static {
        try {
            int weight = DMSConsole.getSensorWeight();
            switch (weight) {
                case 0: {
                    sDMSSensorLevel = Level.OFF;
                    break;
                }
                case 5: {
                    sDMSSensorLevel = Level.INFO;
                    break;
                }
                case 10: {
                    sDMSSensorLevel = Level.FINE;
                    break;
                }
                case 0x7FFFFFFF: {
                    sDMSSensorLevel = Level.FINEST;
                    break;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            sDMSSensorLevel = Level.OFF;
        }
    }

    private LoggingUtils() {
    }

    public static String getECID() {
        String ecid = null;
        try {
            ExecutionContext execCtx = ExecutionContext.get();
            ecid = execCtx.getIDasString();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return ecid;
    }

    public static String getNounType(String groupName) {
        String type = null;
        StringTokenizer st = new StringTokenizer(groupName, "/");
        if (st.hasMoreTokens()) {
            st.nextToken();
            if (st.hasMoreTokens()) {
                type = st.nextToken();
            }
        }
        return type.toUpperCase();
    }

    public static boolean isDMSLoggingEnabled(Level level) {
        if (Beans.isDesignTime()) {
            return false;
        }
        return sDMSSensorLevel.intValue() <= level.intValue();
    }

    public static String getUrl(HttpServletRequest request) {
        StringBuffer reqUrl = new StringBuffer(request.getRequestURI());
        String method = request.getMethod();
        if (method.equalsIgnoreCase("GET")) {
            String queryString = request.getQueryString();
            if (queryString != null) {
                reqUrl.append("?");
                reqUrl.append(queryString);
            }
        } else if (method.equalsIgnoreCase("POST")) {
            Enumeration pNames = request.getParameterNames();
            reqUrl.append("?");
            while (pNames.hasMoreElements()) {
                String name = (String)pNames.nextElement();
                String lName = name.toLowerCase();
                if (lName.contains(USERNAME) || lName.contains(PASSWORD)) continue;
                reqUrl.append(name);
                reqUrl.append("=");
                String[] values = request.getParameterValues(name);
                int i = 0;
                while (i < values.length) {
                    if (i > 0) {
                        reqUrl.append("|");
                    }
                    reqUrl.append(values[i]);
                    ++i;
                }
                reqUrl.append("&");
            }
            reqUrl.deleteCharAt(reqUrl.length() - 1);
        }
        reqUrl.insert(0, method + ":");
        return reqUrl.toString();
    }

    public static StringBuffer standardizeGroupName(String groupName) {
        int len;
        StringBuffer groupNameBuf = new StringBuffer(groupName = groupName == null || groupName.length() == 0 ? "/oracle/adf" : groupName.replace(' ', '_'));
        if (groupNameBuf.length() >= 1 && groupNameBuf.charAt(0) != '/') {
            groupNameBuf.insert(0, '/');
        }
        if ((len = groupNameBuf.length()) > 0 && groupNameBuf.charAt(len - 1) == '/') {
            groupNameBuf.setLength(len - 1);
        }
        return groupNameBuf;
    }

    public static String standardizeSensorName(String name) {
        if (name != null && name.length() >= 1) {
            name = name.replace(' ', '_');
        }
        return name;
    }

    public static String newChildExecutionContext() {
        String key = null;
        try {
            sSequence.incrementAndGet();
            key = sSequence.toString();
            ExecutionContext.stash((Object)key);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return key;
    }

    public static void setExecutionContext(String key) {
        try {
            ExecutionContext.get((Object)key);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static void deactivateExecutionContext() {
        try {
            ExecutionContext.deactivateContext();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

