/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.analytics;

import java.io.IOException;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adf.share.logging.handler.InternalADFHandler;
import oracle.adf.share.logging.internal.BaseFileHandler;
import oracle.adf.share.logging.internal.analytics.AnalyticsFormatter;

public class AnalyticsFileHandler
extends BaseFileHandler {
    private AnalyticsFileHandler(String pattern, int limit, int count, boolean append, int bufSize) throws IOException, SecurityException {
        super(pattern, limit, count, append, bufSize);
        this.setFormatter(new AnalyticsFormatter());
    }

    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        this.addRecordToList(record, null);
        if (this.isBufferFull()) {
            String ecid = this.getLeastAccessedECID();
            LinkedList recordList = this.removeList(ecid);
            this.printList(ecid, recordList);
        }
    }

    public static void setupLoggerHandler(Logger logger) {
        InternalADFHandler internalHandler = null;
        Handler[] handlers = logger.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            if (handlers[i] instanceof InternalADFHandler) {
                internalHandler = (InternalADFHandler)handlers[i];
                break;
            }
            ++i;
        }
        if (internalHandler == null) {
            logger.setLevel(Level.OFF);
        } else {
            try {
                internalHandler.close();
                logger.removeHandler((Handler)internalHandler);
                logger.addHandler(new AnalyticsFileHandler(internalHandler.mPattern, internalHandler.mLimit, internalHandler.mCount, internalHandler.mAppend, internalHandler.mBufSize));
            }
            catch (IOException e) {
                ErrorManager errMgr = new ErrorManager();
                ResourceBundle rb = ResourceBundle.getBundle("oracle.adf.share.logging.internal.resources.LogHandlerMessageBundle");
                errMgr.error(rb.getString("FAILED_ADD_ANALYTICSFILE_HANDLER"), e, 0);
                logger.setLevel(Level.OFF);
            }
        }
    }
}

