/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.diagnostic;

import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ADFLogRecord
extends LogRecord {
    private transient boolean _needToInferCaller;
    private static final String _JDK_LOG_CLASS = "java.util.logging.Logger";
    private static final String _ADF_LOG_CLASS = "oracle.adf.share.logging.ADFLogger";
    private transient String _LOG_CLASS;

    public ADFLogRecord(Level level, String msg) {
        super(level, msg);
        this.$init$();
    }

    public ADFLogRecord(Class logger, Level level, String msg) {
        this(level, msg);
        if (logger != null) {
            this._LOG_CLASS = logger.getName();
        }
    }

    public String getSourceClassName() {
        if (this._needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceClassName();
    }

    public void setSourceClassName(String sourceClassName) {
        this._needToInferCaller = false;
        super.setSourceClassName(sourceClassName);
    }

    public String getSourceMethodName() {
        if (this._needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceMethodName();
    }

    public void setSourceMethodName(String sourceMethodName) {
        this._needToInferCaller = false;
        super.setSourceMethodName(sourceMethodName);
    }

    private void _inferCaller() {
        this._needToInferCaller = false;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int i = 0;
        while (i < stack.length) {
            StackTraceElement frame = stack[i];
            String cname = frame.getClassName();
            if (cname.equals(_JDK_LOG_CLASS) || cname.equals(_ADF_LOG_CLASS) || cname.equals(this._LOG_CLASS)) break;
            ++i;
        }
        while (i < stack.length) {
            StackTraceElement frame = stack[i];
            String cname = frame.getClassName();
            if (cname.equals(_JDK_LOG_CLASS) || cname.equals(_ADF_LOG_CLASS) || cname.equals(this._LOG_CLASS)) {
                ++i;
                continue;
            }
            String mname = frame.getMethodName();
            if ("log".equals(mname) || "_log".equals(mname)) {
                ++i;
                continue;
            }
            this.setSourceClassName(cname);
            this.setSourceMethodName(mname);
            return;
        }
        this.setSourceClassName(null);
        this.setSourceMethodName(null);
    }

    private void $init$() {
        this._needToInferCaller = true;
        this._LOG_CLASS = _ADF_LOG_CLASS;
    }
}

