/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.perf;

import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.logging.internal.LoggingConstants;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.perf.PerfFileHandler;
import oracle.adf.share.logging.internal.perf.PerfLogRecord;

public class ADFPerfSensor {
    private static int sIndex = 0;
    protected String mSensorFullName;
    protected Level mLevel;
    protected int mIndex;
    protected boolean mEnablePerfLog;
    protected boolean mEnableDms;
    private boolean mIsTimerLogged;
    protected static Logger sLogger;
    protected static Logger sIdxLogger;
    private static Handler sIdxHandler;
    private static final String ADF_PERF_LOGGER_IDX = "oracle.adf.perfIdx";
    private static final String LOG_LINE_FORMAT;

    private void $init$() {
        this.mLevel = null;
        this.mIndex = 0;
        this.mEnablePerfLog = false;
        this.mEnableDms = false;
        this.mIsTimerLogged = false;
    }

    static {
        sIdxLogger = null;
        sIdxHandler = null;
        LOG_LINE_FORMAT = "# Time stamp line format: T long format of date time (timestamp)" + LoggingConstants.LINE_SEPARATOR + "# " + "Sensor index line format: " + "I " + "<sensorIndex> <sensorFullName> <type>" + LoggingConstants.LINE_SEPARATOR + "# " + "Performance entry line format: " + "<ecid> [<sensorIndex> <RID> <timeStamp> <value>]*" + LoggingConstants.LINE_SEPARATOR + "# " + "where <type> can be: " + "t - timer, s - state, c - counter" + LoggingConstants.LINE_SEPARATOR;
        sLogger = Logger.getLogger("oracle.adf.perf");
        sIdxLogger = Logger.getLogger(ADF_PERF_LOGGER_IDX);
        sIdxHandler = PerfFileHandler.setupLoggers(sLogger, sIdxLogger);
        sIdxLogger.log(Level.SEVERE, LOG_LINE_FORMAT);
        DateFormat format = DateFormat.getDateTimeInstance(0, 1);
        sIdxLogger.log(Level.SEVERE, "T " + format.format(new Date(LoggingConstants.STARTTIME)) + " (" + LoggingConstants.STARTTIME + ")" + LoggingConstants.LINE_SEPARATOR);
    }

    public ADFPerfSensor(Level level, String sensorFullName) {
        this.$init$();
        this.mLevel = level;
        this.mSensorFullName = sensorFullName;
        this.mIndex = ADFPerfSensor.getIndex();
        this.mEnablePerfLog = sLogger.isLoggable(level);
        this.mEnableDms = LoggingUtils.isDMSLoggingEnabled(level);
    }

    protected ADFPerfSensor() {
        this.$init$();
    }

    protected void log(long timeStamp, String value, String ecid) {
        this.logIndex();
        PerfLogRecord record = new PerfLogRecord(this.mLevel, value);
        record.setMillis(timeStamp);
        record.setIndex(this.mIndex);
        record.setEcid(ecid);
        sLogger.log(record);
    }

    public boolean isActive() {
        return this.mEnablePerfLog || this.mEnableDms;
    }

    private synchronized void logIndex() {
        if (!this.mIsTimerLogged) {
            StringBuffer sb = new StringBuffer();
            sb.append("I ");
            sb.append(this.mIndex);
            sb.append(" ");
            sb.append(this.mSensorFullName);
            sb.append(LoggingConstants.LINE_SEPARATOR);
            sIdxLogger.log(this.mLevel, sb.toString());
            if (sIdxHandler != null) {
                sIdxHandler.flush();
            }
            this.mIsTimerLogged = true;
        }
    }

    private static synchronized int getIndex() {
        return ++sIndex;
    }
}

