/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.perf;

import java.io.IOException;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adf.share.logging.handler.InternalADFHandler;
import oracle.adf.share.logging.internal.BaseFileHandler;
import oracle.adf.share.logging.internal.LoggingConstants;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.perf.PerfFormatter;
import oracle.adf.share.logging.internal.perf.PerfLogRecord;

public class PerfFileHandler
extends BaseFileHandler {
    private PerfFileHandler(String pattern, int limit, int count, boolean append, int bufSize) throws IOException, SecurityException {
        super(pattern, limit, count, append, bufSize);
        this.setFormatter(new PerfFormatter());
    }

    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (!(record instanceof PerfLogRecord)) {
            super.publish(record);
            return;
        }
        String ecid = ((PerfLogRecord)record).getEcid();
        if (ecid == null) {
            ecid = LoggingUtils.getECID();
            ((PerfLogRecord)record).setEcid(ecid);
        }
        ecid = this.addRecordToList(record, ecid);
        LinkedList recordList = null;
        if (ecid != null && this.isRecordListTooLong(ecid)) {
            recordList = this.removeList(ecid);
        } else if (this.isBufferFull()) {
            ecid = this.getLeastAccessedECID();
            recordList = this.removeList(ecid);
        }
        if (recordList != null) {
            this.printList(ecid, recordList);
        }
    }

    static FileHandler setupLoggers(Logger mainLogger, Logger idxLogger) {
        InternalADFHandler internalHandler = null;
        Handler[] handlers = mainLogger.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            if (handlers[i] instanceof InternalADFHandler) {
                internalHandler = (InternalADFHandler)handlers[i];
                break;
            }
            ++i;
        }
        if (internalHandler == null) {
            mainLogger.setLevel(Level.OFF);
            idxLogger.setLevel(Level.OFF);
            return null;
        }
        try {
            internalHandler.close();
            mainLogger.removeHandler((Handler)internalHandler);
            mainLogger.addHandler(new PerfFileHandler(internalHandler.mPattern, internalHandler.mLimit, internalHandler.mCount, internalHandler.mAppend, internalHandler.mBufSize));
        }
        catch (IOException e) {
            ErrorManager errMgr = new ErrorManager();
            ResourceBundle rb = ResourceBundle.getBundle("oracle.adf.share.logging.internal.resources.LogHandlerMessageBundle");
            errMgr.error(rb.getString("FAILED_TO_ADD_PERFHANDLER"), e, 0);
            mainLogger.setLevel(Level.OFF);
            idxLogger.setLevel(Level.OFF);
            FileHandler fileHandler = null;
            return fileHandler;
        }
        idxLogger.setLevel(mainLogger.getLevel());
        idxLogger.setUseParentHandlers(false);
        FileHandler handler = null;
        try {
            handler = new FileHandler(internalHandler.mPath + LoggingConstants.FILE_SEPARATOR + "adfperf" + ".log", false);
            handlers = idxLogger.getHandlers();
            int i2 = 0;
            while (i2 < handlers.length) {
                idxLogger.removeHandler(handlers[i2]);
                ++i2;
            }
            idxLogger.addHandler(handler);
            handler.setFormatter(new PerfFormatter());
            FileHandler fileHandler = handler;
            return fileHandler;
        }
        catch (IOException e) {
            ErrorManager errMgr = new ErrorManager();
            ResourceBundle rb = ResourceBundle.getBundle("oracle.adf.share.logging.internal.resources.LogHandlerMessageBundle");
            errMgr.error(rb.getString("FAILED_TO_ADD_INDEX_LOGGER"), e, 0);
            mainLogger.setLevel(Level.OFF);
            idxLogger.setLevel(Level.OFF);
            FileHandler fileHandler = null;
            return fileHandler;
        }
    }
}

