/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.perf;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import oracle.adf.share.logging.internal.LogLine;
import oracle.adf.share.logging.internal.LoggingConstants;
import oracle.adf.share.logging.internal.perf.PerfLogRecord;

public class PerfFormatter
extends Formatter {
    public String formatMessage(LogRecord record) {
        if (!(record instanceof LogLine)) {
            return super.formatMessage(record);
        }
        LogLine line = (LogLine)record;
        LinkedList recordList = line.getRecordList();
        if (recordList != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(line.getMessage());
            ListIterator it = recordList.listIterator();
            while (it.hasNext()) {
                PerfLogRecord lr = (PerfLogRecord)it.next();
                sb.append(" ");
                sb.append("[");
                sb.append(lr.getIndex());
                sb.append(" ");
                sb.append(lr.getRID());
                sb.append(" ");
                sb.append(lr.getMillis() - LoggingConstants.STARTTIME);
                sb.append(" ");
                sb.append(lr.getMessage());
                sb.append("]");
            }
            sb.append(LoggingConstants.LINE_SEPARATOR);
            return sb.toString();
        }
        return null;
    }

    public String format(LogRecord record) {
        return this.formatMessage(record);
    }
}

