/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.PrintStream;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.SensorResult;

class CounterResult
extends SensorResult {
    CounterResult(int nameIndex) {
        this.mNameIndex = nameIndex;
    }

    void print(PrintStream out, boolean printGap, String spaces) {
        String fullName = (String)Analyzer.sSensorNames.get(this.mNameIndex);
        if (Analyzer.sFormatXml) {
            int sep = fullName.lastIndexOf(47);
            String name = fullName.substring(sep + 1);
            String group = fullName.substring(0, sep);
            out.print("Count: (");
            if (printGap) {
                out.print(" gap=" + CounterResult.prependSpace(SensorResult.sDblFmt.format((double)this.mGap / (double)this.mHit), 6) + " |");
            }
            out.print(" hit=" + CounterResult.prependSpace(SensorResult.sIntFmt.format(this.mHit), 6));
            out.print(" | cnt=" + this.mValue);
            if (Analyzer.sAnalysisType == 2) {
                out.print(" | rtt=" + CounterResult.prependSpace(SensorResult.sDblFmt.format(this.mRunningTotal), 6));
            }
            out.print(" )");
            out.println(" " + name + " [" + group + "]");
        } else {
            out.println(spaces + "Counter:" + fullName + " [id=" + this.mNameIndex + "]");
            out.print(spaces + "(");
            if (printGap) {
                out.print(" gap=" + CounterResult.prependSpace(SensorResult.sDblFmt.format((double)this.mGap / (double)this.mHit), 6) + " |");
            }
            out.print(" hit=" + CounterResult.prependSpace(SensorResult.sIntFmt.format(this.mHit), 6));
            out.print(" | cnt=" + this.mValue);
            if (Analyzer.sAnalysisType == 2) {
                out.print(" | rtt=" + CounterResult.prependSpace(SensorResult.sDblFmt.format(this.mRunningTotal), 6));
            }
            if (Analyzer.sDebug) {
                out.print(" | ts=" + CounterResult.prependSpace(SensorResult.sIntFmt.format(this.mTimeStamp), 6));
            }
            out.println(" )");
            out.println("");
        }
    }
}

