/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.CounterResult;
import oracle.adf.share.perf.analysis.SensorResult;
import oracle.adf.share.perf.analysis.SensorTable;
import oracle.adf.share.perf.analysis.SensorTree;
import oracle.adf.share.perf.analysis.StateResult;
import oracle.adf.share.perf.analysis.TimerResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestAnalyzer
extends Analyzer {
    private static final int MAX_NUM_REQUESTS = 1000;
    private static int sIdCount = 0;
    private LinkedHashMap mRequests;
    private Hashtable mMasterSensorTables;

    private void $init$() {
        this.mRequests = new LinkedHashMap();
        this.mMasterSensorTables = new Hashtable();
    }

    @Override
    void analyseLine(String line) {
        int pos = line.indexOf(" ");
        String ecid = this.removeSeqNum(line.substring(0, pos));
        SensorTable table = (SensorTable)this.mRequests.get(ecid);
        if (table == null) {
            table = new SensorTable();
            this.mRequests.put(ecid, table);
        }
        pos += " ".length();
        int endPos = 0;
        while ((endPos = line.indexOf("[", pos)) != -1) {
            pos = endPos + "[".length();
            endPos = line.indexOf(" ", pos);
            int index = Integer.parseInt(line.substring(pos, endPos));
            pos = endPos + " ".length();
            endPos = line.indexOf(" ", pos);
            String rid = line.substring(pos, endPos);
            pos = endPos + " ".length();
            endPos = line.indexOf(" ", pos);
            long timeStamp = Long.parseLong(line.substring(pos, endPos));
            int startPos = pos = endPos + " ".length();
            while ((endPos = line.indexOf("]", startPos)) + "]".length() < line.length() && line.charAt(endPos + "]".length()) != ' ') {
                startPos = endPos + 1;
            }
            String value = line.substring(pos, endPos);
            pos = endPos + "]".length();
            SensorResult result = null;
            String idx = (String)Analyzer.sSensorTypes.get(index);
            if (idx != null) {
                if (idx.equals("t")) {
                    result = new TimerResult(index);
                } else if (idx.equals("c")) {
                    result = new CounterResult(index);
                } else if (idx.equals("s")) {
                    result = new StateResult(index);
                }
            } else {
                System.out.println("Warning: index " + index + " does not exist in performance index file.");
            }
            if (result == null) continue;
            result.mRID = rid;
            result.mTimeStamp = timeStamp;
            result.setValue(value);
            if (this.isFiltered(result)) continue;
            table.add(result);
        }
        if (this.mRequests.size() >= 1000) {
            Iterator keys = this.mRequests.keySet().iterator();
            int count = 0;
            while (keys.hasNext() && count < 500) {
                ++count;
                this.addToMasterTable(keys);
            }
        }
    }

    private void addToMasterTable(Iterator keys) {
        Object value;
        Object key = keys.next();
        SensorTable curTable = (SensorTable)this.mRequests.get(key);
        String url = curTable.getURL();
        if (url == null) {
            return;
        }
        curTable.reBaseTimeStamp();
        if (Analyzer.sDebug) {
            Analyzer.sOut.println("DEBUG: ecid=" + key + " url=" + url);
            Analyzer.sOut.println("=====================================================");
            curTable.print(Analyzer.sOut);
        }
        if ((value = this.mMasterSensorTables.get(url)) == null) {
            if (Analyzer.sExcludeCount > 0) {
                this.mMasterSensorTables.put(url, new Integer(1));
                if (Analyzer.sDebug) {
                    Analyzer.sOut.println("Excluded it from aggregation.");
                }
            } else {
                this.mMasterSensorTables.put(url, curTable);
            }
        } else if (value instanceof Integer) {
            int curCount = (Integer)value;
            if (Analyzer.sExcludeCount < ++curCount) {
                this.mMasterSensorTables.put(url, curTable);
            } else {
                this.mMasterSensorTables.put(url, new Integer(curCount));
                if (Analyzer.sDebug) {
                    Analyzer.sOut.println("Excluded it from aggregation.");
                }
            }
        } else {
            SensorTable masterTable = (SensorTable)value;
            masterTable.aggregate(curTable);
            if (Analyzer.sDebug) {
                Analyzer.sOut.println("DEBUG: after aggregate");
                Analyzer.sOut.println("=====================================================");
                masterTable.print(Analyzer.sOut);
            }
        }
        keys.remove();
    }

    @Override
    void print() {
        Iterator keys = this.mRequests.keySet().iterator();
        while (keys.hasNext()) {
            this.addToMasterTable(keys);
        }
        TreeSet<SensorTree> treeSet = this.convertToTreeSet();
        if (Analyzer.sFormatXml) {
            Analyzer.sOut.println("<?xml version=\"1.0\" ?>");
            Analyzer.sOut.println("<?xml-stylesheet type=\"text/xsl\" href=\"xmlTree.xsl\"?>");
            Analyzer.sOut.println("<!DOCTYPE tree SYSTEM 'tree.dtd'>");
            Analyzer.sOut.println("<tree>");
        } else {
            Analyzer.sOut.println("===================SUMMARY REPORT====================");
            Analyzer.sOut.println();
        }
        Iterator<SensorTree> it = treeSet.iterator();
        int count = 0;
        while (it.hasNext() && count < Analyzer.sNumTopUrls) {
            ++count;
            SensorTree masterTree = it.next();
            String url = masterTree.getURL();
            if (Analyzer.sFormatXml) {
                Analyzer.sOut.println("  <branch id=\"url" + sIdCount++ + "\">");
                Analyzer.sOut.println("    <branchText>(" + masterTree.getSummary() + ") " + RequestAnalyzer.htmlEncode(url) + "</branchText>");
            } else {
                Analyzer.sOut.println("[" + masterTree.getSummary() + "] " + url);
                Analyzer.sOut.println("=====================================================");
            }
            masterTree.print(Analyzer.sOut);
            if (Analyzer.sFormatXml) {
                Analyzer.sOut.println("  </branch>");
                continue;
            }
            Analyzer.sOut.println("=====================================================");
            Analyzer.sOut.println();
        }
        if (Analyzer.sFormatXml) {
            Analyzer.sOut.println("</tree>");
        }
    }

    private TreeSet<SensorTree> convertToTreeSet() {
        if (Analyzer.sIgnoreThreshold > 0) {
            this.removeMinorSensors();
        }
        TreeSet<SensorTree> treeSet = new TreeSet<SensorTree>(new TreeComparator(null));
        for (String url : this.mMasterSensorTables.keySet()) {
            SensorTable table;
            SensorTree tree;
            Object obj = this.mMasterSensorTables.get(url);
            if (!(obj instanceof SensorTable) || !(tree = (table = (SensorTable)obj).convertToTree()).hasURLThread()) continue;
            tree.setThreadGap();
            tree.setRunningTotal();
            treeSet.add(tree);
        }
        return treeSet;
    }

    private void removeMinorSensors() {
        for (String url : this.mMasterSensorTables.keySet()) {
            Object obj = this.mMasterSensorTables.get(url);
            if (!(obj instanceof SensorTable)) continue;
            SensorTable table = (SensorTable)obj;
            table.removeMinorSensors();
        }
    }

    private String removeSeqNum(String ecid) {
        int idx = ecid.lastIndexOf(44);
        if (idx != -1) {
            ecid = ecid.substring(0, idx);
        }
        return ecid;
    }

    RequestAnalyzer() {
        this.$init$();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeComparator
    implements Comparator<SensorTree> {
        @Override
        public int compare(SensorTree t1, SensorTree t2) {
            if (t1.getRequestAverageTime() <= t2.getRequestAverageTime()) {
                return 1;
            }
            return -1;
        }

        private TreeComparator() {
        }

        TreeComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

