/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.CounterResult;
import oracle.adf.share.perf.analysis.SensorResult;
import oracle.adf.share.perf.analysis.StateResult;
import oracle.adf.share.perf.analysis.TimerResult;

class SensorAnalyzer
extends Analyzer {
    private Vector mSensorResults;

    private void $init$() {
        this.mSensorResults = new Vector();
    }

    void addSensor(int index, String name, String type) {
        if (index + 1 > this.mSensorResults.size()) {
            this.mSensorResults.setSize(index + 1);
        }
        super.addSensor(index, name, type);
    }

    void analyseLine(String line) {
        StringTokenizer st = new StringTokenizer(line, " [");
        st.nextToken();
        while (st.hasMoreTokens()) {
            int index = Integer.parseInt(st.nextToken(" []"));
            st.nextToken();
            st.nextToken();
            String value = st.nextToken("]").substring(1);
            SensorResult result = (SensorResult)this.mSensorResults.get(index);
            if (Analyzer.sSensorTypes.get(index).equals("t")) {
                if (result == null) {
                    result = new TimerResult(index);
                    this.mSensorResults.set(index, result);
                }
            } else {
                if (Analyzer.sTimerOnly) continue;
                if (Analyzer.sSensorTypes.get(index).equals("c")) {
                    if (result == null) {
                        result = new CounterResult(index);
                        this.mSensorResults.set(index, result);
                    }
                } else if (Analyzer.sSensorTypes.get(index).equals("s") && result == null) {
                    result = new StateResult(index);
                    this.mSensorResults.set(index, result);
                }
            }
            if (result == null || this.isFiltered(result)) continue;
            result.setValue(value);
        }
    }

    void print() {
        int size = this.mSensorResults.size();
        TreeSet<SensorResult> resultSet = new TreeSet<SensorResult>(new SensorComparator(null));
        int i = 0;
        while (i < size) {
            SensorResult result = (SensorResult)this.mSensorResults.get(i);
            if (result != null) {
                resultSet.add(result);
            }
            ++i;
        }
        Iterator<SensorResult> it = resultSet.iterator();
        int count = 0;
        while (it.hasNext() && count < Analyzer.sNumTopUrls) {
            ++count;
            it.next().print(Analyzer.sOut, false, "");
        }
    }

    SensorAnalyzer() {
        this.$init$();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SensorComparator
    implements Comparator<SensorResult> {
        @Override
        public int compare(SensorResult s1, SensorResult s2) {
            if (s1.mElapseTime <= s2.mElapseTime) {
                return 1;
            }
            return -1;
        }

        private SensorComparator() {
        }

        SensorComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

