/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.PrintStream;
import java.text.DecimalFormat;

abstract class SensorResult {
    String mRID;
    long mTimeStamp;
    long mElapseTime;
    int mNameIndex;
    String mValue;
    int mHit;
    double mRunningTotal;
    long mGap;
    static DecimalFormat sDblFmt = new DecimalFormat("#,##0.00");
    static DecimalFormat sIntFmt = new DecimalFormat("###,##0");

    private void $init$() {
        this.mRID = null;
        this.mTimeStamp = 0L;
        this.mElapseTime = 0L;
        this.mNameIndex = 0;
        this.mValue = null;
        this.mHit = 0;
        this.mRunningTotal = 0.0;
        this.mGap = 0L;
    }

    abstract void print(PrintStream var1, boolean var2, String var3);

    void setValue(String value) {
        ++this.mHit;
        this.mValue = value;
    }

    String getValue() {
        return this.mValue;
    }

    void setGap(SensorResult prev, boolean isChild) {
        this.mGap = this.mTimeStamp - prev.mTimeStamp;
        if (!isChild) {
            this.mGap -= prev.mElapseTime;
        }
    }

    void aggregate(SensorResult result) {
        this.mTimeStamp += result.mTimeStamp;
        this.setValue(result.mValue);
    }

    static String prependSpace(String str, int bufSize) {
        int size = str.length();
        if (bufSize <= size) {
            return str;
        }
        StringBuffer buf = new StringBuffer(size);
        int i = 0;
        while (i < bufSize - size) {
            buf.append('_');
            ++i;
        }
        buf.replace(bufSize - size, bufSize, str);
        return buf.toString();
    }

    SensorResult() {
        this.$init$();
    }
}

