/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.SensorResult;
import oracle.adf.share.perf.analysis.TimerResult;
import oracle.adf.share.perf.analysis.TreeNode;

class SensorTree {
    private TreeSet mThreads;
    private String mUrl;
    private TreeSet mUrlThreads;
    private static final int INDENTATION_SPACES = 2;
    private static int sXmlIdCount = 0;
    private int mMinThreadCount;
    private int mMaxThreadCount;
    private long mTotalThreadCount;
    private long mRequestCount;

    private void $init$() {
        this.mThreads = new TreeSet<TreeNode>(new ThreadComparator(null));
        this.mUrl = null;
        this.mUrlThreads = new TreeSet<TreeNode>(new ThreadComparator(null));
        this.mMinThreadCount = Integer.MAX_VALUE;
        this.mMaxThreadCount = Integer.MIN_VALUE;
        this.mTotalThreadCount = 0L;
        this.mRequestCount = 0L;
    }

    SensorTree(int minThreadCount, int maxThreadCount, long totalThreadCount, long requestCount) {
        this.$init$();
        this.mMinThreadCount = minThreadCount;
        this.mMaxThreadCount = maxThreadCount;
        this.mTotalThreadCount = totalThreadCount;
        this.mRequestCount = requestCount;
    }

    void addThread(TreeNode root, boolean isUrlThread) {
        if (isUrlThread) {
            this.mUrlThreads.add(root);
        } else {
            this.mThreads.add(root);
        }
    }

    TreeNode insertToThread(TreeNode threadRoot, SensorResult result) {
        int nameIdx = result.mNameIndex;
        if (this.mUrl == null && ((String)Analyzer.sSensorTypes.get(nameIdx)).equalsIgnoreCase("s") && ((String)Analyzer.sSensorNames.get(nameIdx)).endsWith("/url")) {
            this.mUrl = result.getValue();
        }
        if (!((String)Analyzer.sSensorTypes.get(nameIdx)).equalsIgnoreCase("t") && Analyzer.sTimerOnly) {
            return threadRoot;
        }
        return this.add(new TreeNode(result), threadRoot);
    }

    private TreeNode add(TreeNode newNode, TreeNode root) {
        if (root == null) {
            return newNode;
        }
        if (newNode.mResult.mTimeStamp < root.mResult.mTimeStamp) {
            if (newNode.mResult.mTimeStamp + newNode.mResult.mElapseTime >= root.mResult.mTimeStamp + root.mResult.mElapseTime) {
                this.enclose(newNode, root);
            } else {
                newNode.mParent = root.mParent;
                if (newNode.mParent != null) {
                    newNode.mParent.mChild = newNode;
                    root.mParent = null;
                }
                newNode.mNext = root;
                newNode.mPrev = root.mPrev;
                if (newNode.mPrev != null) {
                    newNode.mPrev.mNext = newNode;
                    newNode.mResult.setGap(newNode.mPrev.mResult, false);
                }
                root.mPrev = newNode;
                root.mResult.setGap(newNode.mResult, false);
            }
            return newNode;
        }
        if (newNode.mResult.mTimeStamp == root.mResult.mTimeStamp && newNode.mResult instanceof TimerResult) {
            this.enclose(newNode, root);
            return newNode;
        }
        if (newNode.mResult.mTimeStamp >= root.mResult.mTimeStamp + root.mResult.mElapseTime) {
            TreeNode newRoot = root;
            while (newRoot.mNext != null) {
                if (newNode.mResult.mTimeStamp < newRoot.mNext.mResult.mTimeStamp + newRoot.mNext.mResult.mElapseTime) break;
                newRoot = newRoot.mNext;
            }
            if (newNode.mResult.mTimeStamp == newRoot.mResult.mTimeStamp && newRoot.mResult.mElapseTime == 0L && newNode.mResult instanceof TimerResult) {
                this.enclose(newNode, newRoot);
                return root;
            }
            newNode = this.add(newNode, newRoot.mNext);
            newNode.mPrev = newRoot;
            newRoot.mNext = newNode;
            newNode.mResult.setGap(newRoot.mResult, false);
            return root;
        }
        if (newNode.mResult.mTimeStamp + newNode.mResult.mElapseTime <= root.mResult.mTimeStamp + root.mResult.mElapseTime) {
            if (newNode.mResult.mTimeStamp == root.mResult.mTimeStamp && newNode.mResult.mTimeStamp + newNode.mResult.mElapseTime == root.mResult.mTimeStamp + root.mResult.mElapseTime) {
                this.enclose(newNode, root);
                return newNode;
            }
            root.mChild = newNode = this.add(newNode, root.mChild);
            newNode.mParent = root;
            newNode.mResult.setGap(root.mResult, true);
            return root;
        }
        if (newNode.mResult.mTimeStamp == root.mResult.mTimeStamp) {
            this.enclose(newNode, root);
            return newNode;
        }
        System.out.println("Warning: two sensors with the same ecid and RID should not have following situation:");
        System.out.println(" rId=" + root.mResult.mRID + " rootNameIndex=" + root.mResult.mNameIndex + " timeStamp=" + root.mResult.mTimeStamp + " elapseTime=" + root.mResult.mElapseTime + " newNodeNameIndex=" + newNode.mResult.mNameIndex + " timeStamp=" + newNode.mResult.mTimeStamp + " elapseTime=" + newNode.mResult.mElapseTime);
        newNode = this.add(newNode, root.mChild);
        newNode.mParent = root;
        root.mChild = newNode;
        newNode.mResult.setGap(root.mResult, true);
        return root;
    }

    private void enclose(TreeNode newNode, TreeNode root) {
        TreeNode node = root;
        while (node.mNext != null) {
            if (newNode.mResult.mTimeStamp + newNode.mResult.mElapseTime < node.mNext.mResult.mTimeStamp + node.mNext.mResult.mElapseTime) break;
            node = node.mNext;
        }
        newNode.mParent = root.mParent;
        if (newNode.mParent != null) {
            newNode.mParent.mChild = newNode;
        }
        newNode.mChild = root;
        root.mParent = newNode;
        root.mResult.setGap(newNode.mResult, true);
        newNode.mNext = node.mNext;
        if (newNode.mNext != null) {
            newNode.mNext.mPrev = newNode;
            newNode.mNext.mResult.setGap(newNode.mResult, false);
        }
        node.mNext = null;
        newNode.mPrev = root.mPrev;
        if (newNode.mPrev != null) {
            newNode.mPrev.mNext = newNode;
            newNode.mResult.setGap(newNode.mPrev.mResult, false);
        }
        root.mPrev = null;
    }

    String getURL() {
        return this.mUrl;
    }

    boolean hasURLThread() {
        return this.mUrlThreads.isEmpty() ^ true;
    }

    void setThreadGap() {
        long earliestTS = Long.MAX_VALUE;
        for (TreeNode root : this.mUrlThreads) {
            if (root.mResult.mTimeStamp >= earliestTS) continue;
            earliestTS = root.mResult.mTimeStamp;
        }
        for (TreeNode root : this.mThreads) {
            if (root.mResult.mTimeStamp >= earliestTS) continue;
            earliestTS = root.mResult.mTimeStamp;
        }
        for (TreeNode root : this.mUrlThreads) {
            root.mResult.mGap = root.mResult.mTimeStamp - earliestTS;
        }
        for (TreeNode root : this.mThreads) {
            root.mResult.mGap = root.mResult.mTimeStamp - earliestTS;
        }
    }

    void setRunningTotal() {
        for (TreeNode node : this.mUrlThreads) {
            node.setRunningTotal(0.0);
        }
        for (TreeNode node : this.mThreads) {
            node.setRunningTotal(0.0);
        }
    }

    double getRequestAverageTime() {
        double duration = 0.0;
        int totalHits = 0;
        for (TreeNode node : this.mUrlThreads) {
            duration += node.getDuration() * (double)node.mResult.mHit;
            totalHits += node.mResult.mHit;
        }
        return duration / (double)totalHits;
    }

    String getSummary() {
        if (this.mUrlThreads.isEmpty()) {
            System.out.println("Error: don't have thread that contains url sensor.");
            return "";
        }
        String summary = "request.avg=" + SensorResult.sDblFmt.format(this.getRequestAverageTime());
        if (this.mThreads.size() > 0) {
            summary = summary + "| thread.avg=" + SensorResult.sDblFmt.format((double)this.mTotalThreadCount / (double)this.mRequestCount);
            if (this.mMaxThreadCount != this.mMinThreadCount) {
                summary = summary + " | thread.max=" + this.mMaxThreadCount + " | thread.min=" + this.mMinThreadCount;
            }
        }
        return summary;
    }

    void print(PrintStream out) {
        int threadSize = this.mUrlThreads.size() + this.mThreads.size();
        int threadCount = 1;
        Iterator itr = this.mUrlThreads.iterator();
        while (itr.hasNext()) {
            int depth = 1;
            if (Analyzer.sFormatXml) {
                depth = 4;
            }
            TreeNode root = (TreeNode)itr.next();
            if (threadSize > 1) {
                if (Analyzer.sFormatXml) {
                    double gap = (double)root.mResult.mGap / (double)root.mResult.mHit;
                    double du = root.getDuration() - gap;
                    out.println("      <branch id=\"thread" + sXmlIdCount++ + "\">");
                    out.println("        <branchText>(gap=" + SensorResult.prependSpace(SensorResult.sDblFmt.format(gap), 8) + " | avg=" + SensorResult.prependSpace(SensorResult.sDblFmt.format(du), 8) + ") Main thread pattern: " + threadCount + "</branchText>");
                    depth += 4;
                } else {
                    out.println("Main thread pattern: " + threadCount);
                    ++depth;
                }
                ++threadCount;
            }
            this.print(out, root, depth);
            if (threadSize <= 1 || !Analyzer.sFormatXml) continue;
            out.println("      </branch>");
        }
        itr = this.mThreads.iterator();
        while (itr.hasNext()) {
            int depth = 1;
            if (Analyzer.sFormatXml) {
                depth = 4;
            }
            TreeNode root = (TreeNode)itr.next();
            if (threadSize > 1) {
                if (Analyzer.sFormatXml) {
                    double gap = (double)root.mResult.mGap / (double)root.mResult.mHit;
                    double du = root.getDuration() - gap;
                    out.println("      <branch id=\"thread" + sXmlIdCount++ + "\">");
                    out.println("        <branchText>(gap=" + SensorResult.prependSpace(SensorResult.sDblFmt.format(gap), 8) + " | avg=" + SensorResult.prependSpace(SensorResult.sDblFmt.format(du), 8) + ") Child thread pattern: " + threadCount + "</branchText>");
                    depth += 4;
                } else {
                    out.println("Child thread pattern: " + threadCount);
                    ++depth;
                }
                ++threadCount;
            }
            this.print(out, root, depth);
            if (threadSize <= 1 || !Analyzer.sFormatXml) continue;
            out.println("      </branch>");
        }
    }

    void print(PrintStream out, TreeNode root, int depth) {
        do {
            byte[] spaces = new byte[2 * (depth - 1)];
            int i = 0;
            while (i < spaces.length) {
                spaces[i] = 32;
                ++i;
            }
            String indent = new String(spaces);
            if (Analyzer.sFormatXml) {
                if (root.mChild != null) {
                    out.println(indent + "<branch id=\"id" + sXmlIdCount++ + "\">");
                    out.println(indent + "  <branchText>");
                } else {
                    out.println(indent + "<leaf>");
                    out.println(indent + "  <leafText>");
                }
            }
            root.mResult.print(out, true, indent);
            if (Analyzer.sFormatXml) {
                if (root.mChild != null) {
                    out.println(indent + "  </branchText>");
                } else {
                    out.println(indent + "  </leafText>");
                }
            }
            if (root.mChild != null) {
                this.print(out, root.mChild, depth + 1);
            }
            if (!Analyzer.sFormatXml) continue;
            if (root.mChild != null) {
                out.println(indent + "</branch>");
                continue;
            }
            out.println(indent + "</leaf>");
        } while ((root = root.mNext) != null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThreadComparator
    implements Comparator<TreeNode> {
        @Override
        public int compare(TreeNode t1, TreeNode t2) {
            if (t1.mResult.mHit <= t2.mResult.mHit) {
                return 1;
            }
            return -1;
        }

        private ThreadComparator() {
        }

        ThreadComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

