/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.PrintStream;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.SensorResult;

class StateResult
extends SensorResult {
    StateResult(int nameIndex) {
        this.mNameIndex = nameIndex;
    }

    void print(PrintStream out, boolean printGap, String spaces) {
        String fullName = (String)Analyzer.sSensorNames.get(this.mNameIndex);
        if (Analyzer.sFormatXml) {
            int sep = fullName.lastIndexOf(47);
            String name = fullName.substring(sep + 1);
            String group = fullName.substring(0, sep);
            out.print("State: (");
            if (printGap) {
                out.print(" gap=" + StateResult.prependSpace(SensorResult.sDblFmt.format((double)this.mGap / (double)this.mHit), 6) + " |");
            }
            out.print(" hit=" + StateResult.prependSpace(SensorResult.sIntFmt.format(this.mHit), 6));
            out.print(" | state=" + Analyzer.htmlEncode(this.mValue));
            if (Analyzer.sAnalysisType == 2) {
                out.print(" | rtt=" + StateResult.prependSpace(SensorResult.sDblFmt.format(this.mRunningTotal), 6));
            }
            out.print(" )");
            out.println(" " + name + " [" + group + "]");
        } else {
            out.println(spaces + "State:" + fullName + " [id=" + this.mNameIndex + "]");
            out.print(spaces + "(");
            if (printGap) {
                out.print(" gap=" + StateResult.prependSpace(SensorResult.sDblFmt.format((double)this.mGap / (double)this.mHit), 6) + " |");
            }
            out.print(" hit=" + StateResult.prependSpace(SensorResult.sIntFmt.format(this.mHit), 6));
            out.print(" | state=" + this.mValue);
            if (Analyzer.sAnalysisType == 2) {
                out.print(" | rtt=" + StateResult.prependSpace(SensorResult.sDblFmt.format(this.mRunningTotal), 6));
            }
            if (Analyzer.sDebug) {
                out.print(" | ts=" + StateResult.prependSpace(SensorResult.sIntFmt.format(this.mTimeStamp), 6));
            }
            out.println(" )");
            out.println("");
        }
    }
}

