/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.services.DescriptorConstants;
import oracle.adf.share.services.DescriptorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDescriptorContext
implements DescriptorContext {
    private static boolean dontTryADFContextAgain = false;
    private static Method adfGetCurrentMeth = null;
    private static Method adfGetLocaleMeth = null;
    private static Logger logger = null;
    private final Context mNamingContext;
    private volatile URL mJarURL;
    private volatile String mJarName;
    private volatile long mLastModified;
    private volatile Manifest mManifest;
    private volatile Attributes mMainAttributes;
    private volatile Collection<String> mBundleClasses;

    private final Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(this.getClass().getName());
        }
        return logger;
    }

    private void $init$() {
        this.mJarURL = null;
        this.mJarName = null;
        this.mLastModified = -1;
        this.mManifest = null;
        this.mMainAttributes = null;
        this.mBundleClasses = null;
    }

    public DefaultDescriptorContext(URL jarURL) {
        this.$init$();
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.provider.url", jarURL);
        env.put("java.naming.factory.initial", "oracle.adf.share.services.jndi.DescriptorFactory");
        env.put("oracle.adf.share.services.context", this);
        try {
            this.mNamingContext = new InitialContext(env);
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
    }

    public DefaultDescriptorContext(Context namingContext) {
        this.$init$();
        this.mNamingContext = namingContext;
    }

    @Override
    public Context getNamingContext() {
        return this.mNamingContext;
    }

    @Override
    public URL getJarURL() {
        if (this.mJarURL == null) {
            try {
                this.mJarURL = (URL)this.mNamingContext.getEnvironment().get("java.naming.provider.url");
            }
            catch (NamingException ne) {
                this.getLogger().log(Level.WARNING, "", ne);
            }
        }
        return this.mJarURL;
    }

    @Override
    public String getJarName() throws IOException {
        Attributes mainAttributes;
        URL jarURL = this.getInternalJarURL();
        if (jarURL == null) {
            return null;
        }
        String simpleName = this.simpleJarName(jarURL);
        String jarName = this.getFromBundles(".name", this.mJarName);
        if (jarName == null && this.mMainAttributes != null && (jarName = (mainAttributes = this.mMainAttributes).getValue(Attributes.Name.IMPLEMENTATION_TITLE)) == null) {
            jarName = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
        }
        jarName = jarName == null ? simpleName : MessageFormat.format(jarName, simpleName);
        this.mJarName = jarName;
        return jarName;
    }

    @Override
    public String getString(String[] descriptorNames, String suffix) throws IOException {
        return this.getString(descriptorNames == null ? (List<String>)null : Arrays.asList(descriptorNames), suffix);
    }

    @Override
    public String getString(Collection<String> descriptorNames, String suffix) throws IOException {
        if (!DescriptorConstants.ALL_SUFFIXES.contains(suffix)) {
            throw new IllegalArgumentException(suffix);
        }
        return this.getStringInternal(descriptorNames, suffix, false);
    }

    @Override
    public boolean isDescriptorVisible(String[] names, boolean checkParents) throws IOException {
        return this.isDescriptorVisible(names == null ? (List<String>)null : Arrays.asList(names), checkParents);
    }

    @Override
    public boolean isDescriptorVisible(Collection<String> names, boolean checkParents) throws IOException {
        return "false".equals(this.getStringInternal(names, "visible", checkParents)) ^ true;
    }

    private String getStringInternal(Collection<String> descriptorNames, String suffix, boolean checkParents) throws IOException {
        if (descriptorNames == null) {
            descriptorNames = Collections.emptyList();
        }
        StringBuilder buf = new StringBuilder();
        if (descriptorNames.size() > 0) {
            for (String namePart : descriptorNames) {
                buf.append(namePart + "|");
            }
            buf.setLength(buf.length() - 1);
        }
        buf.append("." + suffix);
        String ret = this.getFromBundles(buf.toString(), null);
        if (ret != null || !checkParents) {
            return ret;
        }
        if (descriptorNames.size() > 1) {
            ArrayList<String> newNames = new ArrayList<String>(descriptorNames);
            newNames.remove(descriptorNames.size() - 1);
            return this.getStringInternal(newNames, suffix, checkParents);
        }
        return Boolean.toString(this.isPackageVisible(null, false));
    }

    @Override
    public boolean isPackageVisible(String packageName, boolean checkParents) throws IOException {
        String attrVal;
        boolean[] changed = new boolean[1];
        Manifest manifest = this.possiblyReloadJar(changed);
        if (manifest == null) {
            return true;
        }
        if (packageName != null && packageName.length() > 0) {
            if (!(packageName = packageName.replace('.', '/')).endsWith("/")) {
                packageName = packageName + "/";
            }
            int x = packageName.lastIndexOf(47);
            while (x != -1) {
                String attrVal2;
                Attributes attrs = manifest.getAttributes(packageName);
                if (attrs != null && (attrVal2 = attrs.getValue(DescriptorConstants.DESIGN_VISIBILITY)) != null) {
                    return "false".equals(attrVal2) ^ true;
                }
                if (!checkParents) {
                    return true;
                }
                if ((x = (packageName = packageName.substring(0, x)).lastIndexOf(47)) == -1) continue;
                packageName = packageName.substring(0, x + 1);
            }
            if (!checkParents) {
                return true;
            }
        }
        if ((attrVal = manifest.getMainAttributes().getValue(DescriptorConstants.DESIGN_VISIBILITY)) != null) {
            return "false".equals(attrVal) ^ true;
        }
        return this.isDescriptorVisible((String[])null, false);
    }

    private String getFromBundles(String key, String cachedValue) throws IOException {
        boolean[] changed = new boolean[1];
        Collection<String> bundleClasses = this.possiblyReloadBundles(changed);
        if (bundleClasses.size() == 0) {
            return cachedValue;
        }
        if (changed[0] || cachedValue == null) {
            Locale locale = this.getLocale();
            ClassLoader loader = this.getClassLoader();
            for (String bundleClass : bundleClasses) {
                try {
                    ResourceBundle jarBundle = ResourceBundle.getBundle(bundleClass, locale, loader);
                    cachedValue = jarBundle.getString(key);
                    if (cachedValue == null || cachedValue.length() <= 0) continue;
                    break;
                }
                catch (MissingResourceException mre) {
                    Logger logger = this.getLogger();
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "BundleClass: \"" + bundleClass + "\", key: \"" + key + "\", " + mre.toString());
                }
                catch (RuntimeException rte) {
                    Logger logger = this.getLogger();
                    logger.warning(bundleClass);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    rte.printStackTrace();
                }
            }
        }
        return cachedValue;
    }

    private Locale getLocale() {
        Locale locale = this.getADFCurrentLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private Locale getADFCurrentLocale() {
        if (dontTryADFContextAgain) {
            return null;
        }
        try {
            Object locale;
            Object context;
            if (adfGetLocaleMeth == null) {
                Class contextClazz = ClassUtils.forName("oracle.adf.share.ADFContext");
                adfGetCurrentMeth = contextClazz.getMethod("getCurrent", null);
                adfGetLocaleMeth = contextClazz.getMethod("getLocale", null);
            }
            if ((context = adfGetCurrentMeth.invoke(null, null)) != null && (locale = adfGetLocaleMeth.invoke(context, null)) instanceof Locale) {
                Locale locale2 = (Locale)locale;
                return locale2;
            }
        }
        catch (Throwable t) {
            if (adfGetLocaleMeth == null) {
                dontTryADFContextAgain = true;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Continuing without ADFContext.getLocale", t);
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = ClassUtils.getClassLoader(this.getClass());
        try {
            ClassLoader ldr = (ClassLoader)this.mNamingContext.getEnvironment().get("oracle.adf.share.services.providerLoader");
            if (ldr != null) {
                loader = ldr;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return loader;
    }

    private Collection<String> possiblyReloadBundles(boolean[] changed) throws IOException {
        Collection<String> bundleClasses = Collections.emptyList();
        changed[0] = false;
        Manifest manifest = this.possiblyReloadJar(changed);
        if (manifest != null) {
            if (changed[0] || this.mMainAttributes == null) {
                Object bundlesObj;
                this.mMainAttributes = null;
                this.mBundleClasses = null;
                Attributes mainAttributes = manifest.getMainAttributes();
                if (mainAttributes != null && (bundlesObj = mainAttributes.get(DescriptorConstants.BUNDLE_CLASSES)) != null) {
                    bundleClasses = Arrays.asList(bundlesObj.toString().split(" "));
                    changed[0] = true;
                }
                this.mBundleClasses = bundleClasses;
                this.mMainAttributes = mainAttributes;
            } else {
                bundleClasses = this.mBundleClasses;
            }
        }
        return bundleClasses;
    }

    private String simpleJarName(URL jarURL) {
        if (jarURL == null) {
            return null;
        }
        String jarStr = jarURL.getPath();
        if (jarStr.endsWith("!/")) {
            jarStr = jarStr.substring(0, jarStr.length() - 2);
        }
        return jarStr.substring(jarStr.lastIndexOf(47) + 1);
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.possiblyReloadJar(new boolean[1]);
    }

    private Manifest possiblyReloadJar(boolean[] changed) throws IOException {
        URL jarURL = this.getInternalJarURL();
        if (jarURL == null) {
            return null;
        }
        long lastModified = -1;
        Manifest manifest = this.mManifest;
        if (manifest == null || (lastModified = this.getLastModified(jarURL)) != this.mLastModified) {
            this.mManifest = null;
            this.mLastModified = -1;
            JarFile jarFile = this.getJarFile(jarURL);
            try {
                manifest = jarFile == null ? null : jarFile.getManifest();
                changed[0] = true;
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException ee) {}
            }
            this.mLastModified = lastModified != (long)-1 ? lastModified : this.getLastModified(jarURL);
            this.mManifest = manifest;
        }
        return manifest;
    }

    private URL getInternalJarURL() throws MalformedURLException {
        URL jarURL = this.getJarURL();
        if (jarURL == null) {
            return jarURL;
        }
        return this.getOpenableURL(jarURL);
    }

    private long getLastModified(URL jarURL) throws IOException {
        File jarFile = new File(this.toURI(jarURL));
        return jarFile.lastModified();
    }

    private JarFile getJarFile(URL jarURL) throws IOException {
        return new JarFile(new File(this.toURI(jarURL)));
    }

    private URI toURI(URL jarURL) throws IOException {
        try {
            URI uRI = jarURL.toURI();
            return uRI;
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException(jarURL.toString());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private URL getOpenableURL(URL jarURL) throws MalformedURLException {
        if (jarURL == null) {
            return null;
        }
        String jarURLStr = jarURL.toString();
        int bang = jarURLStr.lastIndexOf("!/");
        if (bang != -1) {
            jarURLStr = jarURLStr.substring("jar:".length(), bang);
            jarURL = new URL(jarURLStr);
        }
        return jarURL;
    }

    public int hashCode() {
        try {
            URL jarURL = this.getOpenableURL(this.getJarURL());
            if (jarURL != null) {
                int n = jarURL.hashCode();
                return n;
            }
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "", e);
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        try {
            URL jarURL = this.getOpenableURL(this.getJarURL());
            if (jarURL != null) {
                if (obj instanceof DescriptorContext) {
                    boolean bl = jarURL.equals(this.getOpenableURL(((DescriptorContext)obj).getJarURL()));
                    return bl;
                }
                if (obj instanceof URL) {
                    boolean bl = jarURL.equals(obj);
                    return bl;
                }
            }
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "", e);
        }
        return super.equals(obj);
    }

    public String toString() {
        String jarName = this.getJarURL() == null ? "null" : this.simpleJarName(this.getJarURL());
        return this.getClass().getName() + "|" + jarName + "|" + System.identityHashCode(this);
    }
}

