/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services;

import java.awt.Component;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.adf.share.common.ClassUtils;

public class ResourceIcon
implements Icon {
    static final /* synthetic */ boolean $assertionsDisabled;
    private Icon mIcon;
    private String mSourceUri;
    private String mDescription;
    private String mRuntimeUri;

    static {
        $assertionsDisabled = ResourceIcon.class.desiredAssertionStatus() ^ true;
    }

    public ResourceIcon(String source) {
        this.$init$();
        if (!($assertionsDisabled || source != null && source.length() > 0)) {
            throw new AssertionError();
        }
        this.mSourceUri = source;
    }

    public ResourceIcon(String source, String description) {
        this(source);
        this.mDescription = description;
    }

    public int getIconWidth() {
        Icon icon = this.getIcon();
        return icon.getIconWidth();
    }

    public int getIconHeight() {
        Icon icon = this.getIcon();
        return icon.getIconHeight();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.getIcon();
        icon.paintIcon(c, g, x, y);
    }

    public String getRuntimeUri() {
        if (this.mRuntimeUri == null) {
            int startIdx = this.mSourceUri.indexOf("META-INF");
            this.mRuntimeUri = startIdx >= 0 ? this.mSourceUri.substring(startIdx + 8) : this.mSourceUri;
        }
        return this.mRuntimeUri;
    }

    public String getDescription() {
        return this.mDescription;
    }

    private Icon getIcon() {
        ClassLoader ldr;
        URL iconUrl;
        if (this.mIcon == null && (iconUrl = (ldr = ClassUtils.getClassLoader()).getResource(this.mSourceUri)) != null) {
            this.mIcon = new ImageIcon(iconUrl, this.mDescription);
        }
        return this.mIcon;
    }

    private void $init$() {
        this.mIcon = null;
        this.mSourceUri = null;
        this.mDescription = null;
        this.mRuntimeUri = null;
    }
}

