/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.services.DefaultDescriptorContext;
import oracle.adf.share.services.ResourceServiceStrategy;
import oracle.adf.share.services.ServicePlugin;
import oracle.adf.share.services.ServiceRef;
import oracle.adf.share.services.Services;
import oracle.adf.share.services.ServicesFactory;
import oracle.adf.share.services.URLDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceService {
    public static final String SERVICE_NAME = "oracle.adf.common.services.ResourceService";
    public static final String WILDCARD_TYPE = "*";
    private static final Collection<URLDescriptor> emptyDescrs = Collections.unmodifiableList(Collections.emptyList());
    private static final Collection<ServicePlugin> emptyPlugins = Collections.unmodifiableList(Collections.emptyList());
    private static final Logger logger = Logger.getLogger(ResourceService.class.getName());

    public Collection<URLDescriptor> getResourcesForType(ClassLoader classLoader, String resourceType) {
        if (classLoader == null) {
            return emptyDescrs;
        }
        ArrayList<URLDescriptor> descriptors = new ArrayList<URLDescriptor>();
        try {
            for (ServiceRef ref : ServicesFactory.findServiceRefs(SERVICE_NAME, classLoader)) {
                Services svcObj = ref.getService();
                if (!(svcObj instanceof Services)) continue;
                Services binding = svcObj;
                DefaultDescriptorContext context = new DefaultDescriptorContext(this.getBaseURL(binding.getServiceURL()));
                for (ServicePlugin plugin : binding.getPlugins()) {
                    if (!WILDCARD_TYPE.equals(resourceType) && !plugin.getServiceType().equals(resourceType)) continue;
                    ResourceServiceStrategy strategy = null;
                    try {
                        strategy = plugin.getServiceStrategy(context);
                    }
                    catch (RuntimeException x) {
                        logger.log(Level.INFO, plugin.getServiceType(), x);
                    }
                    catch (ClassNotFoundException e) {
                        this.logBackwardCompatibilityAllowance(plugin);
                    }
                    if (strategy == null) continue;
                    descriptors.addAll(strategy.getResources(context));
                }
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return descriptors.size() > 0 ? Collections.unmodifiableList(descriptors) : emptyDescrs;
    }

    private void logBackwardCompatibilityAllowance(ServicePlugin plugin) {
        logger.info("Ignored missing resource strategy: " + plugin);
    }

    public Collection<URLDescriptor> getResourcesForType(String resourceType) {
        ClassLoader cl = ClassUtils.getClassLoader();
        return this.getResourcesForType(cl, resourceType);
    }

    public Collection<ServicePlugin> getPluginsForType(ClassLoader classLoader, String resourceType) throws IOException {
        if (classLoader == null) {
            return emptyPlugins;
        }
        ArrayList<ServicePlugin> plugins = new ArrayList<ServicePlugin>();
        for (ServiceRef ref : ServicesFactory.findServiceRefs(SERVICE_NAME, classLoader)) {
            Services svcObj = ref.getService();
            if (!(svcObj instanceof Services)) continue;
            Services binding = svcObj;
            for (ServicePlugin plugin : binding.getPlugins()) {
                if (!WILDCARD_TYPE.equals(resourceType) && !plugin.getServiceType().equals(resourceType)) continue;
                plugins.add(plugin);
            }
        }
        return plugins.size() > 0 ? Collections.unmodifiableList(plugins) : emptyPlugins;
    }

    private URL getBaseURL(URL jarUrl) {
        URL ret = null;
        try {
            String path = jarUrl.toExternalForm();
            int lastIndex = path.lastIndexOf(ServicesFactory.getServiceFileName(SERVICE_NAME));
            if (lastIndex >= 0) {
                String baseUrl_str = path.substring(0, lastIndex);
                ret = new URL(baseUrl_str);
            }
            URL uRL = ret;
            return uRL;
        }
        catch (MalformedURLException e) {
            URL uRL = null;
            return uRL;
        }
    }
}

