/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.services.DescriptorContext;
import oracle.adf.share.services.ResourceServiceStrategy;

public class ServicePlugin {
    protected String serviceType;
    protected String strategyClassName;
    protected String remainder;
    protected ResourceServiceStrategy strategyInstance;

    public ServicePlugin(String serviceLine) {
        this.$init$();
        serviceLine = serviceLine.trim();
        int i = serviceLine.indexOf(32);
        if (i == -1) {
            throw new IllegalArgumentException(serviceLine);
        }
        int j = serviceLine.indexOf(32, i + 1);
        if (j == -1) {
            j = serviceLine.length();
        } else {
            this.remainder = serviceLine.substring(j + 1);
        }
        this.strategyClassName = serviceLine.substring(0, i);
        this.serviceType = serviceLine.substring(i + 1, j);
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getStrategyClassName() {
        return this.strategyClassName;
    }

    public String getRemainder() {
        return this.remainder;
    }

    public String getToolTipText() {
        return null;
    }

    public ResourceServiceStrategy getServiceStrategy(DescriptorContext ctx) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.strategyInstance == null) {
            Class strategyClass = ClassUtils.forName(this.strategyClassName);
            try {
                Constructor ctor = strategyClass.getConstructor(DescriptorContext.class);
                ResourceServiceStrategy resourceServiceStrategy = this.strategyInstance = (ResourceServiceStrategy)ctor.newInstance(ctx);
                return resourceServiceStrategy;
            }
            catch (NoSuchMethodException nsme) {
                this.strategyInstance = (ResourceServiceStrategy)strategyClass.newInstance();
            }
        }
        return this.strategyInstance;
    }

    public void setServiceStrategy(ResourceServiceStrategy instance) {
        if (this.strategyInstance != null) {
            throw new IllegalStateException();
        }
        this.strategyInstance = instance;
    }

    public int hashCode() {
        return this.serviceType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ServicePlugin) {
            return this.serviceType.equals(((ServicePlugin)obj).serviceType);
        }
        return this.serviceType.equals(obj);
    }

    public String toString() {
        if (this.remainder == null) {
            return this.strategyClassName + " " + this.serviceType;
        }
        return this.strategyClassName + " " + this.serviceType + " " + this.remainder;
    }

    private void $init$() {
        this.serviceType = null;
        this.strategyClassName = null;
        this.remainder = null;
        this.strategyInstance = null;
    }
}

