/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services.impl;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.services.ServicePlugin;
import oracle.adf.share.services.Services;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADFServicesImpl
implements Services {
    private List<ServicePlugin> plugins;
    private URL url;

    private void $init$() {
        this.plugins = null;
        this.url = null;
    }

    public ADFServicesImpl(URL url, Enumeration svcs) {
        this.$init$();
        this.url = url;
        this.plugins = new ArrayList<ServicePlugin>(6);
        while (svcs.hasMoreElements()) {
            ServicePlugin plugin = new ServicePlugin(svcs.nextElement().toString());
            String remainder = plugin.getRemainder();
            if (remainder != null) {
                plugin = this.loadExtendsPlugin(plugin);
            }
            this.plugins.add(plugin);
        }
    }

    private ServicePlugin loadExtendsPlugin(ServicePlugin plugin) {
        try {
            Class clazz = ClassUtils.forName(plugin.getRemainder());
            Class[] paramTypes = new Class[]{String.class};
            Constructor ctor = clazz.getConstructor(paramTypes);
            Object[] params = new Object[]{plugin.toString()};
            ServicePlugin servicePlugin = (ServicePlugin)ctor.newInstance(params);
            return servicePlugin;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ServicePlugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public URL getServiceURL() {
        return this.url;
    }
}

