/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services.jndi;

import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;

public final class DescriptorNameParser
implements NameParser {
    private static final Properties syntax = DescriptorNameParser.initSyntax();

    private static Properties initSyntax() {
        Properties props = new Properties();
        props.put("jndi.syntax.direction", "left_to_right");
        props.put("jndi.syntax.separator", "|");
        props.put("jndi.syntax.ignorecase", "false");
        props.put("jndi.syntax.trimblanks", "true");
        props.put("jndi.syntax.escape", "\\");
        props.put("jndi.syntax.beginquote", "\"");
        props.put("jndi.syntax.beginquote2", "'");
        return props;
    }

    public Name parse(String name) throws NamingException {
        return new CompoundName(name, syntax);
    }

    public boolean equals(Object obj) {
        return obj instanceof DescriptorNameParser;
    }

    public String toString() {
        return this.getClass().getName() + " " + syntax.toString();
    }
}

