/*
 * Decompiled with CFR 0.152.
 */
package javax.ide;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.ide.IDEEvent;
import javax.ide.IDEListener;
import javax.ide.Service;
import javax.ide.build.BuildSystem;
import javax.ide.command.CommandProcessor;
import javax.ide.debug.Debugger;
import javax.ide.editor.EditorManager;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.log.LogManager;
import javax.ide.menu.ActionRegistry;
import javax.ide.model.DocumentFactory;
import javax.ide.property.PropertyPageRegistry;
import javax.ide.spi.IDEListenerHook;
import javax.ide.spi.ProviderNotFoundException;
import javax.ide.util.MetaClass;
import javax.ide.util.Version;
import javax.ide.view.GUIUtilities;
import javax.ide.view.View;
import javax.ide.wizard.WizardManager;

public abstract class IDE
extends Service {
    private static final Version EDK_VERSION = new Version("1.0");
    private final Collection _listeners;

    private void $init$() {
        this._listeners = new ArrayList();
    }

    public abstract String getProductName();

    public abstract View getMainWindow();

    public abstract View getActiveView();

    public Version getEDKVersion() {
        return EDK_VERSION;
    }

    public abstract URI getUserHome();

    public final ActionRegistry getActionRegistry() {
        return ActionRegistry.getActionRegistry();
    }

    public final ExtensionRegistry getExtensionRegistry() {
        return ExtensionRegistry.getExtensionRegistry();
    }

    public final DocumentFactory getDocumentFactory() {
        return DocumentFactory.getDocumentFactory();
    }

    public final EditorManager getEditorManager() {
        return EditorManager.getEditorManager();
    }

    public final CommandProcessor getCommandProcessor() {
        return CommandProcessor.getCommandProcessor();
    }

    public final LogManager getLogManager() {
        return LogManager.getLogManager();
    }

    public final WizardManager getWizardManager() {
        return WizardManager.getWizardManager();
    }

    public final Debugger getDebugger() {
        return Debugger.getDebugger();
    }

    public final BuildSystem getBuildSystem() {
        return BuildSystem.getBuildSystem();
    }

    public final PropertyPageRegistry getPropertyPageRegistry() {
        return PropertyPageRegistry.getPropertyPageRegistry();
    }

    public final GUIUtilities getGUIUtilities() {
        return GUIUtilities.getGUIUtilities();
    }

    protected final void addIDEListener(IDEListener listener) {
        this._listeners.add(listener);
    }

    protected final void fireIDEActivated() {
        ArrayList listeners = new ArrayList(this._listeners);
        IDEEvent event = new IDEEvent(this);
        for (IDEListener listener : listeners) {
            listener.activated(event);
        }
    }

    protected final void fireIDEDeactivated() {
        ArrayList listeners = new ArrayList(this._listeners);
        IDEEvent event = new IDEEvent(this);
        for (IDEListener listener : listeners) {
            listener.deactivated(event);
        }
    }

    protected void initialize() {
        IDEListenerHook hook = (IDEListenerHook)ExtensionRegistry.getExtensionRegistry().getHook(IDEListenerHook.ELEMENT);
        Collection listeners = hook.getListeners();
        for (MetaClass mc : listeners) {
            try {
                IDEListener ideListener = (IDEListener)mc.newInstance();
                this.addIDEListener(ideListener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final IDE getIDE() {
        try {
            IDE iDE = (IDE)IDE.getService(IDE.class);
            return iDE;
        }
        catch (ProviderNotFoundException nse) {
            nse.printStackTrace();
            throw new IllegalStateException("No IDE service");
        }
    }

    public IDE() {
        this.$init$();
    }
}

