/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.Service;
import javax.ide.command.Context;
import javax.ide.editor.Editor;
import javax.ide.editor.EditorEvent;
import javax.ide.editor.EditorListener;
import javax.ide.editor.spi.EditorHook;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.model.Document;
import javax.ide.spi.ProviderNotFoundException;
import javax.ide.util.MetaClass;

public abstract class EditorManager
extends Service {
    private final Map _listenerMap;
    private boolean _initializedHookListeners;

    private void $init$() {
        this._listenerMap = new HashMap();
        this._initializedHookListeners = false;
    }

    public abstract Editor getActiveEditor();

    public abstract Set getAllOpenEditors();

    public boolean isOpen(Document document) {
        if (document == null) {
            throw new NullPointerException("document is null.");
        }
        for (Editor thisEditor : this.getAllOpenEditors()) {
            if (!document.equals(thisEditor.getContext().getDocument())) continue;
            return true;
        }
        return false;
    }

    public Set getOpenEditors(Document document) {
        if (document == null) {
            throw new NullPointerException("document is null.");
        }
        HashSet<Editor> editors = new HashSet<Editor>();
        for (Editor thisEditor : this.getAllOpenEditors()) {
            if (!document.equals(thisEditor.getContext().getDocument())) continue;
            editors.add(thisEditor);
        }
        return Collections.unmodifiableSet(editors);
    }

    public abstract Editor openEditor(Context var1, String var2);

    public abstract void closeEditor(Editor var1);

    public final void addEditorListener(EditorListener listener, String editorClass) {
        ArrayList<EditorListener> listeners;
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (editorClass == null) {
            editorClass = "_anyListener";
        }
        if ((listeners = (ArrayList<EditorListener>)this._listenerMap.get(editorClass)) == null) {
            listeners = new ArrayList<EditorListener>();
            this._listenerMap.put(editorClass, listeners);
        }
        listeners.add(listener);
    }

    public final void removeEditorListener(EditorListener l, String editorClass) {
        List listeners;
        if (editorClass == null) {
            editorClass = "_anyListener";
        }
        if ((listeners = (List)this._listenerMap.get(editorClass)) == null) {
            throw new IllegalArgumentException("No listeners are registered for editor type " + editorClass);
        }
        listeners.remove(l);
    }

    private final Collection getListeners(Editor editor) {
        this.initializeHookListeners();
        List listeners = (List)this._listenerMap.get(editor.getClass().getName());
        List allListeners = (List)this._listenerMap.get("_anyListener");
        ArrayList fullList = new ArrayList();
        if (listeners != null) {
            fullList.addAll(listeners);
        }
        if (allListeners != null) {
            fullList.addAll(allListeners);
        }
        return fullList;
    }

    protected final void fireEditorOpened(Editor editor) {
        Collection listeners = this.getListeners(editor);
        if (!listeners.isEmpty()) {
            EditorEvent event = new EditorEvent(editor);
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                ((EditorListener)i.next()).opened(event);
            }
        }
    }

    protected final void fireEditorClosed(Editor editor) {
        Collection listeners = this.getListeners(editor);
        if (!listeners.isEmpty()) {
            EditorEvent event = new EditorEvent(editor);
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                ((EditorListener)i.next()).closed(event);
            }
        }
    }

    protected final void fireEditorActivated(Editor editor) {
        Collection listeners = this.getListeners(editor);
        if (!listeners.isEmpty()) {
            EditorEvent event = new EditorEvent(editor);
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                ((EditorListener)i.next()).activated(event);
            }
        }
    }

    protected final void fireEditorDeactivated(Editor editor) {
        Collection listeners = this.getListeners(editor);
        if (!listeners.isEmpty()) {
            EditorEvent event = new EditorEvent(editor);
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                ((EditorListener)i.next()).deactivated(event);
            }
        }
    }

    private void initializeHookListeners() {
        if (!this._initializedHookListeners) {
            try {
                EditorHook editorHook = (EditorHook)ExtensionRegistry.getExtensionRegistry().getHook(EditorHook.ELEMENT);
                Map listeners = editorHook.getListeners();
                for (String key : listeners.keySet()) {
                    Collection listenerClasses = (Collection)listeners.get(key);
                    for (MetaClass thisClass : listenerClasses) {
                        try {
                            EditorListener el = (EditorListener)thisClass.newInstance();
                            this.addEditorListener(el, key);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            finally {
                this._initializedHookListeners = true;
            }
        }
    }

    public static EditorManager getEditorManager() {
        try {
            EditorManager editorManager = (EditorManager)EditorManager.getService(EditorManager.class);
            return editorManager;
        }
        catch (ProviderNotFoundException nse) {
            nse.printStackTrace();
            throw new IllegalStateException("No editor manager.");
        }
    }

    public EditorManager() {
        this.$init$();
    }
}

