/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.editor.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.editor.spi.DisplayInfo;
import javax.ide.editor.spi.MappingInfo;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.util.MetaClass;

public final class EditorHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor-hook");
    private static final ElementName EDITORS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editors");
    private static final ElementName EDITOR = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor");
    private static final ElementName NAME = new ElementName("http://jcp.org/jsr/198/extension-manifest", "name");
    private static final ElementName MAPPINGS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "mappings");
    private static final ElementName MAPPING = new ElementName("http://jcp.org/jsr/198/extension-manifest", "mapping");
    private static final ElementName OPEN_WITH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "open-with");
    private static final ElementName LISTENERS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor-listeners");
    private static final ElementName EDITOR_LISTENER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor-listener");
    private ElementVisitor _editorsVisitor;
    private ElementVisitor _editorVisitor;
    private ElementVisitor _mappingsVisitor;
    private ElementVisitor _mappingVisitor;
    private ElementVisitor _openWithVisitor;
    private ElementVisitor _listenersVisitor;
    private ElementVisitor _listenerVisitor;
    private static final String KEY_DOCUMENT_CLASS = "documentClass";
    private static final String KEY_OPEN_WITH_COLL = "openWithColl";
    public static final String ANY_EDITOR_CLASS = "_anyListener";
    private Map _editorsByClassName;
    private Map _mappings;
    private Map _listeners;
    private Map _editorDisplayInfo;

    private void $init$() {
        this._editorsVisitor = new EditorsVisitor(null);
        this._editorVisitor = new EditorVisitor(null);
        this._mappingsVisitor = new MappingsVisitor(null);
        this._mappingVisitor = new MappingVisitor(null);
        this._openWithVisitor = new OpenWithVisitor(null);
        this._listenersVisitor = new ListenersVisitor(null);
        this._listenerVisitor = new ListenerVisitor(null);
        this._editorsByClassName = new HashMap();
        this._mappings = new HashMap();
        this._listeners = new HashMap();
        this._editorDisplayInfo = new HashMap();
    }

    public DisplayInfo getDisplayInfo(MetaClass editorClass) {
        return (DisplayInfo)this._editorDisplayInfo.get(editorClass);
    }

    public Collection getEditors() {
        return this._editorsByClassName.values();
    }

    public MetaClass getEditorClass(String className) {
        return (MetaClass)this._editorsByClassName.get(className);
    }

    public Collection getMappedDocumentClasses() {
        return this._mappings.keySet();
    }

    public Collection getEditorsForDocClass(Class documentClass) {
        return (Collection)this._mappings.get(documentClass.getName());
    }

    public Map getListeners() {
        return this._listeners;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(EDITORS, this._editorsVisitor);
        context.registerChildVisitor(MAPPINGS, this._mappingsVisitor);
        context.registerChildVisitor(LISTENERS, this._listenersVisitor);
    }

    public EditorHook() {
        this.$init$();
    }

    static ElementName ra$EDITOR() {
        return EDITOR;
    }

    static ElementVisitor ra$_editorVisitor(EditorHook editorHook) {
        return editorHook._editorVisitor;
    }

    static Map ra$_editorsByClassName(EditorHook editorHook) {
        return editorHook._editorsByClassName;
    }

    static ElementName ra$NAME() {
        return NAME;
    }

    static ElementName ra$MAPPING() {
        return MAPPING;
    }

    static ElementVisitor ra$_mappingVisitor(EditorHook editorHook) {
        return editorHook._mappingVisitor;
    }

    static Map ra$_mappings(EditorHook editorHook) {
        return editorHook._mappings;
    }

    static ElementName ra$OPEN_WITH() {
        return OPEN_WITH;
    }

    static ElementVisitor ra$_openWithVisitor(EditorHook editorHook) {
        return editorHook._openWithVisitor;
    }

    static ElementName ra$EDITOR_LISTENER() {
        return EDITOR_LISTENER;
    }

    static ElementVisitor ra$_listenerVisitor(EditorHook editorHook) {
        return editorHook._listenerVisitor;
    }

    static Map ra$_listeners(EditorHook editorHook) {
        return editorHook._listeners;
    }

    static Map ra$_editorDisplayInfo(EditorHook editorHook) {
        return editorHook._editorDisplayInfo;
    }

    private class EditorsVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(EditorHook.ra$EDITOR(), EditorHook.ra$_editorVisitor(EditorHook.this));
        }

        private EditorsVisitor() {
        }

        EditorsVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class EditorVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String editorClass = context.getAttributeValue("editor-class");
            if (editorClass == null || (editorClass = editorClass.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required 'editor-class' attribute.");
                return;
            }
            ClassLoader cl = (ClassLoader)context.getScopeData().get("classLoader");
            MetaClass editorMetaClass = new MetaClass(cl, editorClass);
            EditorHook.ra$_editorsByClassName(EditorHook.this).put(editorClass, editorMetaClass);
            context.registerChildVisitor(EditorHook.ra$NAME(), new 1(this, editorMetaClass));
        }

        private EditorVisitor() {
        }

        EditorVisitor(1 var2_2) {
            this();
        }

        final class 1
        extends I18NStringVisitor {
            private final /* synthetic */ MetaClass v$editorMetaClass;
            final /* synthetic */ EditorVisitor this$0;

            protected void string(ElementContext context, String text) {
                EditorHook.ra$_editorDisplayInfo(this.this$0.EditorHook.this).put(this.v$editorMetaClass, new DisplayInfo(text));
            }

            public 1(EditorVisitor editorVisitor, MetaClass metaClass) {
                this.v$editorMetaClass = metaClass;
                this.this$0 = editorVisitor;
            }
        }
    }

    private class MappingsVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(EditorHook.ra$MAPPING(), EditorHook.ra$_mappingVisitor(EditorHook.this));
        }

        private MappingsVisitor() {
        }

        MappingsVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class MappingVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String docClass = context.getAttributeValue("document-class");
            if (docClass == null || (docClass = docClass.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required 'document-class' attribute.");
            } else {
                context.getScopeData().put(EditorHook.KEY_DOCUMENT_CLASS, docClass);
                ArrayList mappings = (ArrayList)EditorHook.ra$_mappings(EditorHook.this).get(docClass);
                if (mappings == null) {
                    mappings = new ArrayList();
                    EditorHook.ra$_mappings(EditorHook.this).put(docClass, mappings);
                }
                context.getScopeData().put(EditorHook.KEY_OPEN_WITH_COLL, mappings);
                context.registerChildVisitor(EditorHook.ra$OPEN_WITH(), EditorHook.ra$_openWithVisitor(EditorHook.this));
            }
        }

        private MappingVisitor() {
        }

        MappingVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class OpenWithVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String editorClass = context.getAttributeValue("editor-class");
            if (editorClass == null || (editorClass = editorClass.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'editor-class'");
                return;
            }
            String isPreferred = context.getAttributeValue("preferred");
            boolean preferred = isPreferred == null ? false : Boolean.valueOf(isPreferred);
            MappingInfo mi = new MappingInfo(editorClass, preferred);
            List mappings = (List)context.getScopeData().get(EditorHook.KEY_OPEN_WITH_COLL);
            mappings.add(mi);
        }

        private OpenWithVisitor() {
        }

        OpenWithVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ListenersVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(EditorHook.ra$EDITOR_LISTENER(), EditorHook.ra$_listenerVisitor(EditorHook.this));
        }

        private ListenersVisitor() {
        }

        ListenersVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ListenerVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            ArrayList listeners;
            String sourceClass = context.getAttributeValue("source-class");
            String listenerClass = context.getAttributeValue("listener-class");
            if (listenerClass == null) {
                this.log(context, Level.SEVERE, "Required attribute 'listener-class' missing.");
                return;
            }
            ClassLoader cl = (ClassLoader)context.getScopeData().get("classLoader");
            MetaClass mc = new MetaClass(cl, listenerClass);
            if (sourceClass == null) {
                sourceClass = EditorHook.ANY_EDITOR_CLASS;
            }
            if ((listeners = (ArrayList)EditorHook.ra$_listeners(EditorHook.this).get(sourceClass)) == null) {
                listeners = new ArrayList();
                EditorHook.ra$_listeners(EditorHook.this).put(sourceClass, listeners);
            }
            listeners.add(mc);
        }

        private ListenerVisitor() {
        }

        ListenerVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

