/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.Stack;

public class DynamicHook
extends ExtensionHook {
    public final String sApplicationObjectKey;
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String SET_METHOD_PREFIX = "set";
    private static final String ADD_METHOD_PREFIX = "add";
    private static final Class[] sObjectParamTypes = new Class[]{Object.class};
    private static final Class[] sStringParamTypes = new Class[]{String.class};
    private final Stack _applicationObjectStack;
    private final Stack _complexTypeIndicatorStack;
    private ClassLoader _classLoader;
    private final List _resolvers;

    private void $init$() {
        this.sApplicationObjectKey = DynamicHook.class.getName() + ".appObjectKey";
        this._applicationObjectStack = new Stack();
        this._complexTypeIndicatorStack = new Stack();
        this._resolvers = new ArrayList(5);
    }

    public DynamicHook(Object rootObject) {
        this.$init$();
        this._applicationObjectStack.push(rootObject);
    }

    public DynamicHook(Object rootObject, ClassLoader classLoader) {
        this(rootObject);
        this._classLoader = classLoader;
    }

    public DynamicHook(Object rootObject, ClassLoader classLoader, ElementTypeResolver resolver) {
        this(rootObject, classLoader);
        this._resolvers.add(resolver);
    }

    public void registerElementTypeResolver(ElementTypeResolver resolver) {
        this._resolvers.add(resolver);
    }

    public void start(ElementStartContext context) {
        Class runtimeType = this.getRuntimeType(context);
        this._complexTypeIndicatorStack.push(new boolean[]{runtimeType != null});
        if (runtimeType != null) {
            Object o = this.getApplicationObject(runtimeType, context);
            this.invokePreInitialize(this._applicationObjectStack.peek(), o);
            this._applicationObjectStack.push(o);
            context.getScopeData().put(this.sApplicationObjectKey, o);
            this.handleComplexElementStart(o, context);
        } else {
            this.handleSimpleElementStart(context);
        }
    }

    public void end(ElementEndContext context) {
        boolean isComplex = ((boolean[])this._complexTypeIndicatorStack.pop())[0];
        if (isComplex) {
            Object child = this._applicationObjectStack.pop();
            this.invokePostInitialize(child);
            this.attachObject(this._applicationObjectStack.peek(), child, context);
            this.handleComplexElementEnd(context);
        } else {
            this.attachData(this._applicationObjectStack.peek(), context.getText(), context);
            this.handleSimpleElementEnd(context);
        }
    }

    protected void handleComplexElementStart(Object applicationObject, ElementStartContext context) {
    }

    protected void handleComplexElementEnd(ElementEndContext context) {
    }

    protected void handleSimpleElementStart(ElementStartContext context) {
    }

    protected void handleSimpleElementEnd(ElementEndContext context) {
    }

    protected Class getRuntimeType(ElementStartContext context) {
        Class type = null;
        String classAttribute = context.getAttributeValue(ATTRIBUTE_CLASS);
        if (classAttribute != null) {
            try {
                type = Class.forName(classAttribute, true, this._classLoader != null ? this._classLoader : Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                this.log(context, Level.SEVERE, "Unable to load class: " + classAttribute);
            }
        } else {
            ListIterator it = this._resolvers.listIterator(this._resolvers.size());
            while (it.hasPrevious() && type == null) {
                type = ((ElementTypeResolver)it.previous()).resolveType(context.getElementName());
            }
        }
        return type;
    }

    protected Object getApplicationObject(Class runtimeType, ElementStartContext context) {
        try {
            Object t = runtimeType.newInstance();
            return t;
        }
        catch (Exception e) {
            this.log(context, Level.SEVERE, "Unable to instantiate class: " + runtimeType.getName());
            e.printStackTrace();
            Object var5_5 = null;
            return var5_5;
        }
    }

    protected void attachObject(Object parent, Object child, ElementEndContext context) {
        Method m = this.findMethod(context, parent, context.getElementName().getLocalName(), sObjectParamTypes);
        try {
            m.invoke(parent, child);
        }
        catch (InvocationTargetException ite) {
            StringBuffer b = new StringBuffer(200);
            b.append("Could not attach child object: ").append(child.toString());
            b.append(" to parent: ").append(parent.toString());
            b.append(". Root cause: ");
            b.append(ite.getTargetException().getClass().getName()).append(": ");
            b.append(ite.getTargetException().getMessage());
            this.log(context, Level.SEVERE, b.toString());
        }
        catch (Exception e) {
            StringBuffer b = new StringBuffer(200);
            b.append("Could not attach child object: ").append(child.toString());
            b.append(" to parent: ").append(parent.toString());
            b.append(". Root cause: ");
            b.append(e.getClass().getName()).append(": ").append(e.getMessage());
            this.log(context, Level.SEVERE, b.toString());
        }
    }

    protected void attachData(Object parent, String data, ElementEndContext context) {
        Method m = this.findMethod(context, parent, context.getElementName().getLocalName(), sStringParamTypes);
        try {
            m.invoke(parent, data);
        }
        catch (InvocationTargetException ite) {
            this.log(context, Level.SEVERE, "Unable to attach data '" + data + "' for simple element " + context.getElementName().getLocalName());
            ite.getTargetException().printStackTrace();
        }
        catch (Exception e) {
            this.log(context, Level.SEVERE, "Unable to attach data '" + data + "' for simple element " + context.getElementName().getLocalName());
            e.printStackTrace();
        }
    }

    protected void invokePreInitialize(Object child, Object parent) {
    }

    protected void invokePostInitialize(Object o) {
    }

    protected Method findMethod(ElementContext context, Object o, String elementName, Class[] paramTypes) {
        try {
            String methodName = this.getMethodName(SET_METHOD_PREFIX, elementName);
            Method method = o.getClass().getMethod(methodName, paramTypes);
            return method;
        }
        catch (NoSuchMethodException nsme) {
            try {
                String methodName = this.getMethodName(ADD_METHOD_PREFIX, elementName);
                Method method = o.getClass().getMethod(methodName, paramTypes);
                return method;
            }
            catch (NoSuchMethodException nme) {
                this.log(context, Level.SEVERE, "Class " + o.getClass().getName() + " has no set or add method for element named " + elementName);
                nme.printStackTrace();
                return null;
            }
        }
    }

    protected String getMethodName(String prefix, String elementName) {
        char[] name = new char[prefix.length() + elementName.length()];
        int i = 0;
        while (i < prefix.length()) {
            name[i] = prefix.charAt(i);
            ++i;
        }
        boolean nextUpper = true;
        int nameIndex = prefix.length();
        int i2 = 0;
        while (i2 < elementName.length()) {
            if (Character.isJavaIdentifierPart(elementName.charAt(i2))) {
                if (nextUpper) {
                    name[nameIndex] = Character.toUpperCase(elementName.charAt(i2));
                    nextUpper = false;
                } else {
                    name[nameIndex] = elementName.charAt(i2);
                }
                ++nameIndex;
            } else {
                nextUpper = true;
            }
            ++i2;
        }
        return new String(name).trim();
    }

    public static interface ElementTypeResolver {
        public Class resolveType(ElementName var1);
    }
}

