/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.spi.ExtensionLogRecord;

public abstract class ElementVisitor {
    public static final String KEY_LOCATOR = "xml.locator";

    protected final void log(ElementContext context, Level level, String msg) {
        context.getLogger().log(new ExtensionLogRecord(context, level, msg));
    }

    public void start(ElementStartContext context) {
    }

    public void end(ElementEndContext context) {
    }

    public static final ClassLoader getClassLoader(ElementContext context) {
        ClassLoader classLoader = (ClassLoader)context.getScopeData().get("classLoader");
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    public static final ResourceBundle getResourceBundle(ElementContext context) {
        ClassLoader classLoader = ElementVisitor.getClassLoader(context);
        String resClass = (String)context.getScopeData().get("rsbundleclass");
        if (resClass == null) {
            return null;
        }
        try {
            ResourceBundle bundle;
            ResourceBundle resourceBundle = bundle = ResourceBundle.getBundle(resClass, Locale.getDefault(), classLoader);
            return resourceBundle;
        }
        catch (MissingResourceException mre) {
            ResourceBundle resourceBundle = null;
            return resourceBundle;
        }
    }
}

